/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.init;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.povstalec.sgjourney.common.block_entities.ProtectedBlockEntity;
import net.povstalec.sgjourney.common.blocks.ProtectedBlock;
import net.povstalec.sgjourney.common.capabilities.AncientGene;
import net.povstalec.sgjourney.common.command.AddressArgumentInfo;
import net.povstalec.sgjourney.common.command.AddressArgumentType;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.data.ConduitNetworks;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.data.StargateNetworkSettings;
import net.povstalec.sgjourney.common.data.TransporterNetwork;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.Galaxy;
import net.povstalec.sgjourney.common.sgjourney.SolarSystem;
import net.povstalec.sgjourney.common.sgjourney.transporter.Transporter;

public class CommandInit {
    private static final String STARGATE_NETWORK = "stargateNetwork";
    private static final String TRANSPORTER_NETWORK = "transporterNetwork";
    private static final String GENE = "gene";
    public static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES = DeferredRegister.create((ResourceKey)Registries.COMMAND_ARGUMENT_TYPE, (String)"sgjourney");
    public static final DeferredHolder<ArgumentTypeInfo<?, ?>, ArgumentTypeInfo<AddressArgumentType, AddressArgumentInfo.Template>> ADDRESS_ARGUMENT = COMMAND_ARGUMENT_TYPES.register("address", () -> ArgumentTypeInfos.registerByClass(AddressArgumentType.class, (ArgumentTypeInfo)new AddressArgumentInfo()));

    public static void register(IEventBus eventBus) {
        COMMAND_ARGUMENT_TYPES.register(eventBus);
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)STARGATE_NETWORK).then(Commands.literal((String)"address").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(CommandInit::getAddress))))).requires(commandSourceStack -> commandSourceStack.hasPermission(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)STARGATE_NETWORK).then(Commands.literal((String)"extragalacticAddress").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(CommandInit::getExtragalacticAddress))))).requires(commandSourceStack -> commandSourceStack.hasPermission(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)STARGATE_NETWORK).then(Commands.literal((String)"getAllStargates").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(CommandInit::getStargates))))).requires(commandSourceStack -> commandSourceStack.hasPermission(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)STARGATE_NETWORK).then(Commands.literal((String)"primaryStargate").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).then(Commands.literal((String)"set").then(Commands.argument((String)"address", (ArgumentType)new AddressArgumentType(Address.Type.ADDRESS_9_CHEVRON)).executes(CommandInit::setPrimaryStargate))))))).requires(commandSourceStack -> commandSourceStack.hasPermission(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)STARGATE_NETWORK).then(Commands.literal((String)"primaryStargate").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).then(Commands.literal((String)"unset").executes(CommandInit::unsetPrimaryStargate)))))).requires(commandSourceStack -> commandSourceStack.hasPermission(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)STARGATE_NETWORK).then(Commands.literal((String)"primaryStargate").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).then(Commands.literal((String)"get").executes(CommandInit::getPrimaryStargate)))))).requires(commandSourceStack -> commandSourceStack.hasPermission(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)STARGATE_NETWORK).then(Commands.literal((String)"version").executes(CommandInit::getVersion)))).requires(commandSourceStack -> commandSourceStack.hasPermission(0)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)STARGATE_NETWORK).then(Commands.literal((String)"forceStellarUpdate").executes(CommandInit::forceStellarUpdate)))).requires(commandSourceStack -> commandSourceStack.hasPermission(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)STARGATE_NETWORK).then(Commands.literal((String)"settings").then(Commands.literal((String)"get").executes(CommandInit::getSettings))))).requires(commandSourceStack -> commandSourceStack.hasPermission(0)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)STARGATE_NETWORK).then(Commands.literal((String)"settings").then(Commands.literal((String)"set").then(Commands.literal((String)"useDatapackAddresses").then(Commands.argument((String)"useDatapackAddresses", (ArgumentType)BoolArgumentType.bool()).executes(CommandInit::useDatapackAddresses))))))).requires(commandSourceStack -> commandSourceStack.hasPermission(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)STARGATE_NETWORK).then(Commands.literal((String)"settings").then(Commands.literal((String)"set").then(Commands.literal((String)"generateRandomSolarSystems").then(Commands.argument((String)"generateRandomSolarSystems", (ArgumentType)BoolArgumentType.bool()).executes(CommandInit::generateRandomSolarSystems))))))).requires(commandSourceStack -> commandSourceStack.hasPermission(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)STARGATE_NETWORK).then(Commands.literal((String)"settings").then(Commands.literal((String)"set").then(Commands.literal((String)"randomAddressFromSeed").then(Commands.argument((String)"randomAddressFromSeed", (ArgumentType)BoolArgumentType.bool()).executes(CommandInit::randomAddressFromSeed))))))).requires(commandSourceStack -> commandSourceStack.hasPermission(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)TRANSPORTER_NETWORK).then(Commands.literal((String)"getAllTransporters").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(CommandInit::getTransporters))))).requires(commandSourceStack -> commandSourceStack.hasPermission(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)TRANSPORTER_NETWORK).then(Commands.literal((String)"reload").executes(CommandInit::reloadTransporterNetwork)))).requires(commandSourceStack -> commandSourceStack.hasPermission(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)GENE).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.literal((String)"add").then(Commands.literal((String)"ancient").executes(CommandInit::setAncientGene)))))).requires(commandSourceStack -> commandSourceStack.hasPermission(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)GENE).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.literal((String)"add").then(Commands.literal((String)"inherited").executes(CommandInit::setInheritedGene)))))).requires(commandSourceStack -> commandSourceStack.hasPermission(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)GENE).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.literal((String)"add").then(Commands.literal((String)"artificial").executes(CommandInit::setArtificialGene)))))).requires(commandSourceStack -> commandSourceStack.hasPermission(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)GENE).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.literal((String)"remove").executes(CommandInit::removeGene))))).requires(commandSourceStack -> commandSourceStack.hasPermission(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)"protection").then(Commands.literal((String)"set").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(CommandInit::setProtected))))).requires(commandSourceStack -> commandSourceStack.hasPermission(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)"protection").then(Commands.literal((String)"unset").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(CommandInit::unsetProtected))))).requires(commandSourceStack -> commandSourceStack.hasPermission(2)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sgjourney").then(Commands.literal((String)"debugInfo").executes(CommandInit::printStargateNetworkInfo))).requires(commandSourceStack -> commandSourceStack.hasPermission(2)));
    }

    private static int getAddress(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        List galaxies;
        ResourceKey dimension = DimensionArgument.getDimension(context, (String)"dimension").dimension();
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player == null || dimension == null) {
            return 1;
        }
        Level level = player.level();
        ResourceKey currentDimension = level.dimension();
        HashMap<Galaxy.Serializable, Address.Immutable> galaxyMap = Universe.get(level).getGalaxiesFromDimension((ResourceKey<Level>)currentDimension);
        if (galaxyMap != null && !(galaxies = galaxyMap.entrySet().stream().toList()).isEmpty()) {
            for (int i = 0; i < galaxies.size(); ++i) {
                Map.Entry galaxyEntry = (Map.Entry)galaxies.get(i);
                Galaxy.Serializable galaxy = (Galaxy.Serializable)galaxyEntry.getKey();
                Address.Immutable address = Universe.get(level).getAddressInGalaxyFromDimension(galaxy.getKey().location(), (ResourceKey<Level>)dimension);
                if (address == null) {
                    ((CommandSourceStack)context.getSource()).getPlayer().sendSystemMessage((Component)Component.literal((String)(dimension.location().toString() + " ")).withStyle(ChatFormatting.GREEN).append((Component)Component.translatable((String)"message.sgjourney.command.get_address.located").withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" ").append(galaxy.getTranslationName()).withStyle(ChatFormatting.LIGHT_PURPLE)));
                    continue;
                }
                ((CommandSourceStack)context.getSource()).getPlayer().sendSystemMessage((Component)Component.translatable((String)"message.sgjourney.command.get_address.address").append((Component)Component.literal((String)(" " + dimension.location().toString() + " ")).withStyle(ChatFormatting.GREEN)).append((Component)Component.translatable((String)"message.sgjourney.command.get_address.in_galaxy")).append((Component)Component.literal((String)" ").append(galaxy.getTranslationName()).append((Component)Component.literal((String)" ")).withStyle(ChatFormatting.LIGHT_PURPLE)).append((Component)Component.translatable((String)"message.sgjourney.command.get_address.is")));
                Style style = Style.EMPTY;
                style = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"message.sgjourney.command.click_to_copy.address")));
                style = style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, address.toString()));
                ((CommandSourceStack)context.getSource()).getPlayer().sendSystemMessage((Component)Component.literal((String)address.toString()).setStyle(style.applyFormat(ChatFormatting.GOLD)));
            }
            return 1;
        }
        ((CommandSourceStack)context.getSource()).getPlayer().sendSystemMessage((Component)Component.translatable((String)"message.sgjourney.command.get_address.no_galaxy").withStyle(ChatFormatting.DARK_RED));
        return 1;
    }

    private static int getExtragalacticAddress(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceKey dimension = DimensionArgument.getDimension(context, (String)"dimension").dimension();
        Level level = ((CommandSourceStack)context.getSource()).getPlayer().level();
        Address.Immutable address = Universe.get(level).getExtragalacticAddressFromDimension((ResourceKey<Level>)dimension);
        if (address != null) {
            Style style = Style.EMPTY;
            style = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"message.sgjourney.command.click_to_copy.address")));
            Style formatStyle = style = style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, address.toString()));
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.get_extragalactic_address.address").append((Component)Component.literal((String)(" " + dimension.location().toString() + " ")).withStyle(ChatFormatting.GREEN)).append((Component)Component.translatable((String)"message.sgjourney.command.get_extragalactic_address.is")), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)address.toString()).setStyle(formatStyle.applyFormat(ChatFormatting.LIGHT_PURPLE)), false);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.get_extragalactic_address.none").withStyle(ChatFormatting.DARK_RED), false);
        }
        return 1;
    }

    private static int getStargates(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceKey dimension = DimensionArgument.getDimension(context, (String)"dimension").dimension();
        Level level = ((CommandSourceStack)context.getSource()).getPlayer().level();
        SolarSystem.Serializable solarSystem = Universe.get(level).getSolarSystemFromDimension((ResourceKey<Level>)dimension);
        if (solarSystem != null && !solarSystem.getStargates().isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.get_stargates").append((Component)Component.literal((String)(" " + dimension.location().toString())).withStyle(ChatFormatting.GOLD)), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"-------------------------"), false);
            solarSystem.getStargates().stream().forEach(stargate -> {
                ResourceKey<Level> stargateDimension = stargate.getDimension();
                Vec3 stargatePos = stargate.getPosition(((CommandSourceStack)context.getSource()).getServer());
                if (dimension.equals(stargateDimension) && stargatePos != null) {
                    Style style = Style.EMPTY;
                    style = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"message.sgjourney.command.click_to_copy.address")));
                    Style formatStyle = style = style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, stargate.get9ChevronAddress().toString()));
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)stargate.get9ChevronAddress().toString()).setStyle(formatStyle.applyFormat(ChatFormatting.AQUA)).append((Component)Component.literal((String)(" X: " + stargatePos.x() + " Y: " + stargatePos.y() + " Z: " + stargatePos.z())).withStyle(ChatFormatting.BLUE)), false);
                }
            });
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"-------------------------"), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).getPlayer().sendSystemMessage((Component)Component.literal((String)("No Stargates could be located in " + dimension.location().toString())).withStyle(ChatFormatting.RED));
        return 1;
    }

    private static int setPrimaryStargate(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceKey dimension = DimensionArgument.getDimension(context, (String)"dimension").dimension();
        Address.Immutable address = AddressArgumentType.getAddress(context, "address");
        Level level = ((CommandSourceStack)context.getSource()).getPlayer().level();
        SolarSystem.Serializable solarSystem = Universe.get(level).getSolarSystemFromDimension((ResourceKey<Level>)dimension);
        if (solarSystem != null) {
            solarSystem.setPrimaryStargate(address);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.primary_stargate_set").withStyle(ChatFormatting.DARK_GREEN), true);
            return 1;
        }
        return 1;
    }

    private static int unsetPrimaryStargate(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceKey dimension = DimensionArgument.getDimension(context, (String)"dimension").dimension();
        Level level = ((CommandSourceStack)context.getSource()).getPlayer().level();
        SolarSystem.Serializable solarSystem = Universe.get(level).getSolarSystemFromDimension((ResourceKey<Level>)dimension);
        if (solarSystem != null) {
            solarSystem.setPrimaryStargate(null);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.primary_stargate_unset").withStyle(ChatFormatting.GREEN), true);
            return 1;
        }
        return 1;
    }

    private static int getPrimaryStargate(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceKey dimension = DimensionArgument.getDimension(context, (String)"dimension").dimension();
        Level level = ((CommandSourceStack)context.getSource()).getPlayer().level();
        SolarSystem.Serializable solarSystem = Universe.get(level).getSolarSystemFromDimension((ResourceKey<Level>)dimension);
        if (solarSystem != null) {
            Address.Immutable address = solarSystem.primaryAddress();
            if (address != null) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.primary_stargate").append((Component)Component.literal((String)": ").append(address.toComponent(true))).withStyle(ChatFormatting.AQUA), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.primary_stargate_none").withStyle(ChatFormatting.RED), true);
            }
            return 1;
        }
        return 1;
    }

    private static int getVersion(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).getPlayer().level();
        int version = StargateNetwork.get(level).getVersion();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.stargate_network_version").append((Component)Component.literal((String)(": " + version))).withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int forceStellarUpdate(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).getPlayer().level();
        StargateNetwork.get(level).stellarUpdate(level.getServer(), true);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.stellar_update").withStyle(ChatFormatting.RED), true);
        return 1;
    }

    private static int getSettings(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).getPlayer().level();
        boolean useDatapackAddresses = StargateNetworkSettings.get(level).useDatapackAddresses();
        boolean generateRandomSolarSystems = StargateNetworkSettings.get(level).generateRandomSolarSystems();
        boolean randomAddressFromSeed = StargateNetworkSettings.get(level).randomAddressFromSeed();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.stargate_network_settings.use_datapack_addresses").append((Component)Component.literal((String)(": " + useDatapackAddresses))).withStyle(ChatFormatting.GOLD), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.stargate_network_settings.generate_random_solar_systems").append((Component)Component.literal((String)(": " + generateRandomSolarSystems))).withStyle(ChatFormatting.GOLD), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.stargate_network_settings.random_addresses_from_seed").append((Component)Component.literal((String)(": " + randomAddressFromSeed))).withStyle(ChatFormatting.GOLD), false);
        return 1;
    }

    private static int useDatapackAddresses(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).getPlayer().level();
        boolean setting = BoolArgumentType.getBool(context, (String)"useDatapackAddresses");
        StargateNetworkSettings.get(level).setUseDatapackAddresses(setting);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.stargate_network_settings.changed").withStyle(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static int generateRandomSolarSystems(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).getPlayer().level();
        boolean setting = BoolArgumentType.getBool(context, (String)"generateRandomSolarSystems");
        StargateNetworkSettings.get(level).setGenerateRandomSolarSystems(setting);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.stargate_network_settings.changed").withStyle(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static int randomAddressFromSeed(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).getPlayer().level();
        boolean setting = BoolArgumentType.getBool(context, (String)"randomAddressFromSeed");
        StargateNetworkSettings.get(level).setRandomAddressFromSeed(setting);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.stargate_network_settings.changed").withStyle(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static int getTransporters(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceKey dimension = DimensionArgument.getDimension(context, (String)"dimension").dimension();
        Level level = ((CommandSourceStack)context.getSource()).getPlayer().level();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.get_transporters").append((Component)Component.literal((String)(" " + dimension.location().toString())).withStyle(ChatFormatting.GOLD)), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"-------------------------"), false);
        List<Transporter> transporters = TransporterNetwork.get(level).getTransportersFromDimension((ResourceKey<Level>)dimension);
        if (transporters != null) {
            for (Transporter transporter : transporters) {
                BlockPos coords = transporter.getBlockPos();
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("X: " + coords.getX() + " Y: " + coords.getY() + " Z: " + coords.getZ())).withStyle(ChatFormatting.BLUE), false);
            }
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"-------------------------"), false);
        return 1;
    }

    private static int reloadTransporterNetwork(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Level level = ((CommandSourceStack)context.getSource()).getPlayer().level();
        TransporterNetwork.get(level).reloadNetwork(level.getServer(), true);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.transporter_network_reload").withStyle(ChatFormatting.RED), true);
        return 1;
    }

    private static int setAncientGene(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(context, (String)"target");
        AncientGene cap = (AncientGene)entity.getCapability(AncientGene.ANCIENT_GENE_CAPABILITY);
        if (cap != null) {
            cap.giveGene();
        }
        return 1;
    }

    private static int setInheritedGene(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(context, (String)"target");
        AncientGene cap = (AncientGene)entity.getCapability(AncientGene.ANCIENT_GENE_CAPABILITY);
        if (cap != null) {
            cap.inheritGene();
        }
        return 1;
    }

    private static int setArtificialGene(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(context, (String)"target");
        AncientGene cap = (AncientGene)entity.getCapability(AncientGene.ANCIENT_GENE_CAPABILITY);
        if (cap != null) {
            cap.implantGene();
        }
        return 1;
    }

    private static int removeGene(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(context, (String)"target");
        AncientGene cap = (AncientGene)entity.getCapability(AncientGene.ANCIENT_GENE_CAPABILITY);
        if (cap != null) {
            cap.removeGene();
        }
        return 1;
    }

    private static int setProtected(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos;
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        BlockState state = level.getBlockState(pos = BlockPosArgument.getLoadedBlockPos(context, (String)"pos"));
        Block block = state.getBlock();
        if (block instanceof ProtectedBlock) {
            ProtectedBlock protectedBlock = (ProtectedBlock)block;
            ProtectedBlockEntity blockEntity = protectedBlock.getProtectedBlockEntity((BlockGetter)level, pos, state);
            if (((CommandSourceStack)context.getSource()).isPlayer() && blockEntity.hasPermissions((Player)((CommandSourceStack)context.getSource()).getPlayer(), true)) {
                blockEntity.setProtected(true);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.protected_block_set").withStyle(ChatFormatting.LIGHT_PURPLE), true);
            }
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.not_protected_block").withStyle(ChatFormatting.RED), true);
        }
        return 1;
    }

    private static int unsetProtected(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos;
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        BlockState state = level.getBlockState(pos = BlockPosArgument.getLoadedBlockPos(context, (String)"pos"));
        Block block = state.getBlock();
        if (block instanceof ProtectedBlock) {
            ProtectedBlock protectedBlock = (ProtectedBlock)block;
            ProtectedBlockEntity blockEntity = protectedBlock.getProtectedBlockEntity((BlockGetter)level, pos, state);
            if (((CommandSourceStack)context.getSource()).isPlayer() && blockEntity.hasPermissions((Player)((CommandSourceStack)context.getSource()).getPlayer(), true)) {
                blockEntity.setProtected(false);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.protected_block_unset").withStyle(ChatFormatting.LIGHT_PURPLE), true);
            }
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"message.sgjourney.command.not_protected_block").withStyle(ChatFormatting.RED), true);
        }
        return 1;
    }

    private static int printStargateNetworkInfo(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        System.out.println("===============Universe===============");
        Universe.get(server).printDimensions();
        Universe.get(server).printSolarSystems();
        Universe.get(server).printGalaxies();
        System.out.println("===============Stargate Network===============");
        BlockEntityList.get(server).printStargates();
        StargateNetwork.get(server).printConnections();
        System.out.println("===============Transporter Network===============");
        BlockEntityList.get(server).printTransporters();
        TransporterNetwork.get(server).printDimensions();
        System.out.println("===============Conduit Networks===============");
        ConduitNetworks.get(server).printConduits();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Printed info onto the console"), false);
        return 1;
    }
}

