/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.TagInit;
import net.povstalec.sgjourney.common.world.features.CrystalPatchFeature;
import net.povstalec.sgjourney.common.world.features.SpireFeature;
import net.povstalec.sgjourney.common.world.features.configuration.CrystalPatchConfiguration;
import net.povstalec.sgjourney.common.world.features.configuration.SpireConfiguration;

public class FeatureInit {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((ResourceKey)Registries.FEATURE, (String)"sgjourney");
    public static final Feature<SpireConfiguration> ORE_SPIRE_FEATURE = FeatureInit.register("ore_spire", new SpireFeature(SpireConfiguration.CODEC));
    public static final Feature<CrystalPatchConfiguration> CRYSTAL_PATCH_FEATURE = FeatureInit.register("crystal_patch", new CrystalPatchFeature(CrystalPatchConfiguration.CODEC));
    public static final ResourceKey<ConfiguredFeature<?, ?>> STONE_NAQUADAH_SPIRE_KEY = FeatureInit.createKey("stone_naquadah_spire");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLACKSTONE_NAQUADAH_SPIRE_KEY = FeatureInit.createKey("blackstone_naquadah_spire");

    private static <C extends FeatureConfiguration, F extends Feature<C>> F register(String name, F feature) {
        FEATURES.register(name, () -> feature);
        return feature;
    }

    public static void register(IEventBus eventBus) {
        FEATURES.register(eventBus);
    }

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        FeatureInit.register(context, STONE_NAQUADAH_SPIRE_KEY, ORE_SPIRE_FEATURE, new SpireConfiguration.SpireConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.STONE), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockInit.NAQUADAH_ORE.get())), TagInit.Blocks.STONE_SPIRE_PROTRUDES_THROUGH).build());
        FeatureInit.register(context, BLACKSTONE_NAQUADAH_SPIRE_KEY, ORE_SPIRE_FEATURE, new SpireConfiguration.SpireConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.BLACKSTONE), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockInit.NAQUADAH_ORE.get())), TagInit.Blocks.STONE_SPIRE_PROTRUDES_THROUGH).build());
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)StargateJourney.sgjourneyLocation(name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureKey, F feature, FC configuration) {
        context.register(configuredFeatureKey, (Object)new ConfiguredFeature(feature, configuration));
    }
}

