/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.povstalec.sgjourney.common.capabilities.ZeroPointEnergy;
import net.povstalec.sgjourney.common.config.CommonZPMConfig;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.init.DataComponentInit;
import net.povstalec.sgjourney.common.misc.ComponentHelper;

public class ZeroPointModule
extends Item {
    public ZeroPointModule(Item.Properties properties) {
        super(properties);
    }

    public boolean isBarVisible(ItemStack stack) {
        return !StargateJourneyConfig.disable_energy_use.get();
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * (1000.0f - (float)ZeroPointModule.getEntropy(stack)) / 1000.0f);
    }

    public int getBarColor(ItemStack stack) {
        return 16743680;
    }

    private static int getEntropy(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponentInit.ENTROPY, (Object)0);
    }

    public static long getEnergy(ItemStack stack) {
        return (Long)stack.getOrDefault(DataComponentInit.ENERGY, (Object)((Long)CommonZPMConfig.zpm_energy_per_level_of_entropy.get()));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        int entropy = ZeroPointModule.getEntropy(stack);
        long remainingEnergy = ZeroPointModule.getEnergy(stack);
        float currentEntropy = (float)entropy * 100.0f / 1000.0f;
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.zpm.entropy").append((Component)Component.literal((String)(": " + currentEntropy + "%"))).withStyle(ChatFormatting.GOLD));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.energy").append((Component)Component.literal((String)(": " + ZeroPointEnergy.zeroPointEnergyToString(entropy, remainingEnergy)))).withStyle(ChatFormatting.DARK_RED));
        tooltipComponents.add((Component)ComponentHelper.description("tooltip.sgjourney.zpm.description"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static long getMaxEnergy() {
        return (Long)CommonZPMConfig.zpm_energy_per_level_of_entropy.get();
    }

    public static long getMaxExtract() {
        return (Long)CommonZPMConfig.zpm_energy_per_level_of_entropy.get();
    }

    public static class Energy
    extends ZeroPointEnergy.Item {
        public Energy(ItemStack stack) {
            super(stack, 1000, ZeroPointModule.getMaxEnergy(), 0L, ZeroPointModule.getMaxExtract());
        }

        @Override
        public long maxReceive() {
            return ZeroPointModule.getMaxEnergy();
        }

        @Override
        public long maxExtract() {
            return ZeroPointModule.getMaxEnergy();
        }

        @Override
        public long getTrueMaxEnergyStored() {
            return ZeroPointModule.getMaxEnergy();
        }
    }
}

