/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.crystals;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.povstalec.sgjourney.common.misc.ArrayHelper;

public abstract class AbstractCrystalItem
extends Item {
    public AbstractCrystalItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isLarge() {
        return false;
    }

    public boolean isAdvanced() {
        return false;
    }

    public boolean isRegular() {
        return !this.isAdvanced() && !this.isLarge();
    }

    public Optional<Component> descriptionInDHD(ItemStack stack) {
        return Optional.empty();
    }

    public Optional<Component> descriptionInRing() {
        return Optional.empty();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (this.descriptionInDHD(stack).isPresent()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.crystal.in_dhd").withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.ITALIC));
            tooltipComponents.add(this.descriptionInDHD(stack).get());
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static class Storage {
        private int[] crystals = new int[0];
        private int[] advancedCrystals = new int[0];

        public void addCrystal(boolean isAdvanced, int slot) {
            if (!isAdvanced) {
                this.crystals = ArrayHelper.growIntArray(this.crystals, slot);
            } else {
                this.advancedCrystals = ArrayHelper.growIntArray(this.advancedCrystals, slot);
            }
        }

        public void reset() {
            this.crystals = new int[0];
            this.advancedCrystals = new int[0];
        }

        public int[] getCrystals() {
            return this.crystals;
        }

        public int[] getAdvancedCrystals() {
            return this.advancedCrystals;
        }
    }
}

