/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.crystals;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.povstalec.sgjourney.common.init.DataComponentInit;
import net.povstalec.sgjourney.common.items.crystals.AbstractCrystalItem;

public class CommunicationCrystalItem
extends AbstractCrystalItem {
    public static final int DEFAULT_MAX_DISTANCE = 16;
    public static final int ADVANCED_MAX_DISTANCE = 32;
    public static final int DEFAULT_FREQUENCY = 0;

    public CommunicationCrystalItem(Item.Properties properties) {
        super(properties);
    }

    public int getFrequency(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponentInit.FREQUENCY, (Object)0);
    }

    public int getMaxDistance() {
        return 16;
    }

    @Override
    public Optional<Component> descriptionInDHD(ItemStack stack) {
        return Optional.of(Component.translatable((String)"tooltip.sgjourney.crystal.in_dhd.communication").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        MutableComponent description = Component.translatable((String)"tooltip.sgjourney.communication_crystal.frequency").append((Component)Component.literal((String)": ")).withStyle(ChatFormatting.GRAY);
        int frequency = this.getFrequency(stack);
        if (frequency == 0) {
            tooltipComponents.add((Component)description.append((Component)Component.translatable((String)"tooltip.sgjourney.crystal.none").withStyle(ChatFormatting.GRAY)));
        } else {
            tooltipComponents.add((Component)description.append((Component)Component.literal((String)("" + frequency)).withStyle(ChatFormatting.GRAY)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static class Advanced
    extends CommunicationCrystalItem {
        public Advanced(Item.Properties properties) {
            super(properties);
        }

        @Override
        public int getMaxDistance() {
            return 32;
        }

        @Override
        public boolean isAdvanced() {
            return true;
        }

        @Override
        public Optional<Component> descriptionInDHD(ItemStack stack) {
            return Optional.of(Component.translatable((String)"tooltip.sgjourney.crystal.in_dhd.communication.advanced").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        }
    }
}

