/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.crystals;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.config.CommonCrystalConfig;
import net.povstalec.sgjourney.common.config.CommonDHDConfig;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.init.DataComponentInit;
import net.povstalec.sgjourney.common.items.crystals.AbstractCrystalItem;

public class EnergyCrystalItem
extends AbstractCrystalItem {
    public EnergyCrystalItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isBarVisible(ItemStack stack) {
        return !StargateJourneyConfig.disable_energy_use.get() && EnergyCrystalItem.getEnergy(stack) > 0L;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * (float)EnergyCrystalItem.getEnergy(stack) / (float)this.getCapacity());
    }

    public int getBarColor(ItemStack stack) {
        float f = Math.max(0.0f, (float)EnergyCrystalItem.getEnergy(stack) / (float)this.getCapacity());
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public static long getEnergy(ItemStack stack) {
        return (Long)stack.getOrDefault(DataComponentInit.ENERGY, (Object)0L);
    }

    public long getCapacity() {
        return (Long)CommonCrystalConfig.energy_crystal_capacity.get();
    }

    public long getTransfer() {
        return (Long)CommonCrystalConfig.energy_crystal_max_transfer.get();
    }

    public long energyTargetIncrease() {
        return (Long)CommonDHDConfig.energy_crystal_dhd_energy_target.get();
    }

    @Override
    public Optional<Component> descriptionInDHD(ItemStack stack) {
        return Optional.of(Component.translatable((String)"tooltip.sgjourney.crystal.in_dhd.energy").append((Component)Component.literal((String)(" " + SGJourneyEnergy.energyToString(this.energyTargetIncrease())))).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.energy").append((Component)Component.literal((String)(": " + SGJourneyEnergy.energyToString(EnergyCrystalItem.getEnergy(stack), this.getCapacity())))).withStyle(ChatFormatting.DARK_RED));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static class Energy
    extends SGJourneyEnergy.Item {
        public Energy(ItemStack stack) {
            super(stack, 0L, 0L, 0L);
        }

        @Override
        public long maxReceive() {
            Item item = this.stack.getItem();
            if (item instanceof EnergyCrystalItem) {
                EnergyCrystalItem energyCrystal = (EnergyCrystalItem)item;
                return energyCrystal.getTransfer();
            }
            return 0L;
        }

        @Override
        public long maxExtract() {
            Item item = this.stack.getItem();
            if (item instanceof EnergyCrystalItem) {
                EnergyCrystalItem energyCrystal = (EnergyCrystalItem)item;
                return energyCrystal.getTransfer();
            }
            return 0L;
        }

        @Override
        public long loadEnergy(ItemStack stack) {
            return EnergyCrystalItem.getEnergy(stack);
        }

        @Override
        public long getTrueMaxEnergyStored() {
            Item item = this.stack.getItem();
            if (item instanceof EnergyCrystalItem) {
                EnergyCrystalItem energyCrystal = (EnergyCrystalItem)item;
                return energyCrystal.getCapacity();
            }
            return 0L;
        }

        @Override
        public void onEnergyChanged(long difference, boolean simulate) {
            this.stack.set(DataComponentInit.ENERGY, (Object)this.energy);
        }
    }

    public static final class Advanced
    extends EnergyCrystalItem {
        public Advanced(Item.Properties properties) {
            super(properties);
        }

        @Override
        public long getCapacity() {
            return (Long)CommonCrystalConfig.advanced_energy_crystal_capacity.get();
        }

        @Override
        public long energyTargetIncrease() {
            return (Long)CommonDHDConfig.advanced_energy_crystal_dhd_energy_target.get();
        }

        @Override
        public long getTransfer() {
            return (Long)CommonCrystalConfig.advanced_energy_crystal_max_transfer.get();
        }

        @Override
        public boolean isAdvanced() {
            return true;
        }
    }
}

