/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.crystals;

import com.mojang.serialization.Codec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.povstalec.sgjourney.common.init.DataComponentInit;
import net.povstalec.sgjourney.common.items.crystals.AbstractCrystalItem;

public class MaterializationCrystalItem
extends AbstractCrystalItem {
    public static final int DEFAULT_RANGE_INCREMENT = 2;
    public static final int ADVANCED_RANGE_INCREMENT = 4;
    public static final Codec CRYSTAL_MODE_CODEC = StringRepresentable.fromValues(() -> new CrystalMode[]{CrystalMode.INCREASE_RANGE, CrystalMode.DIMENSION_TRANSPORT});

    public MaterializationCrystalItem(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public static CrystalMode getCrystalMode(ItemStack stack) {
        return (CrystalMode)((Object)stack.getOrDefault(DataComponentInit.MATERIALIZATION_CRYSTAL_MODE, (Object)CrystalMode.INCREASE_RANGE));
    }

    public int getRangeIncrement() {
        return 2;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        CrystalMode mode = MaterializationCrystalItem.getCrystalMode(stack);
        String text = "";
        switch (mode.ordinal()) {
            case 0: {
                text = "tooltip.sgjourney.materialization_crystal.increased_range";
                break;
            }
            case 1: {
                text = "tooltip.sgjourney.materialization_crystal.interdimensional";
            }
        }
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.mode").append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)text)).withStyle(ChatFormatting.DARK_AQUA));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static enum CrystalMode implements StringRepresentable
    {
        INCREASE_RANGE("increase_range"),
        DIMENSION_TRANSPORT("dimension_transport");

        private final String name;

        private CrystalMode(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    public static class Advanced
    extends MaterializationCrystalItem {
        public Advanced(Item.Properties properties) {
            super(properties);
        }

        @Override
        public int getRangeIncrement() {
            return 4;
        }

        @Override
        public boolean isAdvanced() {
            return true;
        }
    }
}

