/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.crystals;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.config.CommonCrystalConfig;
import net.povstalec.sgjourney.common.items.crystals.AbstractCrystalItem;

public class TransferCrystalItem
extends AbstractCrystalItem {
    public TransferCrystalItem(Item.Properties properties) {
        super(properties);
    }

    public long getMaxTransfer() {
        return (Long)CommonCrystalConfig.transfer_crystal_max_transfer.get();
    }

    @Override
    public Optional<Component> descriptionInDHD(ItemStack stack) {
        return Optional.of(Component.translatable((String)"tooltip.sgjourney.crystal.in_dhd.transfer").append((Component)Component.literal((String)(" " + SGJourneyEnergy.energyToString(this.getMaxTransfer())))).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        long maxEnergyTransfer = this.getMaxTransfer();
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.energy_transfer").append((Component)Component.literal((String)(": " + SGJourneyEnergy.energyToString(maxEnergyTransfer) + "/t"))).withStyle(ChatFormatting.RED));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static class Advanced
    extends TransferCrystalItem {
        public Advanced(Item.Properties properties) {
            super(properties);
        }

        @Override
        public long getMaxTransfer() {
            return (Long)CommonCrystalConfig.advanced_transfer_crystal_max_transfer.get();
        }

        @Override
        public boolean isAdvanced() {
            return true;
        }
    }
}

