/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.energy_cores;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.povstalec.sgjourney.common.config.CommonNaquadahGeneratorConfig;
import net.povstalec.sgjourney.common.init.DataComponentInit;
import net.povstalec.sgjourney.common.items.NaquadahFuelRodItem;
import net.povstalec.sgjourney.common.items.energy_cores.IEnergyCore;

public class NaquadahGeneratorCoreItem
extends Item
implements IEnergyCore {
    public NaquadahGeneratorCoreItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.reactionProgress(stack) > 0L;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * (float)this.reactionProgress(stack) / (float)this.getMaxReactionProgress());
    }

    public int getBarColor(ItemStack stack) {
        float f = Math.max(0.0f, (float)this.reactionProgress(stack) / (float)this.getMaxReactionProgress());
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public long reactionProgress(ItemStack energyCore) {
        return (Long)energyCore.getOrDefault(DataComponentInit.REACTION_PROGRESS, (Object)0L);
    }

    public long getMaxReactionProgress() {
        return (Long)CommonNaquadahGeneratorConfig.naquadah_generator_mark_i_reaction_time.get();
    }

    public long doReaction(ItemStack energyCore, ItemStack input) {
        long progress = this.reactionProgress(energyCore);
        if (progress < this.getMaxReactionProgress()) {
            energyCore.set(DataComponentInit.REACTION_PROGRESS, (Object)(progress + 1L));
            return this.maxGeneratedEnergy(energyCore, input);
        }
        return 0L;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.naquadah_generator_core.reaction_progress").append((Component)Component.literal((String)(": " + this.reactionProgress(stack) + " / " + this.getMaxReactionProgress()))).withStyle(ChatFormatting.GREEN));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.naquadah_generator_core.description").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @Override
    public long maxGeneratedEnergy(ItemStack energyCore, ItemStack input) {
        return (Long)CommonNaquadahGeneratorConfig.naquadah_generator_mark_i_energy_per_tick.get();
    }

    @Override
    public long generateEnergy(ItemStack energyCore, ItemStack input) {
        long energy = this.doReaction(energyCore, input);
        if (energy == 0L && input.getItem() instanceof NaquadahFuelRodItem && NaquadahFuelRodItem.getFuel(input) > 0) {
            NaquadahFuelRodItem.depleteFuel(input);
            energyCore.set(DataComponentInit.REACTION_PROGRESS, (Object)1L);
        }
        return energy;
    }
}

