/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.povstalec.sgjourney.common.block_entities.tech.BatteryBlockEntity;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.MenuInit;
import net.povstalec.sgjourney.common.menu.InventoryMenu;

public class BatteryMenu
extends InventoryMenu {
    private final BatteryBlockEntity battery;
    private final Level level;

    public BatteryMenu(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerId, inventory, inventory.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public BatteryMenu(int containerId, Inventory inventory, BlockEntity entity) {
        super((MenuType)MenuInit.NAQUADAH_BATTERY.get(), containerId);
        this.battery = (BatteryBlockEntity)entity;
        this.level = inventory.player.level();
        this.addPlayerInventory(inventory, 8, 84);
        this.addPlayerHotbar(inventory, 8, 142);
        IItemHandler itemHandler = this.battery.getItemHandler();
        if (itemHandler != null) {
            this.addSlot((Slot)new SlotItemHandler(itemHandler, 0, 8, 36));
            this.addSlot((Slot)new SlotItemHandler(itemHandler, 1, 152, 36));
        }
    }

    public long getEnergy() {
        return this.battery.getEnergyStored();
    }

    public long getMaxEnergy() {
        return this.battery.getEnergyCapacity();
    }

    public boolean hasItem(int slot) {
        if (slot < 0 || slot > 8) {
            return false;
        }
        IItemHandler cap = this.battery.getItemHandler();
        if (cap != null) {
            return !cap.getStackInSlot(slot).isEmpty();
        }
        return false;
    }

    public boolean stillValid(Player player) {
        return BatteryMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.battery.getBlockPos()), (Player)player, (Block)((Block)BlockInit.LARGE_NAQUADAH_BATTERY.get()));
    }

    @Override
    protected int blockEntitySlotCount() {
        return 2;
    }
}

