/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.povstalec.sgjourney.common.block_entities.dhd.CrystalDHDEntity;
import net.povstalec.sgjourney.common.block_entities.dhd.PegasusDHDEntity;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.MenuInit;

public class DHDCrystalMenu
extends AbstractContainerMenu {
    private final CrystalDHDEntity blockEntity;
    private final Level level;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 10;

    public DHDCrystalMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public DHDCrystalMenu(int containerId, Inventory inv, BlockEntity entity) {
        super((MenuType)MenuInit.DHD_CRYSTAL.get(), containerId);
        IItemHandler energyItemHandler;
        DHDCrystalMenu.checkContainerSize((Container)inv, (int)9);
        this.blockEntity = (CrystalDHDEntity)entity;
        this.level = inv.player.level();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        IItemHandler cap = this.blockEntity.getItemHandler();
        if (cap != null) {
            this.addSlot((Slot)new SlotItemHandler(cap, 0, 80, 35));
            this.addSlot((Slot)new SlotItemHandler(cap, 1, 80, 17));
            this.addSlot((Slot)new SlotItemHandler(cap, 2, 98, 17));
            this.addSlot((Slot)new SlotItemHandler(cap, 3, 98, 35));
            this.addSlot((Slot)new SlotItemHandler(cap, 4, 98, 53));
            this.addSlot((Slot)new SlotItemHandler(cap, 5, 80, 53));
            this.addSlot((Slot)new SlotItemHandler(cap, 6, 62, 53));
            this.addSlot((Slot)new SlotItemHandler(cap, 7, 62, 35));
            this.addSlot((Slot)new SlotItemHandler(cap, 8, 62, 17));
        }
        if ((energyItemHandler = this.blockEntity.getEnergyItemHandler(null)) != null) {
            this.addSlot((Slot)new SlotItemHandler(energyItemHandler, 0, 134, 27));
            this.addSlot((Slot)new SlotItemHandler(energyItemHandler, 1, 134, 53));
        }
    }

    public boolean advancedCrystals() {
        return this.blockEntity instanceof PegasusDHDEntity;
    }

    public long getStargateEnergy() {
        return this.blockEntity.getStargateEnergy();
    }

    public int getStargateOpenTime() {
        return this.blockEntity.getStargateOpenTime();
    }

    public int getStargateTimeSinceLastTraveler() {
        return this.blockEntity.getStargateTimeSinceLastTraveler();
    }

    public long getEnergy() {
        return this.blockEntity.getEnergyStored();
    }

    public long getMaxEnergy() {
        return this.blockEntity.getEnergyCapacity();
    }

    public boolean enableAdvancedProtocols() {
        return this.blockEntity.enableAdvancedProtocols();
    }

    public long getEnergyTarget() {
        return this.blockEntity.getEnergyTarget();
    }

    public long maxEnergyDeplete() {
        return this.blockEntity.maxEnergyDeplete();
    }

    public int getMaxDistance() {
        return this.blockEntity.getMaxDistance();
    }

    public boolean hasItem(int slot) {
        if (slot < 0 || slot > 10) {
            return false;
        }
        if (slot >= 9) {
            IItemHandler cap = this.blockEntity.getEnergyItemHandler(null);
            if (cap != null) {
                return !cap.getStackInSlot(slot - 9).isEmpty();
            }
        } else {
            IItemHandler cap = this.blockEntity.getItemHandler();
            if (cap != null) {
                return !cap.getStackInSlot(slot).isEmpty();
            }
        }
        return false;
    }

    public boolean stillValid(Player player) {
        return DHDCrystalMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)BlockInit.MILKY_WAY_DHD.get())) || DHDCrystalMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)BlockInit.PEGASUS_DHD.get())) || DHDCrystalMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)BlockInit.CLASSIC_DHD.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 86 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 144));
        }
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 46, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 46) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }
}

