/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.tech_interface.AbstractInterfaceEntity;
import net.povstalec.sgjourney.common.blockstates.InterfaceMode;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.MenuInit;
import net.povstalec.sgjourney.common.packets.ServerboundInterfaceUpdatePacket;

public class InterfaceMenu
extends AbstractContainerMenu {
    private final AbstractInterfaceEntity interfaceEntity;
    private final Level level;

    public InterfaceMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public InterfaceMenu(int containerId, Inventory inv, BlockEntity entity) {
        super((MenuType)MenuInit.INTERFACE.get(), containerId);
        this.interfaceEntity = (AbstractInterfaceEntity)entity;
        this.level = inv.player.level();
    }

    public long getEnergy() {
        return this.interfaceEntity.getEnergyStored();
    }

    public long getMaxEnergy() {
        return this.interfaceEntity.getEnergyCapacity();
    }

    public InterfaceMode getMode() {
        return this.interfaceEntity.getMode();
    }

    public void setEnergyTargetAndMode(long energyTarget, InterfaceMode mode) {
        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundInterfaceUpdatePacket(this.interfaceEntity.getBlockPos(), energyTarget, mode), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public long getEnergyTarget() {
        return this.interfaceEntity.getEnergyTarget();
    }

    public long getEnergyBlockEnergy() {
        return this.interfaceEntity.getEnergyBlockEnergy();
    }

    public int getStargateOpenTime() {
        return this.interfaceEntity.getStargateOpenTime();
    }

    public int getStargateTimeSinceLastTraveler() {
        return this.interfaceEntity.getStargateTimeSinceLastTraveler();
    }

    public AbstractInterfaceEntity.InterfaceType getInterfaceType() {
        return this.interfaceEntity.getInterfaceType();
    }

    public boolean stillValid(Player player) {
        BlockPos pos = this.interfaceEntity.getBlockPos();
        return InterfaceMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)pos), (Player)player, (Block)((Block)BlockInit.BASIC_INTERFACE.get())) || InterfaceMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)pos), (Player)player, (Block)((Block)BlockInit.CRYSTAL_INTERFACE.get())) || InterfaceMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)pos), (Player)player, (Block)((Block)BlockInit.ADVANCED_CRYSTAL_INTERFACE.get()));
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }
}

