/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.povstalec.sgjourney.common.block_entities.tech.AbstractNaquadahLiquidizerEntity;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.MenuInit;
import net.povstalec.sgjourney.common.menu.InventoryMenu;

public abstract class LiquidizerMenu
extends InventoryMenu {
    protected final AbstractNaquadahLiquidizerEntity blockEntity;
    protected final Level level;
    protected FluidStack fluidStack1;
    protected FluidStack fluidStack2;
    private static final int TE_INVENTORY_INPUT_BUCKET_SLOT_INDEX = 1;
    private static final int TE_INVENTORY_OUTPUT_BUCKET_SLOT_INDEX = 2;

    public LiquidizerMenu(MenuType<LiquidizerMenu> type, int containerId, Inventory inventory, BlockEntity blockEntity) {
        super(type, containerId);
        IItemHandler cap2;
        IItemHandler cap1;
        LiquidizerMenu.checkContainerSize((Container)inventory, (int)3);
        this.blockEntity = (AbstractNaquadahLiquidizerEntity)blockEntity;
        this.level = inventory.player.level();
        this.fluidStack1 = this.blockEntity.getFluid1();
        this.fluidStack2 = this.blockEntity.getFluid2();
        this.addPlayerInventory(inventory, 8, 84);
        this.addPlayerHotbar(inventory, 8, 142);
        IItemHandler cap0 = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, blockEntity.getBlockPos(), (Object)Direction.UP);
        if (cap0 != null) {
            this.addSlot((Slot)new SlotItemHandler(cap0, 0, 80, 20));
        }
        if ((cap1 = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, blockEntity.getBlockPos(), (Object)Direction.NORTH)) != null) {
            this.addSlot((Slot)new SlotItemHandler(cap1, 0, 34, 20));
        }
        if ((cap2 = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, blockEntity.getBlockPos(), (Object)Direction.DOWN)) != null) {
            this.addSlot((Slot)new SlotItemHandler(cap2, 0, 126, 58));
        }
    }

    public void setFluid1(FluidStack fluidStack) {
        this.fluidStack1 = fluidStack;
    }

    public void setFluid2(FluidStack fluidStack) {
        this.fluidStack2 = fluidStack;
    }

    public FluidStack getFluid1() {
        return this.blockEntity.getFluid1();
    }

    public FluidStack getFluid2() {
        return this.blockEntity.getFluid2();
    }

    public Fluid getDesiredFluid1() {
        return this.blockEntity.getDesiredFluid1();
    }

    public Fluid getDesiredFluid2() {
        return this.blockEntity.getDesiredFluid2();
    }

    public int getProgress() {
        return this.blockEntity.progress;
    }

    public boolean stillValid(Player player) {
        return LiquidizerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)BlockInit.NAQUADAH_LIQUIDIZER.get())) || LiquidizerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)BlockInit.HEAVY_NAQUADAH_LIQUIDIZER.get()));
    }

    @Override
    protected int blockEntitySlotCount() {
        return 3;
    }

    private boolean hasRequiredLiquid(ItemStack itemStack) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler != null) {
            return fluidHandler.getFluidInTank(0).is(this.blockEntity.getDesiredFluid1());
        }
        return false;
    }

    private boolean canAcceptResultingLiquid(ItemStack itemStack) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler != null) {
            return fluidHandler.getFluidInTank(0).isEmpty() || fluidHandler.getFluidInTank(0).is(this.blockEntity.getDesiredFluid2());
        }
        return false;
    }

    private static boolean countEquals(ItemStack first, ItemStack second) {
        return first.getCount() == second.getCount();
    }

    @Override
    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        boolean stopQuickMove = false;
        if (index < 36) {
            stopQuickMove = true;
            if (this.hasRequiredLiquid(sourceStack)) {
                this.moveItemStackTo(sourceStack, 37, 38, false);
            } else if (this.canAcceptResultingLiquid(sourceSlot.getItem())) {
                this.moveItemStackTo(sourceStack, 38, 39, false);
            }
            if (LiquidizerMenu.countEquals(sourceStack, copyOfSourceStack) && !this.moveItemStackTo(sourceStack, 36, 36 + this.TE_INVENTORY_SLOT_COUNT, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 36 + this.TE_INVENTORY_SLOT_COUNT) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        if (stopQuickMove) {
            return ItemStack.EMPTY;
        }
        return copyOfSourceStack;
    }

    public static class HeavyLiquidNaquadah
    extends LiquidizerMenu {
        public HeavyLiquidNaquadah(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
            this(containerId, inventory, inventory.player.level().getBlockEntity(extraData.readBlockPos()));
        }

        public HeavyLiquidNaquadah(int containerId, Inventory inventory, BlockEntity blockEntity) {
            super((MenuType<LiquidizerMenu>)((MenuType)MenuInit.HEAVY_NAQUADAH_LIQUIDIZER.get()), containerId, inventory, blockEntity);
        }
    }

    public static class LiquidNaquadah
    extends LiquidizerMenu {
        public LiquidNaquadah(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
            this(containerId, inventory, inventory.player.level().getBlockEntity(extraData.readBlockPos()));
        }

        public LiquidNaquadah(int containerId, Inventory inventory, BlockEntity blockEntity) {
            super((MenuType<LiquidizerMenu>)((MenuType)MenuInit.NAQUADAH_LIQUIDIZER.get()), containerId, inventory, blockEntity);
        }
    }
}

