/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.povstalec.sgjourney.common.block_entities.tech.NaquadahGeneratorEntity;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.MenuInit;
import net.povstalec.sgjourney.common.menu.InventoryMenu;

public class NaquadahGeneratorMenu
extends InventoryMenu {
    private final NaquadahGeneratorEntity blockEntity;
    private final Level level;

    public NaquadahGeneratorMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public NaquadahGeneratorMenu(int containerId, Inventory inv, BlockEntity entity) {
        super((MenuType)MenuInit.NAQUADAH_GENERATOR.get(), containerId);
        NaquadahGeneratorMenu.checkContainerSize((Container)inv, (int)1);
        this.blockEntity = (NaquadahGeneratorEntity)entity;
        this.level = inv.player.level();
        this.addPlayerInventory(inv, 8, 86);
        this.addPlayerHotbar(inv, 8, 144);
        IItemHandler cap = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.blockEntity.getBlockPos(), null);
        if (cap != null) {
            this.addSlot((Slot)new SlotItemHandler(cap, 0, 62, 35));
        }
    }

    public int getReactionProgress() {
        return this.blockEntity.getReactionProgress();
    }

    public long getReactionTime() {
        return this.blockEntity.getReactionTime();
    }

    public long getEnergy() {
        return this.blockEntity.getEnergyStored();
    }

    public long getMaxEnergy() {
        return this.blockEntity.getEnergyCapacity();
    }

    public boolean stillValid(Player player) {
        return NaquadahGeneratorMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)BlockInit.NAQUADAH_GENERATOR_MARK_I.get())) || NaquadahGeneratorMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)BlockInit.NAQUADAH_GENERATOR_MARK_II.get()));
    }

    @Override
    protected int blockEntitySlotCount() {
        return 1;
    }
}

