/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.tech.TransceiverEntity;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.MenuInit;
import net.povstalec.sgjourney.common.packets.ServerboundTransceiverUpdatePacket;

public class TransceiverMenu
extends AbstractContainerMenu {
    private final TransceiverEntity transceiverEntity;
    private final Level level;

    public TransceiverMenu(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerId, inventory, inventory.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public TransceiverMenu(int containerId, Inventory inventory, BlockEntity blockEntity) {
        super((MenuType)MenuInit.TRANSCEIVER.get(), containerId);
        this.transceiverEntity = (TransceiverEntity)blockEntity;
        this.level = inventory.player.level();
    }

    public boolean stillValid(Player player) {
        return TransceiverMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.transceiverEntity.getBlockPos()), (Player)player, (Block)((Block)BlockInit.TRANSCEIVER.get()));
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        return null;
    }

    public boolean editingFrequency() {
        return this.transceiverEntity.editingFrequency();
    }

    public int getFrequency() {
        return this.transceiverEntity.getFrequency();
    }

    public String getCurrentCode() {
        return this.transceiverEntity.getCurrentCode();
    }

    public void toggleFrequency() {
        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundTransceiverUpdatePacket(this.transceiverEntity.getBlockPos(), false, true, 0, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendTransmission() {
        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundTransceiverUpdatePacket(this.transceiverEntity.getBlockPos(), false, false, 0, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void addToCode(boolean toggledFrequency, int number) {
        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundTransceiverUpdatePacket(this.transceiverEntity.getBlockPos(), false, false, number, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void removeFromCode(boolean toggledFrequency) {
        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundTransceiverUpdatePacket(this.transceiverEntity.getBlockPos(), true, false, 0, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

