/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.misc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.povstalec.sgjourney.StargateJourney;

public class SGJourneyJigsawPlacement
extends JigsawPlacement {
    public static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext context, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, BlockPos pos, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, Rotation rotation, PoolAliasLookup aliasLookup, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
        BlockPos blockpos;
        RegistryAccess registryaccess = context.registryAccess();
        ChunkGenerator chunkgenerator = context.chunkGenerator();
        StructureTemplateManager structuretemplatemanager = context.structureTemplateManager();
        LevelHeightAccessor levelheightaccessor = context.heightAccessor();
        WorldgenRandom worldgenrandom = context.random();
        Registry registry = registryaccess.registryOrThrow(Registries.TEMPLATE_POOL);
        StructureTemplatePool structuretemplatepool = (StructureTemplatePool)startPool.value();
        StructurePoolElement structurepoolelement = structuretemplatepool.getRandomTemplate((RandomSource)worldgenrandom);
        if (structurepoolelement == EmptyPoolElement.INSTANCE) {
            return Optional.empty();
        }
        if (startJigsawName.isPresent()) {
            ResourceLocation resourcelocation = startJigsawName.get();
            Optional optional = SGJourneyJigsawPlacement.getRandomNamedJigsaw((StructurePoolElement)structurepoolelement, (ResourceLocation)resourcelocation, (BlockPos)pos, (Rotation)rotation, (StructureTemplateManager)structuretemplatemanager, (WorldgenRandom)worldgenrandom);
            if (optional.isEmpty()) {
                StargateJourney.LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)resourcelocation, (Object)((ResourceKey)startPool.unwrapKey().get()).location());
                return Optional.empty();
            }
            blockpos = (BlockPos)optional.get();
        } else {
            blockpos = pos;
        }
        BlockPos vec3i = blockpos.subtract((Vec3i)pos);
        BlockPos blockpos1 = pos.subtract((Vec3i)vec3i);
        PoolElementStructurePiece poolelementstructurepiece = new PoolElementStructurePiece(structuretemplatemanager, structurepoolelement, blockpos1, structurepoolelement.getGroundLevelDelta(), rotation, structurepoolelement.getBoundingBox(structuretemplatemanager, blockpos1, Rotation.NONE), liquidSettings);
        BoundingBox boundingbox = poolelementstructurepiece.getBoundingBox();
        int i = (boundingbox.maxX() + boundingbox.minX()) / 2;
        int j = (boundingbox.maxZ() + boundingbox.minZ()) / 2;
        int k = projectStartToHeightmap.isPresent() ? pos.getY() + chunkgenerator.getFirstFreeHeight(i, j, projectStartToHeightmap.get(), levelheightaccessor, context.randomState()) : blockpos1.getY();
        int l = boundingbox.minY() + poolelementstructurepiece.getGroundLevelDelta();
        poolelementstructurepiece.move(0, k - l, 0);
        int i1 = k + vec3i.getY();
        return Optional.of(new Structure.GenerationStub(new BlockPos(i, i1, j), builder -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolelementstructurepiece);
            if (maxDepth > 0) {
                AABB aabb = new AABB((double)(i - maxDistanceFromCenter), (double)Math.max(i1 - maxDistanceFromCenter, levelheightaccessor.getMinBuildHeight() + dimensionPadding.bottom()), (double)(j - maxDistanceFromCenter), (double)(i + maxDistanceFromCenter + 1), (double)Math.min(i1 + maxDistanceFromCenter + 1, levelheightaccessor.getMaxBuildHeight() - dimensionPadding.top()), (double)(j + maxDistanceFromCenter + 1));
                VoxelShape voxelshape = Shapes.join((VoxelShape)Shapes.create((AABB)aabb), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)boundingbox)), (BooleanOp)BooleanOp.ONLY_FIRST);
                SGJourneyJigsawPlacement.addPieces((RandomState)context.randomState(), (int)maxDepth, (boolean)useExpansionHack, (ChunkGenerator)chunkgenerator, (StructureTemplateManager)structuretemplatemanager, (LevelHeightAccessor)levelheightaccessor, (RandomSource)worldgenrandom, (Registry)registry, (PoolElementStructurePiece)poolelementstructurepiece, (List)list, (VoxelShape)voxelshape, (PoolAliasLookup)aliasLookup, (LiquidSettings)liquidSettings);
                list.forEach(arg_0 -> ((StructurePiecesBuilder)builder).addPiece(arg_0));
            }
        }));
    }
}

