/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.misc;

import com.mojang.math.Axis;
import java.util.ArrayList;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import org.joml.Matrix3d;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public final class VoxelShapeProvider {
    private static final double MIN = 0.0;
    private static final double MAX = 16.0;
    private static final double MID = 8.0;
    private static final double MIN_IRIS_THICKNESS = 7.5;
    private static final double MAX_IRIS_THICKNESS = 8.5;
    public static final VoxelShape X_IRIS_FULL = Block.box((double)0.0, (double)0.0, (double)7.5, (double)16.0, (double)16.0, (double)8.5);
    public static final VoxelShape X_IRIS_TOP_LEFT = Block.box((double)0.0, (double)8.0, (double)7.5, (double)8.0, (double)16.0, (double)8.5);
    public static final VoxelShape X_IRIS_TOP_RIGHT = Block.box((double)8.0, (double)8.0, (double)7.5, (double)16.0, (double)16.0, (double)8.5);
    public static final VoxelShape X_IRIS_BOTTOM_LEFT = Block.box((double)0.0, (double)0.0, (double)7.5, (double)8.0, (double)8.0, (double)8.5);
    public static final VoxelShape X_IRIS_BOTTOM_RIGHT = Block.box((double)8.0, (double)0.0, (double)7.5, (double)16.0, (double)8.0, (double)8.5);
    public static final VoxelShape X_IRIS_TOP = Shapes.or((VoxelShape)X_IRIS_TOP_LEFT, (VoxelShape)X_IRIS_TOP_RIGHT);
    public static final VoxelShape X_IRIS_LEFT = Shapes.or((VoxelShape)X_IRIS_TOP_LEFT, (VoxelShape)X_IRIS_BOTTOM_LEFT);
    public static final VoxelShape X_IRIS_RIGHT = Shapes.or((VoxelShape)X_IRIS_TOP_RIGHT, (VoxelShape)X_IRIS_BOTTOM_RIGHT);
    public static final VoxelShape X_IRIS_BOTTOM = Shapes.or((VoxelShape)X_IRIS_BOTTOM_LEFT, (VoxelShape)X_IRIS_BOTTOM_RIGHT);
    public static final VoxelShape Z_IRIS_FULL = Block.box((double)7.5, (double)0.0, (double)0.0, (double)8.5, (double)16.0, (double)16.0);
    public static final VoxelShape Z_IRIS_TOP_LEFT = Block.box((double)7.5, (double)8.0, (double)0.0, (double)8.5, (double)16.0, (double)8.0);
    public static final VoxelShape Z_IRIS_TOP_RIGHT = Block.box((double)7.5, (double)8.0, (double)8.0, (double)8.5, (double)16.0, (double)16.0);
    public static final VoxelShape Z_IRIS_BOTTOM_LEFT = Block.box((double)7.5, (double)0.0, (double)0.0, (double)8.5, (double)8.0, (double)8.0);
    public static final VoxelShape Z_IRIS_BOTTOM_RIGHT = Block.box((double)7.5, (double)0.0, (double)8.0, (double)8.5, (double)8.0, (double)16.0);
    public static final VoxelShape Z_IRIS_TOP = Shapes.or((VoxelShape)Z_IRIS_TOP_LEFT, (VoxelShape)Z_IRIS_TOP_RIGHT);
    public static final VoxelShape Z_IRIS_LEFT = Shapes.or((VoxelShape)Z_IRIS_TOP_LEFT, (VoxelShape)Z_IRIS_BOTTOM_LEFT);
    public static final VoxelShape Z_IRIS_RIGHT = Shapes.or((VoxelShape)Z_IRIS_TOP_RIGHT, (VoxelShape)Z_IRIS_BOTTOM_RIGHT);
    public static final VoxelShape Z_IRIS_BOTTOM = Shapes.or((VoxelShape)Z_IRIS_BOTTOM_LEFT, (VoxelShape)Z_IRIS_BOTTOM_RIGHT);
    public final VoxelShape HORIZONTAL_IRIS_FULL;
    public final VoxelShape HORIZONTAL_IRIS_TOP_LEFT;
    public final VoxelShape HORIZONTAL_IRIS_TOP_RIGHT;
    public final VoxelShape HORIZONTAL_IRIS_BOTTOM_LEFT;
    public final VoxelShape HORIZONTAL_IRIS_BOTTOM_RIGHT;
    public final VoxelShape HORIZONTAL_IRIS_TOP;
    public final VoxelShape HORIZONTAL_IRIS_LEFT;
    public final VoxelShape HORIZONTAL_IRIS_RIGHT;
    public final VoxelShape HORIZONTAL_IRIS_BOTTOM;
    public final VoxelShape[][] IRIS_FULL;
    public final VoxelShape[][] IRIS_BOTTOM;
    public final VoxelShape[][] IRIS_TOP;
    public final VoxelShape[][] IRIS_LEFT;
    public final VoxelShape[][] IRIS_RIGHT;
    public final VoxelShape[][] IRIS_CORNER_TOP_LEFT;
    public final VoxelShape[][] IRIS_CORNER_BOTTOM_LEFT;
    public final VoxelShape[][] IRIS_CORNER_BOTTOM_RIGHT;
    public final VoxelShape[][] IRIS_CORNER_TOP_RIGHT;
    public final VoxelShape[][] IRIS_STAIR_TOP_LEFT;
    public final VoxelShape[][] IRIS_STAIR_BOTTOM_LEFT;
    public final VoxelShape[][] IRIS_STAIR_BOTTOM_RIGHT;
    public final VoxelShape[][] IRIS_STAIR_TOP_RIGHT;
    public static final VoxelShape FULL_BLOCK = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public final VoxelShape HORIZONTAL_FULL;
    public final VoxelShape X_FULL;
    public final VoxelShape X_BOTTOM;
    public final VoxelShape X_TOP;
    public final VoxelShape X_LEFT;
    public final VoxelShape X_RIGHT;
    public final VoxelShape Z_FULL;
    public final VoxelShape Z_BOTTOM;
    public final VoxelShape Z_TOP;
    public final VoxelShape Z_LEFT;
    public final VoxelShape Z_RIGHT;
    public final VoxelShape[][] FULL;
    public final VoxelShape[][] BOTTOM;
    public final VoxelShape[][] TOP;
    public final VoxelShape[][] LEFT;
    public final VoxelShape[][] RIGHT;
    public final VoxelShape[][] CORNER_TOP_LEFT;
    public final VoxelShape[][] CORNER_BOTTOM_LEFT;
    public final VoxelShape[][] CORNER_BOTTOM_RIGHT;
    public final VoxelShape[][] CORNER_TOP_RIGHT;
    public final VoxelShape[][] STAIR_TOP_LEFT;
    public final VoxelShape[][] STAIR_BOTTOM_LEFT;
    public final VoxelShape[][] STAIR_BOTTOM_RIGHT;
    public final VoxelShape[][] STAIR_TOP_RIGHT;
    public final VoxelShape[][] STAIR_TOP_LEFT_BLOCKED;
    public final VoxelShape[][] STAIR_BOTTOM_LEFT_BLOCKED;
    public final VoxelShape[][] STAIR_BOTTOM_RIGHT_BLOCKED;
    public final VoxelShape[][] STAIR_TOP_RIGHT_BLOCKED;

    public VoxelShapeProvider(double width, double horizontalOffset) {
        double horizontalMax = horizontalOffset + width;
        double verticalStart = 8.0 - width / 2.0;
        double verticalEnd = 8.0 + width / 2.0;
        double horizontalIrisMin = horizontalOffset + width / 2.0 - 0.5;
        double horizontalIrisMax = horizontalOffset + width / 2.0 + 0.5;
        this.HORIZONTAL_IRIS_FULL = Block.box((double)0.0, (double)horizontalIrisMin, (double)0.0, (double)16.0, (double)horizontalIrisMax, (double)16.0);
        this.IRIS_FULL = new VoxelShape[][]{{this.HORIZONTAL_IRIS_FULL}, {X_IRIS_FULL, Z_IRIS_FULL}, {this.HORIZONTAL_IRIS_FULL}};
        this.HORIZONTAL_IRIS_TOP_LEFT = Block.box((double)0.0, (double)horizontalIrisMin, (double)8.0, (double)8.0, (double)horizontalIrisMax, (double)16.0);
        this.HORIZONTAL_IRIS_TOP_RIGHT = Block.box((double)8.0, (double)horizontalIrisMin, (double)8.0, (double)16.0, (double)horizontalIrisMax, (double)16.0);
        this.HORIZONTAL_IRIS_BOTTOM_LEFT = Block.box((double)0.0, (double)horizontalIrisMin, (double)0.0, (double)8.0, (double)horizontalIrisMax, (double)8.0);
        this.HORIZONTAL_IRIS_BOTTOM_RIGHT = Block.box((double)8.0, (double)horizontalIrisMin, (double)0.0, (double)16.0, (double)horizontalIrisMax, (double)8.0);
        this.HORIZONTAL_IRIS_TOP = Shapes.or((VoxelShape)this.HORIZONTAL_IRIS_TOP_LEFT, (VoxelShape)this.HORIZONTAL_IRIS_TOP_RIGHT);
        this.HORIZONTAL_IRIS_LEFT = Shapes.or((VoxelShape)this.HORIZONTAL_IRIS_TOP_LEFT, (VoxelShape)this.HORIZONTAL_IRIS_BOTTOM_LEFT);
        this.HORIZONTAL_IRIS_RIGHT = Shapes.or((VoxelShape)this.HORIZONTAL_IRIS_TOP_RIGHT, (VoxelShape)this.HORIZONTAL_IRIS_BOTTOM_RIGHT);
        this.HORIZONTAL_IRIS_BOTTOM = Shapes.or((VoxelShape)this.HORIZONTAL_IRIS_BOTTOM_LEFT, (VoxelShape)this.HORIZONTAL_IRIS_BOTTOM_RIGHT);
        VoxelShape[] defaultHorizontalIrisShapes = new VoxelShape[]{this.HORIZONTAL_IRIS_TOP, this.HORIZONTAL_IRIS_LEFT, this.HORIZONTAL_IRIS_BOTTOM, this.HORIZONTAL_IRIS_RIGHT};
        VoxelShape[] reverseHorizontalIrisShapes = new VoxelShape[]{this.HORIZONTAL_IRIS_BOTTOM, this.HORIZONTAL_IRIS_RIGHT, this.HORIZONTAL_IRIS_TOP, this.HORIZONTAL_IRIS_LEFT};
        VoxelShape[] leftHorizontalIrisShapes = new VoxelShape[]{this.HORIZONTAL_IRIS_LEFT, this.HORIZONTAL_IRIS_BOTTOM, this.HORIZONTAL_IRIS_RIGHT, this.HORIZONTAL_IRIS_TOP};
        VoxelShape[] rightHorizontalIrisShapes = new VoxelShape[]{this.HORIZONTAL_IRIS_RIGHT, this.HORIZONTAL_IRIS_TOP, this.HORIZONTAL_IRIS_LEFT, this.HORIZONTAL_IRIS_BOTTOM};
        this.IRIS_BOTTOM = new VoxelShape[][]{defaultHorizontalIrisShapes, {X_IRIS_BOTTOM, Z_IRIS_BOTTOM}, reverseHorizontalIrisShapes};
        this.IRIS_TOP = new VoxelShape[][]{reverseHorizontalIrisShapes, {X_IRIS_TOP, Z_IRIS_TOP}, defaultHorizontalIrisShapes};
        this.IRIS_LEFT = new VoxelShape[][]{leftHorizontalIrisShapes, {X_IRIS_LEFT, Z_IRIS_LEFT, X_IRIS_RIGHT, Z_IRIS_RIGHT}, leftHorizontalIrisShapes};
        this.IRIS_RIGHT = new VoxelShape[][]{rightHorizontalIrisShapes, {X_IRIS_RIGHT, Z_IRIS_RIGHT, X_IRIS_LEFT, Z_IRIS_LEFT}, rightHorizontalIrisShapes};
        this.IRIS_CORNER_TOP_LEFT = new VoxelShape[][]{{this.HORIZONTAL_IRIS_BOTTOM_LEFT, this.HORIZONTAL_IRIS_BOTTOM_RIGHT, this.HORIZONTAL_IRIS_TOP_RIGHT, this.HORIZONTAL_IRIS_TOP_LEFT}, {X_IRIS_TOP_LEFT, Z_IRIS_TOP_LEFT, X_IRIS_TOP_RIGHT, Z_IRIS_TOP_RIGHT}, {this.HORIZONTAL_IRIS_TOP_LEFT, this.HORIZONTAL_IRIS_BOTTOM_LEFT, this.HORIZONTAL_IRIS_BOTTOM_RIGHT, this.HORIZONTAL_IRIS_TOP_RIGHT}};
        this.IRIS_CORNER_BOTTOM_LEFT = new VoxelShape[][]{{this.HORIZONTAL_IRIS_TOP_LEFT, this.HORIZONTAL_IRIS_BOTTOM_LEFT, this.HORIZONTAL_IRIS_BOTTOM_RIGHT, this.HORIZONTAL_IRIS_TOP_RIGHT}, {X_IRIS_BOTTOM_LEFT, Z_IRIS_BOTTOM_LEFT, X_IRIS_BOTTOM_RIGHT, Z_IRIS_BOTTOM_RIGHT}, {this.HORIZONTAL_IRIS_BOTTOM_LEFT, this.HORIZONTAL_IRIS_BOTTOM_RIGHT, this.HORIZONTAL_IRIS_TOP_RIGHT, this.HORIZONTAL_IRIS_TOP_LEFT}};
        this.IRIS_CORNER_BOTTOM_RIGHT = new VoxelShape[][]{{this.HORIZONTAL_IRIS_TOP_RIGHT, this.HORIZONTAL_IRIS_TOP_LEFT, this.HORIZONTAL_IRIS_BOTTOM_LEFT, this.HORIZONTAL_IRIS_BOTTOM_RIGHT}, {X_IRIS_BOTTOM_RIGHT, Z_IRIS_BOTTOM_RIGHT, X_IRIS_BOTTOM_LEFT, Z_IRIS_BOTTOM_LEFT}, {this.HORIZONTAL_IRIS_BOTTOM_RIGHT, this.HORIZONTAL_IRIS_TOP_RIGHT, this.HORIZONTAL_IRIS_TOP_LEFT, this.HORIZONTAL_IRIS_BOTTOM_LEFT}};
        this.IRIS_CORNER_TOP_RIGHT = new VoxelShape[][]{{this.HORIZONTAL_IRIS_BOTTOM_RIGHT, this.HORIZONTAL_IRIS_TOP_RIGHT, this.HORIZONTAL_IRIS_TOP_LEFT, this.HORIZONTAL_IRIS_BOTTOM_LEFT}, {X_IRIS_TOP_RIGHT, Z_IRIS_TOP_RIGHT, X_IRIS_TOP_LEFT, Z_IRIS_TOP_LEFT}, {this.HORIZONTAL_IRIS_TOP_RIGHT, this.HORIZONTAL_IRIS_TOP_LEFT, this.HORIZONTAL_IRIS_BOTTOM_LEFT, this.HORIZONTAL_IRIS_BOTTOM_RIGHT}};
        VoxelShape xIrisStairTopLeft = Shapes.or((VoxelShape)X_IRIS_BOTTOM_LEFT, (VoxelShape[])new VoxelShape[]{X_IRIS_BOTTOM_RIGHT, X_IRIS_TOP_RIGHT});
        VoxelShape xIrisStairTopRight = Shapes.or((VoxelShape)X_IRIS_BOTTOM_LEFT, (VoxelShape[])new VoxelShape[]{X_IRIS_BOTTOM_RIGHT, X_IRIS_TOP_LEFT});
        VoxelShape xIrisStairBottomLeft = Shapes.or((VoxelShape)X_IRIS_TOP_LEFT, (VoxelShape[])new VoxelShape[]{X_IRIS_TOP_RIGHT, X_IRIS_BOTTOM_RIGHT});
        VoxelShape xIrisStairBottomRight = Shapes.or((VoxelShape)X_IRIS_TOP_LEFT, (VoxelShape[])new VoxelShape[]{X_IRIS_TOP_RIGHT, X_IRIS_BOTTOM_LEFT});
        VoxelShape zIrisStairTopLeft = Shapes.or((VoxelShape)Z_IRIS_BOTTOM_LEFT, (VoxelShape[])new VoxelShape[]{Z_IRIS_BOTTOM_RIGHT, Z_IRIS_TOP_RIGHT});
        VoxelShape zIrisStairTopRight = Shapes.or((VoxelShape)Z_IRIS_BOTTOM_LEFT, (VoxelShape[])new VoxelShape[]{Z_IRIS_BOTTOM_RIGHT, Z_IRIS_TOP_LEFT});
        VoxelShape zIrisStairBottomLeft = Shapes.or((VoxelShape)Z_IRIS_TOP_LEFT, (VoxelShape[])new VoxelShape[]{Z_IRIS_TOP_RIGHT, Z_IRIS_BOTTOM_RIGHT});
        VoxelShape zIrisStairBottomRight = Shapes.or((VoxelShape)Z_IRIS_TOP_LEFT, (VoxelShape[])new VoxelShape[]{Z_IRIS_TOP_RIGHT, Z_IRIS_BOTTOM_LEFT});
        VoxelShape horizontalIrisStairBottomLeft = Shapes.or((VoxelShape)this.HORIZONTAL_IRIS_BOTTOM_RIGHT, (VoxelShape[])new VoxelShape[]{this.HORIZONTAL_IRIS_TOP_LEFT, this.HORIZONTAL_IRIS_TOP_RIGHT});
        VoxelShape horizontalIrisStairBottomRight = Shapes.or((VoxelShape)this.HORIZONTAL_IRIS_BOTTOM_LEFT, (VoxelShape[])new VoxelShape[]{this.HORIZONTAL_IRIS_TOP_LEFT, this.HORIZONTAL_IRIS_TOP_RIGHT});
        VoxelShape horizontalIrisStairTopLeft = Shapes.or((VoxelShape)this.HORIZONTAL_IRIS_BOTTOM_LEFT, (VoxelShape[])new VoxelShape[]{this.HORIZONTAL_IRIS_BOTTOM_RIGHT, this.HORIZONTAL_IRIS_TOP_RIGHT});
        VoxelShape horizontalIrisStairTopRight = Shapes.or((VoxelShape)this.HORIZONTAL_IRIS_BOTTOM_LEFT, (VoxelShape[])new VoxelShape[]{this.HORIZONTAL_IRIS_BOTTOM_RIGHT, this.HORIZONTAL_IRIS_TOP_LEFT});
        this.IRIS_STAIR_TOP_LEFT = new VoxelShape[][]{{horizontalIrisStairBottomLeft, horizontalIrisStairBottomRight, horizontalIrisStairTopRight, horizontalIrisStairTopLeft}, {xIrisStairTopLeft, zIrisStairTopLeft, xIrisStairTopRight, zIrisStairTopRight}, {horizontalIrisStairTopLeft, horizontalIrisStairBottomLeft, horizontalIrisStairBottomRight, horizontalIrisStairTopRight}};
        this.IRIS_STAIR_BOTTOM_LEFT = new VoxelShape[][]{{horizontalIrisStairTopLeft, horizontalIrisStairBottomLeft, horizontalIrisStairBottomRight, horizontalIrisStairTopRight}, {xIrisStairBottomLeft, zIrisStairBottomLeft, xIrisStairBottomRight, zIrisStairBottomRight}, {horizontalIrisStairBottomLeft, horizontalIrisStairBottomRight, horizontalIrisStairTopRight, horizontalIrisStairTopLeft}};
        this.IRIS_STAIR_BOTTOM_RIGHT = new VoxelShape[][]{{horizontalIrisStairTopRight, horizontalIrisStairTopLeft, horizontalIrisStairBottomLeft, horizontalIrisStairBottomRight}, {xIrisStairBottomRight, zIrisStairBottomRight, xIrisStairBottomLeft, zIrisStairBottomLeft}, {horizontalIrisStairBottomRight, horizontalIrisStairTopRight, horizontalIrisStairTopLeft, horizontalIrisStairBottomLeft}};
        this.IRIS_STAIR_TOP_RIGHT = new VoxelShape[][]{{horizontalIrisStairBottomRight, horizontalIrisStairTopRight, horizontalIrisStairTopLeft, horizontalIrisStairBottomLeft}, {xIrisStairTopRight, zIrisStairTopRight, xIrisStairTopLeft, zIrisStairTopLeft}, {horizontalIrisStairTopRight, horizontalIrisStairTopLeft, horizontalIrisStairBottomLeft, horizontalIrisStairBottomRight}};
        this.HORIZONTAL_FULL = Block.box((double)0.0, (double)horizontalOffset, (double)0.0, (double)16.0, (double)horizontalMax, (double)16.0);
        VoxelShape horizontalBottom = Block.box((double)0.0, (double)horizontalOffset, (double)0.0, (double)16.0, (double)horizontalMax, (double)8.0);
        VoxelShape horizontalTop = Block.box((double)0.0, (double)horizontalOffset, (double)8.0, (double)16.0, (double)horizontalMax, (double)16.0);
        VoxelShape horizontalLeft = Block.box((double)0.0, (double)horizontalOffset, (double)0.0, (double)8.0, (double)horizontalMax, (double)16.0);
        VoxelShape horizontalRight = Block.box((double)8.0, (double)horizontalOffset, (double)0.0, (double)16.0, (double)horizontalMax, (double)16.0);
        VoxelShape horizontalBottomLeft = Block.box((double)0.0, (double)horizontalOffset, (double)0.0, (double)8.0, (double)horizontalMax, (double)8.0);
        VoxelShape horizontalBottomRight = Block.box((double)8.0, (double)horizontalOffset, (double)0.0, (double)16.0, (double)horizontalMax, (double)8.0);
        VoxelShape horizontalTopLeft = Block.box((double)0.0, (double)horizontalOffset, (double)8.0, (double)8.0, (double)horizontalMax, (double)16.0);
        VoxelShape horizontalTopRight = Block.box((double)8.0, (double)horizontalOffset, (double)8.0, (double)16.0, (double)horizontalMax, (double)16.0);
        VoxelShape horizontalStairBottomLeft = Shapes.or((VoxelShape)horizontalBottomRight, (VoxelShape[])new VoxelShape[]{horizontalTopLeft, horizontalTopRight});
        VoxelShape horizontalStairBottomRight = Shapes.or((VoxelShape)horizontalBottomLeft, (VoxelShape[])new VoxelShape[]{horizontalTopLeft, horizontalTopRight});
        VoxelShape horizontalStairTopLeft = Shapes.or((VoxelShape)horizontalBottomLeft, (VoxelShape[])new VoxelShape[]{horizontalBottomRight, horizontalTopRight});
        VoxelShape horizontalStairTopRight = Shapes.or((VoxelShape)horizontalBottomLeft, (VoxelShape[])new VoxelShape[]{horizontalBottomRight, horizontalTopLeft});
        VoxelShape horizontalStairBottomLeftBlocked = Shapes.or((VoxelShape)horizontalBottomRight, (VoxelShape[])new VoxelShape[]{horizontalTopLeft, horizontalTopRight, this.HORIZONTAL_IRIS_BOTTOM_LEFT});
        VoxelShape horizontalStairBottomRightBlocked = Shapes.or((VoxelShape)horizontalBottomLeft, (VoxelShape[])new VoxelShape[]{horizontalTopLeft, horizontalTopRight, this.HORIZONTAL_IRIS_BOTTOM_RIGHT});
        VoxelShape horizontalStairTopLeftBlocked = Shapes.or((VoxelShape)horizontalBottomLeft, (VoxelShape[])new VoxelShape[]{horizontalBottomRight, horizontalTopRight, this.HORIZONTAL_IRIS_TOP_LEFT});
        VoxelShape horizontalStairTopRightBlocked = Shapes.or((VoxelShape)horizontalBottomLeft, (VoxelShape[])new VoxelShape[]{horizontalBottomRight, horizontalTopLeft, this.HORIZONTAL_IRIS_TOP_RIGHT});
        this.X_FULL = Block.box((double)0.0, (double)0.0, (double)verticalStart, (double)16.0, (double)16.0, (double)verticalEnd);
        this.X_BOTTOM = Block.box((double)0.0, (double)0.0, (double)verticalStart, (double)16.0, (double)8.0, (double)verticalEnd);
        this.X_TOP = Block.box((double)0.0, (double)8.0, (double)verticalStart, (double)16.0, (double)16.0, (double)verticalEnd);
        this.X_LEFT = Block.box((double)8.0, (double)0.0, (double)verticalStart, (double)16.0, (double)16.0, (double)verticalEnd);
        this.X_RIGHT = Block.box((double)0.0, (double)0.0, (double)verticalStart, (double)8.0, (double)16.0, (double)verticalEnd);
        VoxelShape xTopLeft = Block.box((double)0.0, (double)8.0, (double)verticalStart, (double)8.0, (double)16.0, (double)verticalEnd);
        VoxelShape xTopRight = Block.box((double)8.0, (double)8.0, (double)verticalStart, (double)16.0, (double)16.0, (double)verticalEnd);
        VoxelShape xBottomLeft = Block.box((double)0.0, (double)0.0, (double)verticalStart, (double)8.0, (double)8.0, (double)verticalEnd);
        VoxelShape xBottomRight = Block.box((double)8.0, (double)0.0, (double)verticalStart, (double)16.0, (double)8.0, (double)verticalEnd);
        VoxelShape xStairTopLeft = Shapes.or((VoxelShape)xBottomLeft, (VoxelShape[])new VoxelShape[]{xBottomRight, xTopRight});
        VoxelShape xStairTopRight = Shapes.or((VoxelShape)xBottomLeft, (VoxelShape[])new VoxelShape[]{xBottomRight, xTopLeft});
        VoxelShape xStairBottomLeft = Shapes.or((VoxelShape)xTopLeft, (VoxelShape[])new VoxelShape[]{xTopRight, xBottomRight});
        VoxelShape xStairBottomRight = Shapes.or((VoxelShape)xTopLeft, (VoxelShape[])new VoxelShape[]{xTopRight, xBottomLeft});
        VoxelShape xStairTopLeftBlocked = Shapes.or((VoxelShape)xBottomLeft, (VoxelShape[])new VoxelShape[]{xBottomRight, xTopRight, X_IRIS_TOP_LEFT});
        VoxelShape xStairTopRightBlocked = Shapes.or((VoxelShape)xBottomLeft, (VoxelShape[])new VoxelShape[]{xBottomRight, xTopLeft, X_IRIS_TOP_RIGHT});
        VoxelShape xStairBottomLeftBlocked = Shapes.or((VoxelShape)xTopLeft, (VoxelShape[])new VoxelShape[]{xTopRight, xBottomRight, X_IRIS_BOTTOM_LEFT});
        VoxelShape xStairBottomRightBlocked = Shapes.or((VoxelShape)xTopLeft, (VoxelShape[])new VoxelShape[]{xTopRight, xBottomLeft, X_IRIS_BOTTOM_RIGHT});
        this.Z_FULL = Block.box((double)verticalStart, (double)0.0, (double)0.0, (double)verticalEnd, (double)16.0, (double)16.0);
        this.Z_BOTTOM = Block.box((double)verticalStart, (double)0.0, (double)0.0, (double)verticalEnd, (double)8.0, (double)16.0);
        this.Z_TOP = Block.box((double)verticalStart, (double)8.0, (double)0.0, (double)verticalEnd, (double)16.0, (double)16.0);
        this.Z_LEFT = Block.box((double)verticalStart, (double)0.0, (double)8.0, (double)verticalEnd, (double)16.0, (double)16.0);
        this.Z_RIGHT = Block.box((double)verticalStart, (double)0.0, (double)0.0, (double)verticalEnd, (double)16.0, (double)8.0);
        VoxelShape zTopLeft = Block.box((double)verticalStart, (double)8.0, (double)0.0, (double)verticalEnd, (double)16.0, (double)8.0);
        VoxelShape zTopRight = Block.box((double)verticalStart, (double)8.0, (double)8.0, (double)verticalEnd, (double)16.0, (double)16.0);
        VoxelShape zBottomLeft = Block.box((double)verticalStart, (double)0.0, (double)0.0, (double)verticalEnd, (double)8.0, (double)8.0);
        VoxelShape zBottomRight = Block.box((double)verticalStart, (double)0.0, (double)8.0, (double)verticalEnd, (double)8.0, (double)16.0);
        VoxelShape zStairTopLeft = Shapes.or((VoxelShape)zBottomLeft, (VoxelShape[])new VoxelShape[]{zBottomRight, zTopRight});
        VoxelShape zStairTopRight = Shapes.or((VoxelShape)zBottomLeft, (VoxelShape[])new VoxelShape[]{zBottomRight, zTopLeft});
        VoxelShape zStairBottomLeft = Shapes.or((VoxelShape)zTopLeft, (VoxelShape[])new VoxelShape[]{zTopRight, zBottomRight});
        VoxelShape zStairBottomRight = Shapes.or((VoxelShape)zTopLeft, (VoxelShape[])new VoxelShape[]{zTopRight, zBottomLeft});
        VoxelShape zStairTopLeftBlocked = Shapes.or((VoxelShape)zBottomLeft, (VoxelShape[])new VoxelShape[]{zBottomRight, zTopRight, Z_IRIS_TOP_LEFT});
        VoxelShape zStairTopRightBlocked = Shapes.or((VoxelShape)zBottomLeft, (VoxelShape[])new VoxelShape[]{zBottomRight, zTopLeft, Z_IRIS_TOP_RIGHT});
        VoxelShape zStairBottomLeftBlocked = Shapes.or((VoxelShape)zTopLeft, (VoxelShape[])new VoxelShape[]{zTopRight, zBottomRight, Z_IRIS_BOTTOM_LEFT});
        VoxelShape zStairBottomRightBlocked = Shapes.or((VoxelShape)zTopLeft, (VoxelShape[])new VoxelShape[]{zTopRight, zBottomLeft, Z_IRIS_BOTTOM_RIGHT});
        this.FULL = new VoxelShape[][]{{this.HORIZONTAL_FULL}, {this.X_FULL, this.Z_FULL}, {this.HORIZONTAL_FULL}};
        VoxelShape[] defaultHorizontalSlabShapes = new VoxelShape[]{horizontalTop, horizontalLeft, horizontalBottom, horizontalRight};
        VoxelShape[] reverseHorizontalSlabShapes = new VoxelShape[]{horizontalBottom, horizontalRight, horizontalTop, horizontalLeft};
        VoxelShape[] leftHorizontalSlabShapes = new VoxelShape[]{horizontalRight, horizontalTop, horizontalLeft, horizontalBottom};
        VoxelShape[] rightHorizontalSlabShapes = new VoxelShape[]{horizontalLeft, horizontalBottom, horizontalRight, horizontalTop};
        this.BOTTOM = new VoxelShape[][]{defaultHorizontalSlabShapes, {this.X_BOTTOM, this.Z_BOTTOM}, reverseHorizontalSlabShapes};
        this.TOP = new VoxelShape[][]{reverseHorizontalSlabShapes, {this.X_TOP, this.Z_TOP}, defaultHorizontalSlabShapes};
        this.LEFT = new VoxelShape[][]{leftHorizontalSlabShapes, {this.X_LEFT, this.Z_LEFT, this.X_RIGHT, this.Z_RIGHT}, leftHorizontalSlabShapes};
        this.RIGHT = new VoxelShape[][]{rightHorizontalSlabShapes, {this.X_RIGHT, this.Z_RIGHT, this.X_LEFT, this.Z_LEFT}, rightHorizontalSlabShapes};
        this.CORNER_TOP_LEFT = new VoxelShape[][]{{horizontalBottomLeft, horizontalBottomRight, horizontalTopRight, horizontalTopLeft}, {xTopLeft, zTopLeft, xTopRight, zTopRight}, {horizontalTopLeft, horizontalBottomLeft, horizontalBottomRight, horizontalTopRight}};
        this.CORNER_BOTTOM_LEFT = new VoxelShape[][]{{horizontalTopLeft, horizontalBottomLeft, horizontalBottomRight, horizontalTopRight}, {xBottomLeft, zBottomLeft, xBottomRight, zBottomRight}, {horizontalBottomLeft, horizontalBottomRight, horizontalTopRight, horizontalTopLeft}};
        this.CORNER_BOTTOM_RIGHT = new VoxelShape[][]{{horizontalTopRight, horizontalTopLeft, horizontalBottomLeft, horizontalBottomRight}, {xBottomRight, zBottomRight, xBottomLeft, zBottomLeft}, {horizontalBottomRight, horizontalTopRight, horizontalTopLeft, horizontalBottomLeft}};
        this.CORNER_TOP_RIGHT = new VoxelShape[][]{{horizontalBottomRight, horizontalTopRight, horizontalTopLeft, horizontalBottomLeft}, {xTopRight, zTopRight, xTopLeft, zTopLeft}, {horizontalTopRight, horizontalTopLeft, horizontalBottomLeft, horizontalBottomRight}};
        this.STAIR_TOP_LEFT = new VoxelShape[][]{{horizontalStairBottomLeft, horizontalStairBottomRight, horizontalStairTopRight, horizontalStairTopLeft}, {xStairTopLeft, zStairTopLeft, xStairTopRight, zStairTopRight}, {horizontalStairTopLeft, horizontalStairBottomLeft, horizontalStairBottomRight, horizontalStairTopRight}};
        this.STAIR_BOTTOM_LEFT = new VoxelShape[][]{{horizontalStairTopLeft, horizontalStairBottomLeft, horizontalStairBottomRight, horizontalStairTopRight}, {xStairBottomLeft, zStairBottomLeft, xStairBottomRight, zStairBottomRight}, {horizontalStairBottomLeft, horizontalStairBottomRight, horizontalStairTopRight, horizontalStairTopLeft}};
        this.STAIR_BOTTOM_RIGHT = new VoxelShape[][]{{horizontalStairTopRight, horizontalStairTopLeft, horizontalStairBottomLeft, horizontalStairBottomRight}, {xStairBottomRight, zStairBottomRight, xStairBottomLeft, zStairBottomLeft}, {horizontalStairBottomRight, horizontalStairTopRight, horizontalStairTopLeft, horizontalStairBottomLeft}};
        this.STAIR_TOP_RIGHT = new VoxelShape[][]{{horizontalStairBottomRight, horizontalStairTopRight, horizontalStairTopLeft, horizontalStairBottomLeft}, {xStairTopRight, zStairTopRight, xStairTopLeft, zStairTopLeft}, {horizontalStairTopRight, horizontalStairTopLeft, horizontalStairBottomLeft, horizontalStairBottomRight}};
        this.STAIR_TOP_LEFT_BLOCKED = new VoxelShape[][]{{horizontalStairBottomLeftBlocked, horizontalStairBottomRightBlocked, horizontalStairTopRightBlocked, horizontalStairTopLeftBlocked}, {xStairTopLeftBlocked, zStairTopLeftBlocked, xStairTopRightBlocked, zStairTopRightBlocked}, {horizontalStairTopLeftBlocked, horizontalStairBottomLeftBlocked, horizontalStairBottomRightBlocked, horizontalStairTopRightBlocked}};
        this.STAIR_BOTTOM_LEFT_BLOCKED = new VoxelShape[][]{{horizontalStairTopLeftBlocked, horizontalStairBottomLeftBlocked, horizontalStairBottomRightBlocked, horizontalStairTopRightBlocked}, {xStairBottomLeftBlocked, zStairBottomLeftBlocked, xStairBottomRightBlocked, zStairBottomRightBlocked}, {horizontalStairBottomLeftBlocked, horizontalStairBottomRightBlocked, horizontalStairTopRightBlocked, horizontalStairTopLeftBlocked}};
        this.STAIR_BOTTOM_RIGHT_BLOCKED = new VoxelShape[][]{{horizontalStairTopRightBlocked, horizontalStairTopLeftBlocked, horizontalStairBottomLeftBlocked, horizontalStairBottomRightBlocked}, {xStairBottomRightBlocked, zStairBottomRightBlocked, xStairBottomLeftBlocked, zStairBottomLeftBlocked}, {horizontalStairBottomRightBlocked, horizontalStairTopRightBlocked, horizontalStairTopLeftBlocked, horizontalStairBottomLeftBlocked}};
        this.STAIR_TOP_RIGHT_BLOCKED = new VoxelShape[][]{{horizontalStairBottomRightBlocked, horizontalStairTopRightBlocked, horizontalStairTopLeftBlocked, horizontalStairBottomLeftBlocked}, {xStairTopRightBlocked, zStairTopRightBlocked, xStairTopLeftBlocked, zStairTopLeftBlocked}, {horizontalStairTopRightBlocked, horizontalStairTopLeftBlocked, horizontalStairBottomLeftBlocked, horizontalStairBottomRightBlocked}};
    }

    public static VoxelShape getShapeFromArray(VoxelShape[][] shapes, Direction direction, Orientation orientation) {
        int horizontal = direction.get2DDataValue();
        int vertical = orientation.get2DDataValue();
        return shapes[vertical][horizontal % shapes[vertical].length];
    }

    public static VoxelShape getOrientedShape(Vector3d minVec, Vector3d maxVec, Matrix3d xMatrix, Matrix3d yMatrix) {
        double maxZ;
        double minZ;
        double maxY;
        double minY;
        double maxX;
        double minX;
        minVec.x -= 8.0;
        minVec.y -= 8.0;
        minVec.z -= 8.0;
        maxVec.x -= 8.0;
        maxVec.y -= 8.0;
        maxVec.z -= 8.0;
        xMatrix.transform(minVec);
        xMatrix.transform(maxVec);
        yMatrix.transform(minVec);
        yMatrix.transform(maxVec);
        minVec.x += 8.0;
        minVec.y += 8.0;
        minVec.z += 8.0;
        maxVec.x += 8.0;
        maxVec.y += 8.0;
        maxVec.z += 8.0;
        if (minVec.x <= maxVec.x) {
            minX = minVec.x;
            maxX = maxVec.x;
        } else {
            minX = maxVec.x;
            maxX = minVec.x;
        }
        if (minVec.y <= maxVec.y) {
            minY = minVec.y;
            maxY = maxVec.y;
        } else {
            minY = maxVec.y;
            maxY = minVec.y;
        }
        if (minVec.z <= maxVec.z) {
            minZ = minVec.z;
            maxZ = maxVec.z;
        } else {
            minZ = maxVec.z;
            maxZ = minVec.z;
        }
        return Block.box((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public static Matrix3d yRotationFromDirection(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> new Matrix3d();
            case Direction.EAST -> new Matrix3d().rotate((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
            case Direction.SOUTH -> new Matrix3d().rotate((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
            case Direction.WEST -> new Matrix3d().rotate((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            default -> new Matrix3d();
        };
    }

    public static Tuple<Matrix3d, Matrix3d> xyRotationFromOrientation(FrontAndTop orientation) {
        return switch (orientation) {
            case FrontAndTop.NORTH_UP -> new Tuple((Object)new Matrix3d(), (Object)new Matrix3d());
            case FrontAndTop.EAST_UP -> new Tuple((Object)new Matrix3d(), (Object)new Matrix3d().rotate((Quaternionfc)Axis.YP.rotationDegrees(270.0f)));
            case FrontAndTop.SOUTH_UP -> new Tuple((Object)new Matrix3d(), (Object)new Matrix3d().rotate((Quaternionfc)Axis.YP.rotationDegrees(180.0f)));
            case FrontAndTop.WEST_UP -> new Tuple((Object)new Matrix3d(), (Object)new Matrix3d().rotate((Quaternionfc)Axis.YP.rotationDegrees(90.0f)));
            case FrontAndTop.UP_NORTH -> new Tuple((Object)new Matrix3d().rotate((Quaternionfc)Axis.XP.rotationDegrees(90.0f)), (Object)new Matrix3d());
            case FrontAndTop.UP_EAST -> new Tuple((Object)new Matrix3d().rotate((Quaternionfc)Axis.XP.rotationDegrees(90.0f)), (Object)new Matrix3d().rotate((Quaternionfc)Axis.YP.rotationDegrees(270.0f)));
            case FrontAndTop.UP_SOUTH -> new Tuple((Object)new Matrix3d().rotate((Quaternionfc)Axis.XP.rotationDegrees(90.0f)), (Object)new Matrix3d().rotate((Quaternionfc)Axis.YP.rotationDegrees(180.0f)));
            case FrontAndTop.UP_WEST -> new Tuple((Object)new Matrix3d().rotate((Quaternionfc)Axis.XP.rotationDegrees(90.0f)), (Object)new Matrix3d().rotate((Quaternionfc)Axis.YP.rotationDegrees(90.0f)));
            case FrontAndTop.DOWN_NORTH -> new Tuple((Object)new Matrix3d().rotate((Quaternionfc)Axis.XP.rotationDegrees(-90.0f)), (Object)new Matrix3d());
            case FrontAndTop.DOWN_EAST -> new Tuple((Object)new Matrix3d().rotate((Quaternionfc)Axis.XP.rotationDegrees(-90.0f)), (Object)new Matrix3d().rotate((Quaternionfc)Axis.YP.rotationDegrees(270.0f)));
            case FrontAndTop.DOWN_SOUTH -> new Tuple((Object)new Matrix3d().rotate((Quaternionfc)Axis.XP.rotationDegrees(-90.0f)), (Object)new Matrix3d().rotate((Quaternionfc)Axis.YP.rotationDegrees(180.0f)));
            case FrontAndTop.DOWN_WEST -> new Tuple((Object)new Matrix3d().rotate((Quaternionfc)Axis.XP.rotationDegrees(-90.0f)), (Object)new Matrix3d().rotate((Quaternionfc)Axis.YP.rotationDegrees(90.0f)));
            default -> new Tuple((Object)new Matrix3d(), (Object)new Matrix3d());
        };
    }

    public static VoxelShape getOrientedShapes(ArrayList<Tuple<Vector3d, Vector3d>> minMax, FrontAndTop orientation) {
        if (minMax.size() == 0) {
            return Shapes.empty();
        }
        Tuple<Matrix3d, Matrix3d> xyRotation = VoxelShapeProvider.xyRotationFromOrientation(orientation);
        VoxelShape firstShape = VoxelShapeProvider.getOrientedShape(new Vector3d((Vector3dc)minMax.get(0).getA()), new Vector3d((Vector3dc)minMax.get(0).getB()), (Matrix3d)xyRotation.getA(), (Matrix3d)xyRotation.getB());
        if (minMax.size() > 1) {
            VoxelShape[] shapes = new VoxelShape[minMax.size() - 1];
            for (int i = 1; i < minMax.size(); ++i) {
                shapes[i - 1] = VoxelShapeProvider.getOrientedShape(new Vector3d((Vector3dc)minMax.get(i).getA()), new Vector3d((Vector3dc)minMax.get(i).getB()), (Matrix3d)xyRotation.getA(), (Matrix3d)xyRotation.getB());
            }
            return Shapes.or((VoxelShape)firstShape, (VoxelShape[])shapes);
        }
        return firstShape;
    }

    public static VoxelShape getDirectionalShapes(ArrayList<Tuple<Vector3d, Vector3d>> minMax, Direction direction) {
        if (minMax.size() == 0) {
            return Shapes.empty();
        }
        Matrix3d yRotation = VoxelShapeProvider.yRotationFromDirection(direction);
        Matrix3d noRotation = new Matrix3d();
        VoxelShape firstShape = VoxelShapeProvider.getOrientedShape(new Vector3d((Vector3dc)minMax.get(0).getA()), new Vector3d((Vector3dc)minMax.get(0).getB()), noRotation, yRotation);
        if (minMax.size() > 1) {
            VoxelShape[] shapes = new VoxelShape[minMax.size() - 1];
            for (int i = 1; i < minMax.size(); ++i) {
                shapes[i - 1] = VoxelShapeProvider.getOrientedShape(new Vector3d((Vector3dc)minMax.get(i).getA()), new Vector3d((Vector3dc)minMax.get(i).getB()), noRotation, yRotation);
            }
            return Shapes.or((VoxelShape)firstShape, (VoxelShape[])shapes);
        }
        return firstShape;
    }
}

