/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.packets;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.tech_interface.AbstractInterfaceEntity;
import net.povstalec.sgjourney.common.blocks.tech_interface.AbstractInterfaceBlock;
import net.povstalec.sgjourney.common.blockstates.InterfaceMode;

public record ServerboundInterfaceUpdatePacket(BlockPos pos, long energyTarget, InterfaceMode mode) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundInterfaceUpdatePacket> TYPE = new CustomPacketPayload.Type(StargateJourney.sgjourneyLocation("c2s_interface_update"));
    public static final StreamCodec<FriendlyByteBuf, ServerboundInterfaceUpdatePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ServerboundInterfaceUpdatePacket::pos, (StreamCodec)ByteBufCodecs.VAR_LONG, ServerboundInterfaceUpdatePacket::energyTarget, (StreamCodec)NeoForgeStreamCodecs.enumCodec(InterfaceMode.class), ServerboundInterfaceUpdatePacket::mode, ServerboundInterfaceUpdatePacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ServerboundInterfaceUpdatePacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Level level = ctx.player().level();
            BlockEntity blockEntity = level.getBlockEntity(packet.pos);
            if (blockEntity instanceof AbstractInterfaceEntity) {
                AbstractInterfaceEntity interfaceEntity = (AbstractInterfaceEntity)blockEntity;
                interfaceEntity.setEnergyTarget(packet.energyTarget);
            }
            BlockState state = level.getBlockState(packet.pos);
            Block patt0$temp = level.getBlockState(packet.pos).getBlock();
            if (patt0$temp instanceof AbstractInterfaceBlock) {
                AbstractInterfaceBlock interfaceBlock = (AbstractInterfaceBlock)patt0$temp;
                interfaceBlock.setMode(state, level, packet.pos, packet.mode);
            }
        });
    }
}

