/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.tech.TransceiverEntity;

public record ServerboundTransceiverUpdatePacket(BlockPos blockPos, boolean remove, boolean toggleFrequency, int number, boolean transmit) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundTransceiverUpdatePacket> TYPE = new CustomPacketPayload.Type(StargateJourney.sgjourneyLocation("c2s_transceiver_update"));
    public static final StreamCodec<ByteBuf, ServerboundTransceiverUpdatePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ServerboundTransceiverUpdatePacket::blockPos, (StreamCodec)ByteBufCodecs.BOOL, ServerboundTransceiverUpdatePacket::remove, (StreamCodec)ByteBufCodecs.BOOL, ServerboundTransceiverUpdatePacket::toggleFrequency, (StreamCodec)ByteBufCodecs.VAR_INT, ServerboundTransceiverUpdatePacket::number, (StreamCodec)ByteBufCodecs.BOOL, ServerboundTransceiverUpdatePacket::transmit, ServerboundTransceiverUpdatePacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ServerboundTransceiverUpdatePacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            BlockEntity blockEntity = ctx.player().level().getBlockEntity(packet.blockPos);
            if (blockEntity instanceof TransceiverEntity) {
                TransceiverEntity transceiver = (TransceiverEntity)blockEntity;
                if (packet.transmit) {
                    transceiver.sendTransmission();
                } else if (packet.toggleFrequency) {
                    transceiver.toggleFrequency();
                } else if (packet.remove) {
                    transceiver.removeFromCode();
                } else {
                    transceiver.addToCode(packet.number);
                }
            }
        });
    }
}

