/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.Galaxy;

public class AddressTable {
    public static final ResourceLocation ADDRESS_TABLES_LOCATION = StargateJourney.sgjourneyLocation("address_table");
    public static final ResourceKey<Registry<AddressTable>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ADDRESS_TABLES_LOCATION);
    public static final Codec<ResourceKey<AddressTable>> RESOURCE_KEY_CODEC = ResourceKey.codec(REGISTRY_KEY);
    public static final Codec<AddressTable> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("include_generated_addresses").forGetter(AddressTable::includeGeneratedAddresses), (App)WeightedAddress.CODEC.listOf().fieldOf("addresses").forGetter(AddressTable::getDimensions)).apply((Applicative)instance, AddressTable::new));
    private final boolean includeGeneratedAddresses;
    private final List<WeightedAddress> dimensions;

    public AddressTable(boolean includeGeneratedAddresses, List<WeightedAddress> dimensions) {
        this.includeGeneratedAddresses = includeGeneratedAddresses;
        this.dimensions = dimensions;
    }

    public boolean includeGeneratedAddresses() {
        return this.includeGeneratedAddresses;
    }

    public List<WeightedAddress> getDimensions() {
        return this.dimensions;
    }

    public static AddressTable getAddressTable(Level level, ResourceLocation addressTable) {
        RegistryAccess.Frozen registries = level.getServer().registryAccess();
        Registry registry = registries.registryOrThrow(REGISTRY_KEY);
        return (AddressTable)registry.get(addressTable);
    }

    public static Address randomAddress(MinecraftServer server, AddressTable addressTable) {
        if (server == null || addressTable == null) {
            return null;
        }
        ArrayList<WeightedAddress> addresses = new ArrayList<WeightedAddress>();
        int totalWeight = 0;
        if (addressTable.includeGeneratedAddresses()) {
            List<ResourceKey<Level>> generatedDimensions = Universe.get(server).getDimensionsWithGeneratedSolarSystems();
            for (ResourceKey resourceKey : generatedDimensions) {
                WeightedAddress address = new WeightedAddress((ResourceKey<Level>)resourceKey, 1);
                addresses.add(address);
                totalWeight += address.weight();
            }
        }
        List<WeightedAddress> datapackDimensions = addressTable.getDimensions();
        for (WeightedAddress weightedAddress : datapackDimensions) {
            if (!weightedAddress.addressDimension().right().isPresent() && server.getLevel((ResourceKey)weightedAddress.addressDimension().left().get()) == null) continue;
            addresses.add(weightedAddress);
            totalWeight += weightedAddress.weight();
        }
        Random random = new Random();
        Iterator iterator = addresses.iterator();
        WeightedAddress weightedAddress = null;
        int weight = random.nextInt(0, totalWeight + 1);
        while (iterator.hasNext() && (weight -= (weightedAddress = (WeightedAddress)iterator.next()).weight()) > 0) {
        }
        if (weightedAddress == null) {
            return null;
        }
        if (weightedAddress.addressDimension().right().isPresent()) {
            return (Address)weightedAddress.addressDimension().right().get();
        }
        return new Address.Dimension((ResourceKey<Level>)((ResourceKey)weightedAddress.addressDimension().left().get()), Optional.ofNullable(weightedAddress.galaxy()));
    }

    public static class WeightedAddress {
        private final Either<ResourceKey<Level>, Address.Immutable> addressDimension;
        private final int weight;
        @Nullable
        private ResourceKey<Galaxy> galaxy;
        public static final Codec<WeightedAddress> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)Level.RESOURCE_KEY_CODEC, Address.Immutable.CODEC).fieldOf("address").forGetter(weightedAddress -> weightedAddress.addressDimension), (App)Codec.INT.fieldOf("weight").forGetter(weightedAddress -> weightedAddress.weight), (App)Galaxy.RESOURCE_KEY_CODEC.optionalFieldOf("galaxy").forGetter(weightedAddress -> Optional.ofNullable(weightedAddress.galaxy))).apply((Applicative)instance, WeightedAddress::new));

        public WeightedAddress(Either<ResourceKey<Level>, Address.Immutable> addressDimension, int weight, Optional<ResourceKey<Galaxy>> galaxy) {
            this.addressDimension = addressDimension;
            this.weight = weight;
            this.galaxy = galaxy.orElse(null);
        }

        public WeightedAddress(ResourceKey<Level> dimension, int weight) {
            this((Either<ResourceKey<Level>, Address.Immutable>)Either.left(dimension), weight, Optional.empty());
        }

        public WeightedAddress(Address.Immutable address, int weight) {
            this((Either<ResourceKey<Level>, Address.Immutable>)Either.right((Object)address), weight, Optional.empty());
        }

        public Either<ResourceKey<Level>, Address.Immutable> addressDimension() {
            return this.addressDimension;
        }

        public int weight() {
            return this.weight;
        }

        @Nullable
        public ResourceKey<Galaxy> galaxy() {
            return this.galaxy;
        }
    }
}

