/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.StargateJourney;

public class StargateVariant {
    public static final ResourceLocation STARGATE_VARIANT_LOCATION = StargateJourney.sgjourneyLocation("stargate_variant");
    public static final ResourceKey<Registry<StargateVariant>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)STARGATE_VARIANT_LOCATION);
    public static final Codec<ResourceKey<StargateVariant>> RESOURCE_KEY_CODEC = ResourceKey.codec(REGISTRY_KEY);
    public static final ResourceLocation UNIVERSE_STARGATE = StargateJourney.sgjourneyLocation("universe_stargate");
    public static final ResourceLocation MILKY_WAY_STARGATE = StargateJourney.sgjourneyLocation("milky_way_stargate");
    public static final ResourceLocation PEGASUS_STARGATE = StargateJourney.sgjourneyLocation("pegasus_stargate");
    public static final ResourceLocation TOLLAN_STARGATE = StargateJourney.sgjourneyLocation("tollan_stargate");
    public static final ResourceLocation CLASSIC_STARGATE = StargateJourney.sgjourneyLocation("classic_stargate");
    public static final Codec<StargateVariant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("base_stargate").forGetter(StargateVariant::getBaseStargate), (App)ResourceLocation.CODEC.fieldOf("client_variant").forGetter(StargateVariant::clientVariant)).apply((Applicative)instance, StargateVariant::new));
    private final ResourceLocation baseStargate;
    private final ResourceLocation clientVariant;
    private boolean isFound = false;
    private boolean isMissing = false;

    public StargateVariant(ResourceLocation baseStargate, ResourceLocation clientVariant) {
        this.baseStargate = baseStargate;
        this.clientVariant = clientVariant;
    }

    public ResourceLocation getBaseStargate() {
        return this.baseStargate;
    }

    public ResourceLocation clientVariant() {
        return this.clientVariant;
    }

    private String getVariantPrefixFromBase(ResourceLocation baseStargate) {
        if (baseStargate.equals((Object)UNIVERSE_STARGATE)) {
            return "universe";
        }
        if (baseStargate.equals((Object)MILKY_WAY_STARGATE)) {
            return "milky_way";
        }
        if (baseStargate.equals((Object)PEGASUS_STARGATE)) {
            return "pegasus";
        }
        if (baseStargate.equals((Object)TOLLAN_STARGATE)) {
            return "tollan";
        }
        if (baseStargate.equals((Object)CLASSIC_STARGATE)) {
            return "classic";
        }
        return "[ERROR]";
    }

    public boolean isFound() {
        return this.isFound;
    }

    public boolean isMissing() {
        return this.isMissing;
    }

    public void handleLocation(boolean isLocated) {
        if (isLocated) {
            this.isFound = true;
        } else if (!this.isMissing) {
            this.isMissing = true;
            StargateJourney.LOGGER.error("Could not locate {" + this.getBaseStargate().toString() + "} variant [" + this.clientVariant().getNamespace() + ":" + this.getVariantPrefixFromBase(this.getBaseStargate()) + "/" + this.clientVariant().getPath() + "]");
        }
    }

    public void resetMissing() {
        this.isFound = false;
        this.isMissing = false;
    }
}

