/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.sgjourney.SymbolSet;

public class Symbols {
    public static final ResourceLocation ERROR_LOCATION = StargateJourney.sgjourneyLocation("textures/symbols/error.png");
    public static final ResourceLocation UNIVERSAL_LOCATION = StargateJourney.sgjourneyLocation("universal");
    public static final ResourceLocation SYMBOLS_LOCATION = StargateJourney.sgjourneyLocation("symbols");
    public static final ResourceKey<Registry<Symbols>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)SYMBOLS_LOCATION);
    public static final Codec<ResourceKey<Symbols>> RESOURCE_KEY_CODEC = ResourceKey.codec(REGISTRY_KEY);
    public static final Codec<Symbols> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Symbols::getName), (App)SymbolSet.RESOURCE_KEY_CODEC.optionalFieldOf("symbol_set").forGetter(Symbols::getSymbolSet), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(Symbols::getTexture), (App)Codec.INT.optionalFieldOf("size", (Object)38).forGetter(Symbols::getSize)).apply((Applicative)instance, Symbols::new));
    private final String name;
    private final Optional<ResourceKey<SymbolSet>> symbolSet;
    private final ResourceLocation texture;
    private final int size;

    public Symbols(String name, Optional<ResourceKey<SymbolSet>> symbolSet, ResourceLocation texture, int size) {
        this.name = name;
        this.symbolSet = symbolSet;
        this.texture = texture;
        this.size = size;
    }

    public String getName() {
        return this.name;
    }

    public String getTranslationName(boolean uniqueSymbols) {
        if (this.useSymbolSet()) {
            SymbolSet symbolSet = SymbolSet.getClientSymbolSet(this.symbolSet.get());
            return symbolSet.getName();
        }
        return this.name;
    }

    public boolean useSymbolSet() {
        return !ClientStargateConfig.unique_symbols.get() && this.symbolSet.isPresent();
    }

    public static String symbolsOrSet() {
        return ClientStargateConfig.unique_symbols.get() ? "info.sgjourney.symbols" : "info.sgjourney.symbol_set";
    }

    public Optional<ResourceKey<SymbolSet>> getSymbolSet() {
        return this.symbolSet;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public int getSize() {
        return this.size;
    }

    public ResourceLocation getSymbolTexture() {
        SymbolSet symbolSet;
        if (this.useSymbolSet() && (symbolSet = SymbolSet.getClientSymbolSet(this.symbolSet.get())) != null) {
            return symbolSet.getSymbolTexture();
        }
        ResourceLocation texture = StargateJourney.location(this.texture.getNamespace(), "textures/symbols/" + this.texture.getPath());
        return texture;
    }

    public boolean shouldRenderSymbol(int symbol) {
        SymbolSet symbolSet;
        if (this.useSymbolSet() && (symbolSet = SymbolSet.getClientSymbolSet(this.symbolSet.get())) != null) {
            return symbolSet.shouldRenderSymbol(symbol);
        }
        return symbol >= 0 && symbol < this.size;
    }

    public float getTextureOffset(int symbol) {
        float symbolSize = 1.0f / (float)this.size;
        return symbolSize * (float)(--symbol) + symbolSize / 2.0f;
    }

    public static Symbols getSymbols(Level level, ResourceKey<Symbols> symbols) {
        RegistryAccess.Frozen registries = level.getServer().registryAccess();
        Registry registry = registries.registryOrThrow(REGISTRY_KEY);
        return (Symbols)registry.get(symbols);
    }

    public static Symbols getSymbols(Level level, String name) {
        String[] split = name.split(":");
        RegistryAccess.Frozen registries = level.getServer().registryAccess();
        Registry registry = registries.registryOrThrow(REGISTRY_KEY);
        return (Symbols)registry.get(StargateJourney.location(split[0], split[1]));
    }

    public static ResourceKey<Symbols> defaultSymbols() {
        return Conversion.stringToSymbols("sgjourney:universal");
    }

    public static boolean validLocation(MinecraftServer server, ResourceLocation symbols) {
        if (symbols == null || StargateJourney.EMPTY_LOCATION.equals((Object)symbols)) {
            return false;
        }
        RegistryAccess.Frozen registries = server.registryAccess();
        Registry symbolRegistry = registries.registryOrThrow(REGISTRY_KEY);
        return symbolRegistry.containsKey(symbols);
    }

    public static ResourceLocation fromDimension(MinecraftServer server, ResourceKey<Level> dimension) {
        return Universe.get(server).getSymbols(dimension).location();
    }
}

