/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.data.TransporterNetwork;
import net.povstalec.sgjourney.common.sgjourney.transporter.Transporter;

public class TransporterConnection {
    public static final String ID = "id";
    public static final String TRANSPORTER_A = "transporter_a";
    public static final String TRANSPORTER_B = "transporter_b";
    public static final String CONNECTION_TIME = "connection_time";
    public static final int RING_TICKS = 16;
    public static final int TRANSPORT_TICKS = 30;
    private final UUID uuid;
    private final Transporter transporterA;
    private final Transporter transporterB;
    private final int timeOffsetA;
    private final int timeOffsetB;
    private final int transportStartTicks;
    protected int connectionTime;

    private TransporterConnection(MinecraftServer server, UUID uuid, Transporter transporterA, Transporter transporterB, int connectionTime) {
        this.uuid = uuid;
        this.transporterA = transporterA;
        this.transporterB = transporterB;
        this.connectionTime = connectionTime;
        this.timeOffsetA = transporterA.getTimeOffset(server);
        this.timeOffsetB = transporterB.getTimeOffset(server);
        this.transportStartTicks = this.timeOffsetA > this.timeOffsetB ? this.timeOffsetA : this.timeOffsetB;
    }

    private TransporterConnection(MinecraftServer server, UUID uuid, Transporter transporterA, Transporter transporterB) {
        this(server, uuid, transporterA, transporterB, 0);
    }

    @Nullable
    public static final TransporterConnection create(MinecraftServer server, Transporter transporterA, Transporter transporterB) {
        if (transporterA != null && transporterB != null) {
            UUID uuid = UUID.randomUUID();
            transporterA.connect(server, uuid);
            transporterB.connect(server, uuid);
            return new TransporterConnection(server, uuid, transporterA, transporterB);
        }
        return null;
    }

    private int absDifference() {
        return Math.abs(this.timeOffsetA - this.timeOffsetB);
    }

    public final void tick(MinecraftServer server) {
        int halfTransportTicks = this.transportStartTicks + 16 + 30;
        if (this.connectionTime >= 2 * halfTransportTicks || !this.isTransporterValid(server, this.transporterA) || !this.isTransporterValid(server, this.transporterB)) {
            this.terminate(server);
            return;
        }
        if (this.connectionTime == halfTransportTicks) {
            this.transport(server);
        }
        this.updateTransporterTicks(server, this.transporterA, this.timeOffsetA);
        this.updateTransporterTicks(server, this.transporterB, this.timeOffsetB);
        this.increaseTicks();
    }

    private void updateTransporterTicks(MinecraftServer server, Transporter transporter, int timeOffset) {
        if (timeOffset == this.transportStartTicks) {
            transporter.updateTicks(server, this.connectionTime);
        } else {
            int ticks = this.connectionTime - (this.transportStartTicks - timeOffset);
            if (ticks >= 0) {
                transporter.updateTicks(server, ticks);
            }
        }
    }

    private void increaseTicks() {
        ++this.connectionTime;
    }

    private void transport(MinecraftServer server) {
        List<Entity> travelersA = this.transporterA.entitiesToTransport(server);
        List<Entity> travelersB = this.transporterB.entitiesToTransport(server);
        this.transporterA.transportTravelers(server, this, this.transporterB, travelersA);
        this.transporterB.transportTravelers(server, this, this.transporterA, travelersB);
    }

    public final void terminate(MinecraftServer server) {
        if (this.transporterA != null) {
            this.transporterA.reset(server);
        }
        if (this.transporterB != null) {
            this.transporterB.reset(server);
        }
        TransporterNetwork.get(server).removeConnection(this.uuid);
    }

    public final boolean isTransporterValid(MinecraftServer server, Transporter transporter) {
        if (transporter == null) {
            StargateJourney.LOGGER.error("Transporter does not exist");
            return false;
        }
        return transporter.isConnected(server);
    }

    public UUID getID() {
        return this.uuid;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.put(TRANSPORTER_A, (Tag)this.serializeTransporter(this.transporterA));
        tag.put(TRANSPORTER_B, (Tag)this.serializeTransporter(this.transporterB));
        tag.putInt(CONNECTION_TIME, this.connectionTime);
        return tag;
    }

    protected CompoundTag serializeTransporter(Transporter transporter) {
        CompoundTag tag = new CompoundTag();
        tag.putString(ID, transporter.getID().toString());
        return tag;
    }

    @Nullable
    public static TransporterConnection deserialize(MinecraftServer server, UUID uuid, CompoundTag tag) {
        Transporter transporterA = TransporterConnection.deserializeTransporter(server, tag.getCompound(TRANSPORTER_A));
        Transporter transporterB = TransporterConnection.deserializeTransporter(server, tag.getCompound(TRANSPORTER_B));
        int connectionTime = tag.getInt(CONNECTION_TIME);
        return new TransporterConnection(server, uuid, transporterA, transporterB, connectionTime);
    }

    private static Transporter deserializeTransporter(MinecraftServer server, CompoundTag transporterInfo) {
        return BlockEntityList.get(server).getTransporter(UUID.fromString(transporterInfo.getString(ID)));
    }

    public static enum Type {
        DIMENSIONAL,
        SYSTEM_WIDE,
        INTERSTELLAR,
        INTERGALACTIC;

    }
}

