/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney.info;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.shielding.AbstractShieldingBlock;
import net.povstalec.sgjourney.common.blockstates.ShieldingState;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.items.StargateIrisItem;
import net.povstalec.sgjourney.common.packets.ClientBoundSoundPackets;

public class IrisInfo {
    protected AbstractStargateEntity stargate;
    protected short irisProgress;
    protected short oldIrisProgress;
    protected final ItemStackHandler irisItemHandler;

    public IrisInfo(AbstractStargateEntity stargate) {
        this.stargate = stargate;
        this.irisProgress = 0;
        this.oldIrisProgress = 0;
        this.irisItemHandler = this.createIrisHandler();
    }

    public void decreaseIrisDurability() {
        if (this.irisItemHandler.getStackInSlot(0).isEmpty()) {
            return;
        }
        Block block = this.stargate.getBlockState().getBlock();
        if (block instanceof AbstractStargateBaseBlock) {
            boolean shouldDestroyIris;
            AbstractStargateBaseBlock stargateBlock = (AbstractStargateBaseBlock)block;
            boolean bl = shouldDestroyIris = !StargateIrisItem.decreaseDurability(this.irisItemHandler.getStackInSlot(0));
            if (shouldDestroyIris) {
                AbstractShieldingBlock.destroyShielding(this.stargate.getLevel(), this.stargate.getBlockPos(), stargateBlock.getShieldingParts(), this.stargate.getDirection(), this.stargate.getOrientation());
            }
        }
    }

    public boolean isIrisClosed() {
        return this.hasIris() && this.irisProgress == 58;
    }

    public int getIrisDurability() {
        return this.hasIris() ? StargateIrisItem.getDurability(this.getIris()) : 0;
    }

    public int getIrisMaxDurability() {
        Item item = this.getIris().getItem();
        if (item instanceof StargateIrisItem) {
            StargateIrisItem iris = (StargateIrisItem)item;
            return iris.getMaxDurability();
        }
        return 0;
    }

    public ShieldingState getShieldingState() {
        return ShieldingState.fromProgress(this.irisProgress);
    }

    protected void setIrisState() {
        if (this.irisProgress == ShieldingState.CLOSED.getProgress()) {
            if (this.oldIrisProgress > this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.MOVING_4);
            } else if (this.oldIrisProgress < this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.CLOSED);
            }
            return;
        }
        if (this.irisProgress == ShieldingState.MOVING_4.getProgress()) {
            if (this.oldIrisProgress > this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.MOVING_3);
            } else if (this.oldIrisProgress < this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.MOVING_4);
            }
            return;
        }
        if (this.irisProgress == ShieldingState.MOVING_3.getProgress()) {
            if (this.oldIrisProgress > this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.MOVING_2);
            } else if (this.oldIrisProgress < this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.MOVING_3);
            }
            return;
        }
        if (this.irisProgress == ShieldingState.MOVING_2.getProgress()) {
            if (this.oldIrisProgress > this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.MOVING_1);
            } else if (this.oldIrisProgress < this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.MOVING_2);
            }
            return;
        }
        if (this.irisProgress == ShieldingState.MOVING_1.getProgress()) {
            if (this.oldIrisProgress > this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.OPEN);
            } else if (this.oldIrisProgress < this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.MOVING_1);
            }
            return;
        }
        if (this.irisProgress == 0 && this.oldIrisProgress > this.irisProgress) {
            this.stargate.setStargateState(true, true, ShieldingState.OPEN);
        }
    }

    public boolean addIris(ItemStack stack) {
        if (this.setIris(stack)) {
            this.irisProgress = (short)58;
            this.oldIrisProgress = (short)58;
            this.stargate.setStargateState(true, true, ShieldingState.CLOSED);
            return true;
        }
        return false;
    }

    public void removeIris() {
        if (this.unsetIris()) {
            ShieldingState shieldingState = ShieldingState.OPEN;
            this.irisProgress = shieldingState.getProgress();
            this.oldIrisProgress = shieldingState.getProgress();
            this.stargate.setStargateState(true, true, ShieldingState.OPEN);
        }
    }

    public short increaseIrisProgress() {
        this.oldIrisProgress = this.irisProgress;
        if (this.hasIris() && this.irisProgress < 58) {
            this.irisProgress = (short)(this.irisProgress + 1);
            this.setIrisState();
        }
        return this.irisProgress;
    }

    public short decreaseIrisProgress() {
        this.oldIrisProgress = this.irisProgress;
        if (this.hasIris() && this.irisProgress > 0) {
            this.irisProgress = (short)(this.irisProgress - 1);
            this.setIrisState();
        }
        return this.irisProgress;
    }

    public float checkIrisState() {
        return (float)this.irisProgress * 100.0f / 58.0f;
    }

    protected ItemStackHandler createIrisHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                IrisInfo.this.stargate.setChanged();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.getItem() instanceof StargateIrisItem;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public void playIrisThudSound() {
        if (!this.stargate.getLevel().isClientSide()) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.stargate.getLevel()), (ChunkPos)this.stargate.getLevel().getChunkAt(this.stargate.getBlockPos()).getPos(), (CustomPacketPayload)new ClientBoundSoundPackets.IrisThud(this.stargate.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean hasIris() {
        return this.irisItemHandler.getStackInSlot(0).getItem() instanceof StargateIrisItem;
    }

    public void setIrisProgress(short oldIrisProgress, short irisProgress) {
        this.oldIrisProgress = oldIrisProgress;
        this.irisProgress = irisProgress;
    }

    public void setIrisProgress(short irisProgress) {
        this.setIrisProgress(this.irisProgress, irisProgress);
    }

    public short getIrisProgress() {
        return this.hasIris() ? this.irisProgress : (short)0;
    }

    public float getIrisProgress(float partialTick) {
        return StargateJourneyConfig.disable_smooth_animations.get() ? (float)this.getIrisProgress() : Mth.lerp((float)partialTick, (float)this.oldIrisProgress, (float)this.irisProgress);
    }

    public Optional<ResourceLocation> getIrisTexture() {
        if (!this.hasIris()) {
            return Optional.empty();
        }
        return Optional.ofNullable(StargateIrisItem.getIrisTexture(this.irisItemHandler.getStackInSlot(0)));
    }

    public boolean setIris(ItemStack stack) {
        if (this.irisItemHandler.getStackInSlot(0).isEmpty()) {
            this.irisItemHandler.setStackInSlot(0, stack.copy());
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack getIris() {
        return this.irisItemHandler.getStackInSlot(0).copy();
    }

    public boolean unsetIris() {
        if (!this.irisItemHandler.getStackInSlot(0).isEmpty()) {
            this.irisItemHandler.setStackInSlot(0, ItemStack.EMPTY);
            return true;
        }
        return false;
    }

    public CompoundTag serializeIrisInventory(HolderLookup.Provider registries) {
        return this.irisItemHandler.serializeNBT(registries);
    }

    public void deserializeIrisInventory(HolderLookup.Provider registries, CompoundTag tag) {
        this.irisItemHandler.deserializeNBT(registries, tag);
    }

    public static interface Interface {
        public static final String IRIS_PROGRESS = "iris_progress";
        public static final String IRIS_INVENTORY = "iris_inventory";

        public IrisInfo irisInfo();
    }
}

