/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney.stargate;

import java.lang.ref.WeakReference;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.IrisStargateEntity;
import net.povstalec.sgjourney.common.block_entities.tech_interface.AbstractInterfaceEntity;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.misc.CoordinateHelper;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.Dialing;
import net.povstalec.sgjourney.common.sgjourney.SolarSystem;
import net.povstalec.sgjourney.common.sgjourney.StargateConnection;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.Wormhole;
import net.povstalec.sgjourney.common.sgjourney.stargate.Stargate;

public class SGJourneyStargate
implements Stargate {
    public static final double MIN_TRAVELER_SPEED = 0.4;
    public static final double INNER_RADIUS = 2.5;
    public static final int KAWOOSH_TICKS = 40;
    protected Address.Immutable address;
    @Nullable
    protected WeakReference<AbstractStargateEntity> stargate;
    protected ResourceKey<Level> dimension;
    protected BlockPos blockPos;
    protected boolean hasDHD;
    protected StargateInfo.Gen generation;
    protected int timesOpened;
    protected int network;
    protected Vec3 forward = null;
    protected Vec3 up = null;
    protected Vec3 right = null;
    protected Wormhole wormhole = new Wormhole();

    public SGJourneyStargate() {
    }

    public SGJourneyStargate(AbstractStargateEntity stargate) {
        this.address = stargate.get9ChevronAddress();
        this.dimension = stargate.getLevel().dimension();
        this.blockPos = stargate.getBlockPos();
        this.hasDHD = stargate.dhdInfo().hasDHD();
        this.generation = stargate.getGeneration();
        this.timesOpened = stargate.getTimesOpened();
        this.network = stargate.getNetwork();
        this.cacheStargateEntity(stargate);
    }

    @Override
    public Address.Immutable get9ChevronAddress() {
        return this.address;
    }

    @Override
    @Nullable
    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public StargateInfo.ChevronLockSpeed getChevronLockSpeed(boolean doKawoosh) {
        return StargateInfo.ChevronLockSpeed.FAST;
    }

    @Override
    @Nullable
    public Vec3 getPosition(MinecraftServer server) {
        return this.stargateReturn(server, stargate -> stargate.getCenter(), null);
    }

    @Override
    @Nullable
    public Vec3 getForward(MinecraftServer server) {
        if (this.forward == null) {
            this.forward = this.stargateReturn(server, stargate -> {
                Direction direction = stargate.getDirection();
                Orientation orientation = stargate.getOrientation();
                return Orientation.getForwardVector(direction, orientation);
            }, null);
        }
        return this.forward;
    }

    @Override
    @Nullable
    public Vec3 getUp(MinecraftServer server) {
        if (this.up == null) {
            this.up = this.stargateReturn(server, stargate -> {
                Direction direction = stargate.getDirection();
                Orientation orientation = stargate.getOrientation();
                return Orientation.getUpVector(direction, orientation);
            }, null);
        }
        return this.up;
    }

    @Override
    public Vec3 getRight(MinecraftServer server) {
        if (this.right == null && this.getForward(server) != null && this.getUp(server) != null) {
            this.right = CoordinateHelper.Relative.vecRight(this.getForward(server), this.getUp(server));
        }
        return this.right;
    }

    @Override
    public double getInnerRadius() {
        return 2.5;
    }

    @Override
    @Nullable
    public SolarSystem.Serializable getSolarSystem(MinecraftServer server) {
        return Universe.get(server).getSolarSystemFromDimension(this.getDimension());
    }

    @Override
    public boolean hasDHD() {
        return this.hasDHD;
    }

    @Override
    public StargateInfo.Gen getGeneration() {
        return this.generation;
    }

    @Override
    public int getTimesOpened() {
        return this.timesOpened;
    }

    @Override
    public int getNetwork() {
        return this.network;
    }

    @Override
    public Address.Mutable getAddress(MinecraftServer server) {
        return this.stargateReturn(server, stargate -> stargate.getAddress(), new Address.Mutable());
    }

    private AbstractStargateEntity cacheStargateEntity(AbstractStargateEntity stargate) {
        return stargate;
    }

    @Nullable
    private AbstractStargateEntity tryCacheStargateEntity(MinecraftServer server) {
        BlockEntity blockEntity;
        ServerLevel level = server.getLevel(this.dimension);
        if (level != null && (blockEntity = level.getBlockEntity(this.blockPos)) instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            return this.cacheStargateEntity(stargate);
        }
        return null;
    }

    @Nullable
    public AbstractStargateEntity getStargateEntity(MinecraftServer server) {
        return this.tryCacheStargateEntity(server);
    }

    @Override
    public StargateInfo.Feedback resetStargate(MinecraftServer server, StargateInfo.Feedback feedback, boolean updateInterfaces) {
        AbstractStargateEntity stargateEntity = this.getStargateEntity(server);
        this.stargate = null;
        if (stargateEntity != null) {
            return stargateEntity.resetStargate(feedback, updateInterfaces);
        }
        StargateJourney.LOGGER.error("Failed to reset Stargate as it does not exist");
        return feedback;
    }

    @Override
    public boolean isConnected(MinecraftServer server) {
        return this.stargateReturn(server, stargate -> stargate.isConnected(), false);
    }

    @Override
    public boolean isObstructed(MinecraftServer server) {
        return this.stargateReturn(server, stargate -> stargate.isConnected(), false);
    }

    @Override
    public boolean isPrimary(MinecraftServer server) {
        return this.stargateReturn(server, stargate -> stargate.isPrimary(), false);
    }

    @Override
    public boolean isValid(MinecraftServer server) {
        AbstractStargateEntity stargate = this.getStargateEntity(server);
        if (stargate != null) {
            stargate.checkStargate();
            return true;
        }
        StargateJourney.LOGGER.error("Stargate not found");
        return false;
    }

    @Override
    public boolean isLoaded(MinecraftServer server) {
        ServerLevel level = server.getLevel(this.getDimension());
        if (level == null) {
            return false;
        }
        return level.isLoaded(this.getBlockPos());
    }

    @Override
    public void setChevronConfiguration(MinecraftServer server, int[] chevronConfiguration) {
        this.stargateRun(server, stargate -> stargate.setEngagedChevrons(chevronConfiguration));
    }

    @Override
    public void update(MinecraftServer server) {
        this.stargateRun(server, stargate -> {
            this.hasDHD = stargate.dhdInfo().hasDHD();
            this.generation = stargate.getGeneration();
            this.timesOpened = stargate.getTimesOpened();
            this.network = stargate.getNetwork();
        });
    }

    @Override
    public void updateClient(MinecraftServer server) {
        this.stargateRun(server, stargate -> stargate.updateClient());
    }

    @Override
    public void updateInterfaceBlocks(MinecraftServer server, @Nullable AbstractInterfaceEntity.InterfaceType type, @Nullable String eventName, Object ... objects) {
        this.stargateRun(server, stargate -> {
            if (type == null) {
                stargate.updateInterfaceBlocks(eventName, objects);
            } else if (type == AbstractInterfaceEntity.InterfaceType.BASIC) {
                stargate.updateBasicInterfaceBlocks(eventName, objects);
            } else if (type == AbstractInterfaceEntity.InterfaceType.CRYSTAL) {
                stargate.updateCrystalInterfaceBlocks(eventName, objects);
            } else if (type == AbstractInterfaceEntity.InterfaceType.ADVANCED_CRYSTAL) {
                stargate.updateAdvancedCrystalInterfaceBlocks(eventName, objects);
            }
        });
    }

    @Override
    public void receiveStargateMessage(MinecraftServer server, String message) {
        this.stargateRun(server, stargate -> stargate.receiveStargateMessage(message));
    }

    @Override
    public void forwardTransmission(MinecraftServer server, int transmissionJumps, int frequency, String transmission) {
        this.stargateRun(server, stargate -> stargate.forwardTransmission(transmissionJumps, frequency, transmission));
    }

    @Override
    public float checkStargateShieldingState(MinecraftServer server) {
        return this.stargateReturn(server, stargate -> {
            Float f;
            if (stargate instanceof IrisStargateEntity) {
                IrisStargateEntity irisStargate = (IrisStargateEntity)stargate;
                f = Float.valueOf(irisStargate.irisInfo().checkIrisState());
            } else {
                f = Float.valueOf(0.0f);
            }
            return f;
        }, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public long getEnergyStored(MinecraftServer server) {
        return this.stargateReturn(server, stargate -> stargate.getEnergyStored(), 0L);
    }

    @Override
    public long getEnergyCapacity(MinecraftServer server) {
        return this.stargateReturn(server, stargate -> stargate.getEnergyCapacity(), 0L);
    }

    @Override
    public long extractEnergy(MinecraftServer server, long energy, boolean simulate) {
        return this.stargateReturn(server, stargate -> stargate.depleteEnergy(energy, simulate), 0L);
    }

    @Override
    public void connectionUpdate(MinecraftServer server, StargateConnection connection) {
        this.stargateRun(server, stargate -> {
            stargate.setKawooshTickCount(connection.getKawooshTime(server));
            stargate.setOpenTime(connection.getOpenTime());
            stargate.setTimeSinceLastTraveler(connection.getTimeSinceLastTraveler());
        });
    }

    @Override
    public int dialedEngageTime(MinecraftServer server, boolean doKawoosh) {
        return this.stargateReturn(server, stargate -> stargate.getChevronLockSpeed(doKawoosh).getKawooshStartTicks(), StargateInfo.ChevronLockSpeed.SLOW.getKawooshStartTicks());
    }

    @Override
    public int wormholeEstablishTime(MinecraftServer server, boolean doKawoosh) {
        return 40;
    }

    private static StargateInfo.Feedback noStargate() {
        StargateJourney.LOGGER.error("Stargate Entity could not be found");
        return StargateInfo.Feedback.UNKNOWN_ERROR;
    }

    @Override
    public StargateInfo.Feedback tryConnect(MinecraftServer server, Stargate dialingStargate, Address.Type addressType, boolean doKawoosh) {
        return this.stargateReturn(server, stargate -> {
            if (stargate.isObstructed()) {
                return StargateInfo.Feedback.TARGET_OBSTRUCTED;
            }
            if (stargate.isRestricted(dialingStargate.getNetwork())) {
                return StargateInfo.Feedback.TARGET_RESTRICTED;
            }
            if (stargate.addressFilterInfo().getFilterType().isBlacklist() && stargate.addressFilterInfo().isAddressBlacklisted(dialingStargate.getConnectionAddress(server, this.getSolarSystem(server), addressType))) {
                return StargateInfo.Feedback.BLACKLISTED_BY_TARGET;
            }
            if (stargate.addressFilterInfo().getFilterType().isWhitelist() && !stargate.addressFilterInfo().isAddressWhitelisted(dialingStargate.getConnectionAddress(server, this.getSolarSystem(server), addressType))) {
                return StargateInfo.Feedback.NOT_WHITELISTED_BY_TARGET;
            }
            return Dialing.connectStargates(server, dialingStargate, this, addressType, doKawoosh);
        }, SGJourneyStargate.noStargate());
    }

    @Override
    public void connectStargate(MinecraftServer server, StargateConnection connection, StargateConnection.State connectionState) {
        this.stargateRun(server, stargate -> stargate.connectStargate(connection.getID(), connectionState));
    }

    @Override
    public void doWhileConnecting(MinecraftServer server, StargateConnection connection, boolean incoming, int kawooshStartTicks) {
        this.stargateRun(server, stargate -> stargate.doWhileConnecting(incoming, connection.doKawoosh(), kawooshStartTicks, connection.getConnectionTime()));
    }

    @Override
    public void doWhileDialed(MinecraftServer server, StargateConnection connection, Address connectedAddress, int kawooshStartTicks) {
        this.stargateRun(server, stargate -> stargate.doWhileDialed(connectedAddress, kawooshStartTicks, connection.doKawoosh(), connection.getConnectionTime()));
    }

    @Override
    public void doWhileConnected(MinecraftServer server, StargateConnection connection, boolean incoming) {
        this.stargateRun(server, stargate -> stargate.doWhileConnected(incoming, connection.getConnectionTime()));
    }

    protected void wormholeEntities(MinecraftServer server, StargateConnection connection, Stargate destinationStargate, boolean incoming, StargateInfo.WormholeTravel wormholeTravel, List<Entity> wormholeCandidates) {
        this.stargateRun(server, stargate -> {
            if (this.wormhole.wormholeEntities(server, connection, this, destinationStargate, wormholeTravel, wormholeCandidates)) {
                connection.setUsed(true);
            }
        });
    }

    @Override
    public void doWormhole(MinecraftServer server, StargateConnection connection, boolean incoming, StargateInfo.WormholeTravel wormholeTravel) {
        this.stargateRun(server, stargate -> {
            Stargate connectedStargate;
            IrisStargateEntity irisStargate;
            List<Entity> wormholeCandidates = stargate.findWormholeCandidates();
            if (stargate instanceof IrisStargateEntity && (irisStargate = (IrisStargateEntity)stargate).irisInfo().isIrisClosed()) {
                return;
            }
            Stargate stargate2 = connectedStargate = incoming ? connection.getDialingStargate() : connection.getDialedStargate();
            if (!wormholeCandidates.isEmpty() && connection.used()) {
                connection.setTimeSinceLastTraveler(0);
            }
            this.wormholeEntities(server, connection, connectedStargate, incoming, wormholeTravel, wormholeCandidates);
        });
    }

    @Override
    @Nullable
    public Entity receiveTraveler(MinecraftServer server, StargateConnection connection, Stargate initialStargate, Entity traveler, Vec3 relativePosition, Vec3 relativeMomentum, Vec3 relativeLookAngle) {
        return this.stargateReturn(server, stargate -> {
            IrisStargateEntity irisStargate;
            Vec3 tempMomentum = stargate.pushTraveler() && relativeMomentum.x() > -0.4 ? new Vec3(-0.4, relativeMomentum.y(), relativeMomentum.z()) : relativeMomentum;
            Vec3 destinationPosition = this.fromStargateCoords(server, relativePosition, true, true).add(stargate.getCenter());
            Vec3 destinationMomentum = this.fromStargateCoords(server, tempMomentum, false, true);
            Vec3 destinationLookAngle = this.fromStargateCoords(server, relativeLookAngle, false, true);
            if (stargate instanceof IrisStargateEntity && !this.wormhole.checkShielding(irisStargate = (IrisStargateEntity)stargate, destinationPosition, destinationMomentum, traveler)) {
                this.wormhole.handleShielding(server, irisStargate, traveler);
                return traveler;
            }
            return this.wormhole.receiveTraveler((ServerLevel)stargate.getLevel(), this, traveler, destinationPosition, destinationMomentum, destinationLookAngle);
        }, null);
    }

    @Override
    public boolean shouldAutoclose(MinecraftServer server, StargateConnection connection) {
        return this.stargateReturn(server, stargate -> {
            if (stargate.dhdInfo().autoclose() <= 0) {
                return false;
            }
            return connection.getTimeSinceLastTraveler() > stargate.dhdInfo().autoclose() * 20;
        }, false);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag stargateTag = new CompoundTag();
        ResourceKey<Level> level = this.getDimension();
        BlockPos pos = this.getBlockPos();
        stargateTag.putString("Dimension", level.location().toString());
        stargateTag.putIntArray("Coordinates", new int[]{pos.getX(), pos.getY(), pos.getZ()});
        stargateTag.putBoolean("HasDHD", this.hasDHD);
        stargateTag.putInt("Generation", this.generation.getGen());
        stargateTag.putInt("TimesOpened", this.timesOpened);
        stargateTag.putInt("Network", this.network);
        return stargateTag;
    }

    @Override
    public void deserializeNBT(MinecraftServer server, Address.Immutable address, CompoundTag tag) {
        this.address = address;
        this.dimension = Conversion.stringToDimension(tag.getString("Dimension"));
        this.blockPos = Conversion.intArrayToBlockPos(tag.getIntArray("Coordinates"));
        if (!(tag.contains("HasDHD") && tag.contains("Generation") && tag.contains("TimesOpened") && tag.contains("Network"))) {
            BlockEntity blockEntity = server.getLevel(this.dimension).getBlockEntity(this.blockPos);
            if (blockEntity instanceof AbstractStargateEntity) {
                AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
                this.hasDHD = stargate.dhdInfo().hasDHD();
                this.generation = stargate.getGeneration();
                this.timesOpened = stargate.getTimesOpened();
                this.network = stargate.getNetwork();
                this.cacheStargateEntity(stargate);
            } else {
                StargateJourney.LOGGER.info("Failed to deserialize Stargate " + address.toString());
            }
        } else {
            this.hasDHD = tag.getBoolean("HasDHD");
            this.generation = StargateInfo.Gen.intToGen(tag.getInt("Generation"));
            this.timesOpened = tag.getInt("TimesOpened");
            this.network = tag.getInt("Network");
            this.stargate = null;
        }
    }

    public String toString() {
        return "[ " + this.address.toString() + " | DHD: " + this.hasDHD + " | Generation: " + String.valueOf((Object)this.generation) + " | Times Opened: " + this.timesOpened + " ]";
    }

    private void stargateRun(MinecraftServer server, StargateConsumer<AbstractStargateEntity> consumer) {
        AbstractStargateEntity stargate = this.getStargateEntity(server);
        if (stargate != null) {
            consumer.run(stargate);
        }
    }

    private <T> T stargateReturn(MinecraftServer server, ReturnStargateConsumer<T, AbstractStargateEntity> consumer, @Nullable T defaultValue) {
        AbstractStargateEntity stargate = this.getStargateEntity(server);
        if (stargate != null) {
            return consumer.run(stargate);
        }
        return defaultValue;
    }

    public static interface ReturnStargateConsumer<T, S extends AbstractStargateEntity> {
        public T run(S var1);
    }

    public static interface StargateConsumer<S extends AbstractStargateEntity> {
        public void run(S var1);
    }
}

