/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney.stargate;

import java.util.Random;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.init.EntityInit;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.Dialing;
import net.povstalec.sgjourney.common.sgjourney.SolarSystem;
import net.povstalec.sgjourney.common.sgjourney.StargateConnection;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.stargate.Stargate;
import org.jetbrains.annotations.Nullable;

public class SpawnerStargate
implements Stargate {
    public static final double INNER_RADIUS = 2.5;
    public static final int KAWOOSH_TICKS = 40;
    protected Address.Immutable id9ChevronAddress;
    protected final int attackerMinCount;
    protected final int attackerMaxCount;
    protected final int attackerMinInterval;
    protected final int attackerMaxInverval;
    protected Address.Mutable address = new Address.Mutable();
    @Nullable
    protected UUID connectionID = null;
    protected Random random;
    protected int counter;
    protected int timer;

    public SpawnerStargate(Address.Immutable address, int attackerMinCount, int attackerMaxCount, int attackerMinInterval, int attackerMaxInverval) {
        this.id9ChevronAddress = address;
        this.random = new Random();
        this.attackerMinCount = attackerMinCount;
        this.attackerMaxCount = attackerMaxCount;
        this.attackerMinInterval = attackerMinInterval;
        this.attackerMaxInverval = attackerMaxInverval;
        this.timer = this.nextAttackerInterval();
        this.counter = this.nextAttackerCount();
    }

    protected int nextAttackerInterval() {
        return this.random.nextInt(this.attackerMinInterval, this.attackerMaxInverval + 1);
    }

    protected int nextAttackerCount() {
        return this.random.nextInt(this.attackerMinCount, this.attackerMaxCount + 1);
    }

    @Override
    public Address.Immutable get9ChevronAddress() {
        return this.id9ChevronAddress;
    }

    @Override
    @Nullable
    public ResourceKey<Level> getDimension() {
        return null;
    }

    @Override
    @Nullable
    public Vec3 getPosition(MinecraftServer server) {
        return null;
    }

    @Override
    @Nullable
    public Vec3 getForward(MinecraftServer server) {
        return null;
    }

    @Override
    @Nullable
    public Vec3 getUp(MinecraftServer server) {
        return null;
    }

    @Override
    @Nullable
    public Vec3 getRight(MinecraftServer server) {
        return null;
    }

    @Override
    public double getInnerRadius() {
        return 0.0;
    }

    @Override
    @Nullable
    public SolarSystem.Serializable getSolarSystem(MinecraftServer server) {
        return Universe.get(server).getSolarSystemFromDimension(Conversion.stringToDimension("sgjourney:abydos"));
    }

    @Override
    public boolean hasDHD() {
        return true;
    }

    @Override
    public StargateInfo.Gen getGeneration() {
        return StargateInfo.Gen.GEN_2;
    }

    @Override
    public int getTimesOpened() {
        return 0;
    }

    @Override
    public Address.Mutable getAddress(MinecraftServer server) {
        return this.address;
    }

    @Override
    public StargateInfo.Feedback resetStargate(MinecraftServer server, StargateInfo.Feedback feedback, boolean updateInterfaces) {
        this.connectionID = null;
        this.address.reset();
        this.timer = this.nextAttackerInterval();
        this.counter = this.nextAttackerCount();
        return feedback;
    }

    @Override
    public boolean isConnected(MinecraftServer server) {
        return this.connectionID != null;
    }

    @Override
    public boolean isObstructed(MinecraftServer server) {
        return false;
    }

    @Override
    public boolean isValid(MinecraftServer server) {
        return true;
    }

    @Override
    public boolean isLoaded(MinecraftServer server) {
        return true;
    }

    @Override
    public float checkStargateShieldingState(MinecraftServer server) {
        return 0.0f;
    }

    @Override
    public long getEnergyStored(MinecraftServer server) {
        return (Long)CommonStargateConfig.intergalactic_connection_energy_cost.get();
    }

    @Override
    public long getEnergyCapacity(MinecraftServer server) {
        return (Long)CommonStargateConfig.stargate_energy_capacity.get();
    }

    @Override
    public long extractEnergy(MinecraftServer server, long energy, boolean simulate) {
        return Math.min(energy, this.getEnergyStored(server));
    }

    @Override
    public int dialedEngageTime(MinecraftServer server, boolean doKawoosh) {
        return StargateInfo.ChevronLockSpeed.SLOW.getKawooshStartTicks();
    }

    @Override
    public int wormholeEstablishTime(MinecraftServer server, boolean doKawoosh) {
        return 40;
    }

    public void encodeAddress(Address address) {
        this.address = new Address.Mutable(address);
    }

    public StargateInfo.Feedback dial(MinecraftServer server) {
        return Dialing.dialStargate(server, this, this.getAddress(server), true, true);
    }

    @Override
    public StargateInfo.Feedback tryConnect(MinecraftServer server, Stargate dialingStargate, Address.Type addressType, boolean doKawoosh) {
        StargateJourney.LOGGER.error("Stargate does not permit connections");
        return StargateInfo.Feedback.UNKNOWN_ERROR;
    }

    @Override
    public void connectStargate(MinecraftServer server, StargateConnection connection, StargateConnection.State connectionState) {
        this.connectionID = connection.getID();
    }

    protected Entity createEntity(ServerLevel level, EntityType<?> entityType) {
        return entityType.create((Level)level);
    }

    protected void spawnEntity(ServerLevel level, Entity entity) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.EVENT, (SpawnGroupData)null);
        }
    }

    @Override
    public void doWormhole(MinecraftServer server, StargateConnection connection, boolean incoming, StargateInfo.WormholeTravel wormholeTravel) {
        ServerLevel level;
        Stargate connectedStargate;
        Stargate stargate = connectedStargate = incoming ? connection.getDialingStargate() : connection.getDialedStargate();
        if (this.timer > 0) {
            --this.timer;
        } else if (0 < this.counter && (level = connectedStargate.getLevel(server)) != null) {
            this.timer = this.nextAttackerInterval();
            --this.counter;
            Entity entity = this.createEntity(level, EntityInit.JAFFA.get());
            if (entity != null) {
                Entity traveler = connectedStargate.receiveTraveler(server, connection, this, entity, new Vec3(0.0, -0.8, this.random.nextDouble(-0.6, 0.6)), new Vec3(-0.4, 0.0, 0.0), new Vec3(-1.0, 0.0, 0.0));
                if (traveler != null) {
                    connection.setTimeSinceLastTraveler(0);
                    connection.setUsed(true);
                    this.spawnEntity(level, traveler);
                } else {
                    entity.discard();
                }
            }
        }
    }

    @Override
    @Nullable
    public Entity receiveTraveler(MinecraftServer server, StargateConnection connection, Stargate initialStargate, Entity traveler, Vec3 relativePosition, Vec3 relativeMomentum, Vec3 relativeLookAngle) {
        if (traveler instanceof Player) {
            Player player = (Player)traveler;
            player.displayClientMessage((Component)Component.translatable((String)"no"), true);
        }
        return null;
    }

    @Override
    public boolean shouldAutoclose(MinecraftServer server, StargateConnection connection) {
        return connection.getOpenTime() > 200;
    }

    @Override
    public CompoundTag serializeNBT() {
        return null;
    }

    @Override
    public void deserializeNBT(MinecraftServer server, Address.Immutable address, CompoundTag tag) {
    }

    public static interface SpawnerConsumer {
        public Entity onEntitySpawn(Entity var1);
    }
}

