/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney.transporter;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.common.block_entities.transporter.AbstractTransporterEntity;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.sgjourney.TransporterConnection;
import net.povstalec.sgjourney.common.sgjourney.Transporting;
import net.povstalec.sgjourney.common.sgjourney.transporter.Transporter;

public class SGJourneyTransporter
implements Transporter {
    public static final Vec3 FORWARD = new Vec3(1.0, 0.0, 0.0);
    public static final Vec3 UP = new Vec3(0.0, 1.0, 0.0);
    public static final Vec3 RIGHT = new Vec3(0.0, 0.0, 1.0);
    public static final double INNER_RADIUS = 2.0;
    private UUID id;
    private ResourceKey<Level> dimension;
    private BlockPos blockPos;
    @Nullable
    private Component name;

    public SGJourneyTransporter() {
    }

    public SGJourneyTransporter(UUID id, ResourceKey<Level> dimension, BlockPos blockPos, Component name) {
        this.id = id;
        this.dimension = dimension;
        this.blockPos = blockPos;
        this.name = name;
    }

    public SGJourneyTransporter(AbstractTransporterEntity transporterEntity) {
        this(transporterEntity.getID(), (ResourceKey<Level>)transporterEntity.getLevel().dimension(), transporterEntity.getBlockPos(), transporterEntity.getCustomName());
    }

    @Override
    public UUID getID() {
        return this.id;
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    @Override
    @Nullable
    public Vec3 getPosition(MinecraftServer server) {
        return this.getBlockPos().getCenter();
    }

    @Override
    @Nullable
    public Vec3 getForward(MinecraftServer server) {
        return FORWARD;
    }

    @Override
    @Nullable
    public Vec3 getUp(MinecraftServer server) {
        return UP;
    }

    @Override
    @Nullable
    public Vec3 getRight(MinecraftServer server) {
        return RIGHT;
    }

    @Override
    public double getInnerRadius() {
        return 2.0;
    }

    @Override
    @Nullable
    public Vec3 transportPos(MinecraftServer server) {
        AbstractTransporterEntity transporter = this.getTransporterEntity(server);
        if (transporter != null) {
            return transporter.transportPos().getCenter();
        }
        return null;
    }

    @Override
    public Component getName() {
        return this.name != null ? this.name : Component.empty();
    }

    @Nullable
    public AbstractTransporterEntity getTransporterEntity(MinecraftServer server) {
        BlockEntity blockEntity;
        ServerLevel level = server.getLevel(this.dimension);
        if (level != null && (blockEntity = level.getBlockEntity(this.blockPos)) instanceof AbstractTransporterEntity) {
            AbstractTransporterEntity transporter = (AbstractTransporterEntity)blockEntity;
            return transporter;
        }
        return null;
    }

    @Override
    public int getTimeOffset(MinecraftServer server) {
        AbstractTransporterEntity transporter = this.getTransporterEntity(server);
        if (transporter != null) {
            return transporter.getTimeOffset();
        }
        return 0;
    }

    @Override
    public List<Entity> entitiesToTransport(MinecraftServer server) {
        AbstractTransporterEntity transporter = this.getTransporterEntity(server);
        if (transporter != null) {
            return transporter.entitiesToTransport();
        }
        return ImmutableList.of();
    }

    @Override
    public void transportTravelers(MinecraftServer server, TransporterConnection connection, Transporter receivingTransporter, List<Entity> travelers) {
        this.transporterRun(server, transporter -> Transporting.transportTravelers(server, connection, this, receivingTransporter, travelers));
    }

    @Override
    public boolean receiveTraveler(MinecraftServer server, TransporterConnection connection, Transporter sendingTransporter, Entity traveler, Vec3 relativePosition, Vec3 relativeMomentum, Vec3 relativeLookAngle) {
        Vec3 destinationPosition = this.fromTransporterCoords(server, relativePosition, true).add(this.transportPos(server));
        Vec3 destinationMomentum = this.fromTransporterCoords(server, relativeMomentum, false);
        Vec3 destinationLookAngle = this.fromTransporterCoords(server, relativeLookAngle, false);
        return Transporting.receiveTraveler(this.getLevel(server), this, traveler, destinationPosition, destinationMomentum, destinationLookAngle);
    }

    @Override
    public void connect(MinecraftServer server, UUID connectionID) {
        AbstractTransporterEntity transporter = this.getTransporterEntity(server);
        if (transporter != null) {
            transporter.connectTransporter(connectionID);
        }
    }

    @Override
    public void disconnect(MinecraftServer server) {
        AbstractTransporterEntity transporter = this.getTransporterEntity(server);
        if (transporter != null) {
            transporter.disconnectTransporter();
        }
    }

    @Override
    public void reset(MinecraftServer server) {
        AbstractTransporterEntity transporter = this.getTransporterEntity(server);
        if (transporter != null) {
            transporter.resetTransporter();
        }
    }

    @Override
    public boolean isConnected(MinecraftServer server) {
        AbstractTransporterEntity transporter = this.getTransporterEntity(server);
        if (transporter != null) {
            return transporter.isConnected();
        }
        return false;
    }

    @Override
    public void updateTicks(MinecraftServer server, int connectionTime) {
        AbstractTransporterEntity transporter = this.getTransporterEntity(server);
        if (transporter != null) {
            transporter.updateTicks(connectionTime);
        }
    }

    public String toString() {
        String nameString = this.name != null ? this.name.getString() : this.id.toString();
        return "[ " + nameString + " | Pos: " + this.blockPos.toString() + " ]";
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag transporterTag = new CompoundTag();
        ResourceKey<Level> level = this.getDimension();
        BlockPos pos = this.getBlockPos();
        transporterTag.putString("Dimension", level.location().toString());
        transporterTag.putIntArray("Coordinates", new int[]{pos.getX(), pos.getY(), pos.getZ()});
        if (this.name != null) {
            transporterTag.putString("CustomName", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)registries));
        }
        return transporterTag;
    }

    @Override
    public void deserializeNBT(MinecraftServer server, UUID uuid, CompoundTag tag, HolderLookup.Provider registries) {
        this.dimension = Conversion.stringToDimension(tag.getString("Dimension"));
        this.blockPos = Conversion.intArrayToBlockPos(tag.getIntArray("Coordinates"));
        if (tag.contains("CustomName", 8)) {
            this.name = Component.Serializer.fromJson((String)tag.getString("CustomName"), (HolderLookup.Provider)registries);
        }
        this.id = uuid;
    }

    private void transporterRun(MinecraftServer server, TransporterConsumer consumer) {
        AbstractTransporterEntity transporter = this.getTransporterEntity(server);
        if (transporter != null) {
            consumer.run(transporter);
        }
    }

    private <T> T transporterReturn(MinecraftServer server, ReturnTransporterConsumer<T> consumer, @Nullable T defaultValue) {
        AbstractTransporterEntity transporter = this.getTransporterEntity(server);
        if (transporter != null) {
            return consumer.run(transporter);
        }
        return defaultValue;
    }

    public static interface TransporterConsumer {
        public void run(AbstractTransporterEntity var1);
    }

    public static interface ReturnTransporterConsumer<T> {
        public T run(AbstractTransporterEntity var1);
    }
}

