/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney.transporter;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.common.misc.CoordinateHelper;
import net.povstalec.sgjourney.common.sgjourney.TransporterConnection;

public interface Transporter {
    public static final String DIMENSION = "Dimension";
    public static final String COORDINATES = "Coordinates";
    public static final String CUSTOM_NAME = "CustomName";

    public UUID getID();

    @Nullable
    public ResourceKey<Level> getDimension();

    @Nullable
    default public ServerLevel getLevel(MinecraftServer server) {
        ResourceKey<Level> dimension = this.getDimension();
        if (dimension == null) {
            return null;
        }
        return server.getLevel(dimension);
    }

    public BlockPos getBlockPos();

    @Nullable
    public Vec3 getPosition(MinecraftServer var1);

    @Nullable
    public Vec3 getForward(MinecraftServer var1);

    @Nullable
    public Vec3 getUp(MinecraftServer var1);

    @Nullable
    public Vec3 getRight(MinecraftServer var1);

    public double getInnerRadius();

    default public Vec3 toTransporterCoords(MinecraftServer server, Vec3 vector, boolean scaleWithTransporter) {
        Vec3 result = CoordinateHelper.Relative.fromOrthogonalBasis(vector, this.getForward(server), this.getUp(server), this.getRight(server));
        if (scaleWithTransporter) {
            return new Vec3(result.x() / this.getInnerRadius(), result.y(), result.z() / this.getInnerRadius());
        }
        return result;
    }

    default public Vec3 fromTransporterCoords(MinecraftServer server, Vec3 vector, boolean scaleWithTransporter) {
        if (scaleWithTransporter) {
            vector = new Vec3(vector.x() * this.getInnerRadius(), vector.y(), vector.z() * this.getInnerRadius());
        }
        return CoordinateHelper.Relative.toOrthogonalBasis(vector, this.getForward(server), this.getUp(server), this.getRight(server));
    }

    @Nullable
    public Vec3 transportPos(MinecraftServer var1);

    @Nullable
    public Component getName();

    public int getTimeOffset(MinecraftServer var1);

    public List<Entity> entitiesToTransport(MinecraftServer var1);

    public void transportTravelers(MinecraftServer var1, TransporterConnection var2, Transporter var3, List<Entity> var4);

    public boolean receiveTraveler(MinecraftServer var1, TransporterConnection var2, Transporter var3, Entity var4, Vec3 var5, Vec3 var6, Vec3 var7);

    public void connect(MinecraftServer var1, UUID var2);

    public void disconnect(MinecraftServer var1);

    public void reset(MinecraftServer var1);

    public boolean isConnected(MinecraftServer var1);

    public void updateTicks(MinecraftServer var1, int var2);

    public CompoundTag serializeNBT(HolderLookup.Provider var1);

    public void deserializeNBT(MinecraftServer var1, UUID var2, CompoundTag var3, HolderLookup.Provider var4);
}

