/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Random;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.povstalec.sgjourney.common.config.CommonGenerationConfig;
import net.povstalec.sgjourney.common.init.StructurePlacementInit;
import org.jetbrains.annotations.Nullable;

public class UniqueStructurePlacement
extends RandomSpreadStructurePlacement {
    public static final int MAX_CHUNKS = 512;
    public static final int BOUND = 64;
    public static final MapCodec<UniqueStructurePlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("salt").forGetter(uniquePlacement -> uniquePlacement.salt()), (App)Codec.intRange((int)-512, (int)512).optionalFieldOf("x_chunk_offset").forGetter(uniquePlacement -> Optional.ofNullable(uniquePlacement.chunkOffsetX)), (App)Codec.intRange((int)-512, (int)512).optionalFieldOf("z_chunk_offset").forGetter(uniquePlacement -> Optional.ofNullable(uniquePlacement.chunkOffsetZ)), (App)Codec.intRange((int)0, (int)64).optionalFieldOf("x_bound").forGetter(uniquePlacement -> Optional.ofNullable(uniquePlacement.chunkBoundX)), (App)Codec.intRange((int)0, (int)64).optionalFieldOf("z_bound").forGetter(uniquePlacement -> Optional.ofNullable(uniquePlacement.chunkBoundZ)), (App)Codec.intRange((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE).optionalFieldOf("x").forGetter(uniquePlacement -> Optional.ofNullable(uniquePlacement.chunkX)), (App)Codec.intRange((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE).optionalFieldOf("z").forGetter(uniquePlacement -> Optional.ofNullable(uniquePlacement.chunkZ))).apply((Applicative)instance, UniqueStructurePlacement::new));
    @Nullable
    protected Integer chunkOffsetX;
    @Nullable
    protected Integer chunkOffsetZ;
    @Nullable
    protected Integer chunkBoundX;
    @Nullable
    protected Integer chunkBoundZ;
    @Nullable
    protected Integer chunkX;
    @Nullable
    protected Integer chunkZ;

    protected UniqueStructurePlacement(int salt, Optional<Integer> chunkX, Optional<Integer> chunkZ, Optional<Integer> chunkOffsetX, Optional<Integer> chunkOffsetZ, Optional<Integer> chunkBoundX, Optional<Integer> chunkBoundZ) {
        super(1, 0, RandomSpreadType.LINEAR, salt);
        this.chunkX = chunkX.orElse(null);
        this.chunkZ = chunkZ.orElse(null);
        this.chunkOffsetX = chunkOffsetX.orElse(null);
        this.chunkOffsetZ = chunkOffsetZ.orElse(null);
        this.chunkBoundX = chunkBoundX.orElse(null);
        this.chunkBoundZ = chunkBoundZ.orElse(null);
    }

    public int getChunkOffsetX() {
        return this.chunkOffsetX == null ? 0 : this.chunkOffsetX;
    }

    public int getChunkOffsetZ() {
        return this.chunkOffsetZ == null ? 0 : this.chunkOffsetZ;
    }

    public int getChunkBoundX() {
        return this.chunkBoundX == null ? 0 : this.chunkBoundX;
    }

    public int getChunkBoundZ() {
        return this.chunkBoundZ == null ? 0 : this.chunkBoundZ;
    }

    public int getChunkX(long levelSeed) {
        if (this.chunkX == null) {
            Random random = new Random(levelSeed + 2L + (long)this.salt());
            int xOffset = this.getChunkOffsetX();
            int xBound = this.getChunkBoundX();
            this.chunkX = xBound <= 0 ? xOffset : xOffset + random.nextInt(-xBound, xBound + 1);
        }
        return this.chunkX;
    }

    public int getChunkZ(long levelSeed) {
        if (this.chunkZ == null) {
            Random random = new Random(levelSeed + 3L + (long)this.salt());
            int zOffset = this.getChunkOffsetZ();
            int zBound = this.getChunkBoundZ();
            this.chunkZ = zBound <= 0 ? zOffset : zOffset + random.nextInt(-zBound, zBound + 1);
        }
        return this.chunkZ;
    }

    public ChunkPos getPotentialStructureChunk(long levelSeed, int chunkX, int chunkZ) {
        return new ChunkPos(this.getChunkX(levelSeed), this.getChunkZ(levelSeed));
    }

    protected boolean isPlacementChunk(ChunkGeneratorStructureState state, int chunkX, int chunkZ) {
        return chunkX == this.getChunkX(state.getLevelSeed()) && chunkZ == this.getChunkZ(state.getLevelSeed());
    }

    public StructurePlacementType<?> type() {
        return (StructurePlacementType)StructurePlacementInit.UNIQUE_PLACEMENT.get();
    }

    public static class BuriedStargate
    extends Stargate {
        public static final MapCodec<BuriedStargate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("salt").forGetter(uniquePlacement -> uniquePlacement.salt())).apply((Applicative)instance, BuriedStargate::new));

        protected BuriedStargate(int salt) {
            super(salt);
        }

        @Override
        public int getChunkBoundX() {
            return (Integer)CommonGenerationConfig.buried_stargate_generation_x_bound.get();
        }

        @Override
        public int getChunkBoundZ() {
            return (Integer)CommonGenerationConfig.buried_stargate_generation_z_bound.get();
        }

        @Override
        public StructurePlacementType<?> type() {
            return (StructurePlacementType)StructurePlacementInit.BURIED_STARGATE_PLACEMENT.get();
        }
    }

    public static class Stargate
    extends UniqueStructurePlacement {
        public static final MapCodec<Stargate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("salt").forGetter(uniquePlacement -> uniquePlacement.salt())).apply((Applicative)instance, Stargate::new));

        protected Stargate(int salt) {
            super(salt, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        }

        @Override
        public int getChunkOffsetX() {
            return (Integer)CommonGenerationConfig.stargate_generation_center_x_chunk_offset.get();
        }

        @Override
        public int getChunkOffsetZ() {
            return (Integer)CommonGenerationConfig.stargate_generation_center_z_chunk_offset.get();
        }

        @Override
        public int getChunkBoundX() {
            return (Integer)CommonGenerationConfig.stargate_generation_x_bound.get();
        }

        @Override
        public int getChunkBoundZ() {
            return (Integer)CommonGenerationConfig.stargate_generation_z_bound.get();
        }

        @Override
        public StructurePlacementType<?> type() {
            return (StructurePlacementType)StructurePlacementInit.STARGATE_PLACEMENT.get();
        }
    }
}

