/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.menu;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.SlotItemHandler;
import net.povstalec.sgjourney.common.block_entities.transporter.RingPanelEntity;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.MenuInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.menu.InventoryMenu;
import net.povstalec.sgjourney.common.packets.ServerboundRingPanelUpdatePacket;

public class RingPanelMenu
extends InventoryMenu {
    private final RingPanelEntity blockEntity;
    private final Level level;

    public RingPanelMenu(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerId, inventory, inventory.f_35978_.f_19853_.m_7702_(extraData.m_130135_()));
    }

    public RingPanelMenu(int containerId, Inventory inventory, BlockEntity entity) {
        super((MenuType)MenuInit.RING_PANEL.get(), containerId);
        RingPanelMenu.m_38869_((Container)inventory, (int)6);
        this.blockEntity = (RingPanelEntity)entity;
        this.level = inventory.f_35978_.f_19853_;
        this.addPlayerInventory(inventory, 8, 140);
        this.addPlayerHotbar(inventory, 8, 198);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler(handler, 0, 5, 36));
            this.m_38897_((Slot)new SlotItemHandler(handler, 1, 23, 36));
            this.m_38897_((Slot)new SlotItemHandler(handler, 2, 5, 54));
            this.m_38897_((Slot)new SlotItemHandler(handler, 3, 23, 54));
            this.m_38897_((Slot)new SlotItemHandler(handler, 4, 5, 72));
            this.m_38897_((Slot)new SlotItemHandler(handler, 5, 23, 72));
        });
    }

    public Component getRingsPos(int i) {
        if (i < this.blockEntity.ringsPos.size()) {
            BlockPos coords = this.blockEntity.ringsPos.get(i);
            Component name = this.blockEntity.ringsName.get(i);
            if (name.getString().length() == 0) {
                return Component.m_237113_((String)("[" + coords.m_123341_() + " " + coords.m_123342_() + " " + coords.m_123343_() + "]")).m_130940_(ChatFormatting.DARK_GREEN);
            }
            return Component.m_237119_().m_7220_(name).m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)(" [" + coords.m_123341_() + " " + coords.m_123342_() + " " + coords.m_123343_() + "] ")).m_130940_(ChatFormatting.DARK_GREEN));
        }
        return Component.m_237113_((String)"-");
    }

    public void activateRings(int number) {
        PacketHandlerInit.INSTANCE.sendToServer((Object)new ServerboundRingPanelUpdatePacket(this.blockEntity.m_58899_(), number));
    }

    public int[] getTargetCoords(int chosenNumber) {
        return this.blockEntity.getTargetCoords(chosenNumber);
    }

    public boolean m_6875_(Player player) {
        return RingPanelMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)BlockInit.RING_PANEL.get()));
    }

    @Override
    protected int blockEntitySlotCount() {
        return 6;
    }
}

