/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney.info;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.shielding.AbstractShieldingBlock;
import net.povstalec.sgjourney.common.blockstates.ShieldingState;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.items.StargateIrisItem;
import net.povstalec.sgjourney.common.packets.ClientBoundSoundPackets;

public class IrisInfo {
    protected AbstractStargateEntity stargate;
    protected short irisProgress;
    protected short oldIrisProgress;
    protected final ItemStackHandler irisItemHandler;

    public IrisInfo(AbstractStargateEntity stargate) {
        this.stargate = stargate;
        this.irisProgress = 0;
        this.oldIrisProgress = 0;
        this.irisItemHandler = this.createIrisHandler();
    }

    public void decreaseIrisDurability() {
        if (this.irisItemHandler.getStackInSlot(0).m_41619_()) {
            return;
        }
        Block block = this.stargate.m_58900_().m_60734_();
        if (block instanceof AbstractStargateBaseBlock) {
            boolean shouldDestroyIris;
            AbstractStargateBaseBlock stargateBlock = (AbstractStargateBaseBlock)block;
            boolean bl = shouldDestroyIris = !StargateIrisItem.decreaseDurability(this.irisItemHandler.getStackInSlot(0));
            if (shouldDestroyIris) {
                AbstractShieldingBlock.destroyShielding(this.stargate.m_58904_(), this.stargate.m_58899_(), stargateBlock.getShieldingParts(), this.stargate.getDirection(), this.stargate.getOrientation());
            }
        }
    }

    public boolean isIrisClosed() {
        return this.hasIris() && this.irisProgress == 58;
    }

    public int getIrisDurability() {
        return this.hasIris() ? StargateIrisItem.getDurability(this.getIris()) : 0;
    }

    public int getIrisMaxDurability() {
        Item item = this.getIris().m_41720_();
        if (item instanceof StargateIrisItem) {
            StargateIrisItem iris = (StargateIrisItem)item;
            return iris.getMaxDurability();
        }
        return 0;
    }

    public ShieldingState getShieldingState() {
        return ShieldingState.fromProgress(this.irisProgress);
    }

    protected void setIrisState() {
        if (this.irisProgress == ShieldingState.CLOSED.getProgress()) {
            if (this.oldIrisProgress > this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.MOVING_4);
            } else if (this.oldIrisProgress < this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.CLOSED);
            }
            return;
        }
        if (this.irisProgress == ShieldingState.MOVING_4.getProgress()) {
            if (this.oldIrisProgress > this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.MOVING_3);
            } else if (this.oldIrisProgress < this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.MOVING_4);
            }
            return;
        }
        if (this.irisProgress == ShieldingState.MOVING_3.getProgress()) {
            if (this.oldIrisProgress > this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.MOVING_2);
            } else if (this.oldIrisProgress < this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.MOVING_3);
            }
            return;
        }
        if (this.irisProgress == ShieldingState.MOVING_2.getProgress()) {
            if (this.oldIrisProgress > this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.MOVING_1);
            } else if (this.oldIrisProgress < this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.MOVING_2);
            }
            return;
        }
        if (this.irisProgress == ShieldingState.MOVING_1.getProgress()) {
            if (this.oldIrisProgress > this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.OPEN);
            } else if (this.oldIrisProgress < this.irisProgress) {
                this.stargate.setStargateState(true, true, ShieldingState.MOVING_1);
            }
            return;
        }
        if (this.irisProgress == 0 && this.oldIrisProgress > this.irisProgress) {
            this.stargate.setStargateState(true, true, ShieldingState.OPEN);
        }
    }

    public boolean addIris(ItemStack stack) {
        if (this.setIris(stack)) {
            this.irisProgress = (short)58;
            this.oldIrisProgress = (short)58;
            this.stargate.setStargateState(true, true, ShieldingState.CLOSED);
            return true;
        }
        return false;
    }

    public void removeIris() {
        if (this.unsetIris()) {
            ShieldingState shieldingState = ShieldingState.OPEN;
            this.irisProgress = shieldingState.getProgress();
            this.oldIrisProgress = shieldingState.getProgress();
            this.stargate.setStargateState(true, true, ShieldingState.OPEN);
        }
    }

    public short increaseIrisProgress() {
        this.oldIrisProgress = this.irisProgress;
        if (this.hasIris() && this.irisProgress < 58) {
            this.irisProgress = (short)(this.irisProgress + 1);
            this.setIrisState();
        }
        return this.irisProgress;
    }

    public short decreaseIrisProgress() {
        this.oldIrisProgress = this.irisProgress;
        if (this.hasIris() && this.irisProgress > 0) {
            this.irisProgress = (short)(this.irisProgress - 1);
            this.setIrisState();
        }
        return this.irisProgress;
    }

    public float checkIrisState() {
        return (float)this.irisProgress * 100.0f / 58.0f;
    }

    protected ItemStackHandler createIrisHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                IrisInfo.this.stargate.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.m_41720_() instanceof StargateIrisItem;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public void playIrisThudSound() {
        if (!this.stargate.m_58904_().m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.stargate.m_58904_().m_46745_(this.stargate.m_58899_())), (Object)new ClientBoundSoundPackets.IrisThud(this.stargate.m_58899_()));
        }
    }

    public boolean hasIris() {
        return this.irisItemHandler.getStackInSlot(0).m_41720_() instanceof StargateIrisItem;
    }

    public void setIrisProgress(short oldIrisProgress, short irisProgress) {
        this.oldIrisProgress = oldIrisProgress;
        this.irisProgress = irisProgress;
    }

    public void setIrisProgress(short irisProgress) {
        this.setIrisProgress(this.irisProgress, irisProgress);
    }

    public short getIrisProgress() {
        return this.hasIris() ? this.irisProgress : (short)0;
    }

    public float getIrisProgress(float partialTick) {
        return StargateJourneyConfig.disable_smooth_animations.get() ? (float)this.getIrisProgress() : Mth.m_14179_((float)partialTick, (float)this.oldIrisProgress, (float)this.irisProgress);
    }

    public Optional<ResourceLocation> getIrisTexture() {
        if (!this.hasIris()) {
            return Optional.empty();
        }
        return Optional.ofNullable(StargateIrisItem.getIrisTexture(this.irisItemHandler.getStackInSlot(0)));
    }

    public boolean setIris(ItemStack stack) {
        if (this.irisItemHandler.getStackInSlot(0).m_41619_()) {
            this.irisItemHandler.setStackInSlot(0, stack.m_41777_());
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack getIris() {
        return this.irisItemHandler.getStackInSlot(0).m_41777_();
    }

    public boolean unsetIris() {
        if (!this.irisItemHandler.getStackInSlot(0).m_41619_()) {
            this.irisItemHandler.setStackInSlot(0, ItemStack.f_41583_);
            return true;
        }
        return false;
    }

    public CompoundTag serializeIrisInventory() {
        return this.irisItemHandler.serializeNBT();
    }

    public void deserializeIrisInventory(CompoundTag tag) {
        this.irisItemHandler.deserializeNBT(tag);
    }

    public static interface Interface {
        public static final String IRIS_PROGRESS = "IrisProgress";
        public static final String IRIS_INVENTORY = "IrisInventory";

        public IrisInfo irisInfo();
    }
}

