/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.povstalec.sgjourney.client.models.block_entity.AbstractStargateModel;
import net.povstalec.sgjourney.client.models.block_entity.SGJourneyModel;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.ClassicStargateVariant;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.ClassicStargateEntity;
import net.povstalec.sgjourney.common.misc.ColorUtil;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.Symbols;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class ClassicStargateModel
extends AbstractStargateModel<ClassicStargateEntity, ClassicStargateVariant> {
    protected static final int SPINNING_SIDES = 39;
    private static final float ANGLE = 9.230769f;
    protected static final float STARGATE_RING_THICKNESS = 8.0f;
    protected static final float STARGATE_RING_OFFSET = 0.25f;
    protected static final float SPINNY_RING_THICKNESS = 7.0f;
    protected static final float SPINNY_RING_OFFSET = 0.21875f;
    protected static final float SYMBOL_OFFSET = 0.21975f;
    protected static final float LOCKED_CHEVRON_OFFSET = 0.25f;
    protected static final float CHEVRON_LIGHT_THICKNESS = 0.125f;
    protected static final float CHEVRON_LIGHT_UPPER_WIDTH = 0.4375f;
    protected static final float CHEVRON_LIGHT_LOWER_WIDTH = 0.125f;
    protected static final float CHEVRON_LIGHT_HEIGHT = 0.375f;
    protected static final float CHEVRON_LIGHT_Z_OFFSET = 0.375f;
    protected static final float CHEVRON_LIGHT_UPPER_X_OFFSET = 0.21875f;
    protected static final float CHEVRON_LIGHT_LOWER_X_OFFSET = 0.0625f;
    protected static final float CHEVRON_LIGHT_HEIGHT_Y_OFFSET = 0.1875f;
    protected static final float OUTER_CHEVRON_THICKNESS = 0.1875f;
    protected static final float OUTER_CHEVRON_BOTTOM_WIDTH = 0.375f;
    protected static final float OUTER_CHEVRON_BOTTOM_HEIGHT = 0.1875f;
    protected static final float OUTER_CHEVRON_SIDE_HEIGHT = 0.5625f;
    protected static final float SIN_25_5 = (float)Math.sin(Math.toRadians(22.5));
    protected static final float COS_25_5 = (float)Math.cos(Math.toRadians(22.5));
    protected static final float OUTER_CHEVRON_ANGLE = (float)Math.atan(3.0);
    protected static final float OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION = SIN_25_5 * 0.5625f;
    protected static final float OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION = COS_25_5 * 0.5625f;
    protected static final float OUTER_CHEVRON_SIDE_WIDTH = 0.1875f;
    protected static final float OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION = COS_25_5 * 0.1875f;
    protected static final float OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION = SIN_25_5 * 0.1875f;
    protected static final float OUTER_CHEVRON_Z_OFFSET = 0.40625f;
    protected static final float OUTER_CHEVRON_BOTTOM_X_OFFSET = 0.1875f;
    protected static final float OUTER_CHEVRON_BOTTOM_Y_OFFSET = 0.09375f;
    protected static final float STARGATE_RING_OUTER_RADIUS = 3.5f;
    protected static final float STARGATE_RING_OUTER_LENGTH = SGJourneyModel.getUsedWidth(36, 3.5f, 3.5f);
    protected static final float STARGATE_RING_OUTER_CENTER = STARGATE_RING_OUTER_LENGTH / 2.0f;
    protected static final float STARGATE_RING_INNER_RADIUS = 3.0f;
    protected static final float STARGATE_RING_INNER_LENGTH = SGJourneyModel.getUsedWidth(36, 3.0f, 3.5f);
    protected static final float STARGATE_RING_INNER_CENTER = STARGATE_RING_INNER_LENGTH / 2.0f;
    protected static final float STARGATE_RING_HEIGHT = 0.5f;
    protected static final float SPINNY_RING_OUTER_RADIUS = 3.05f;
    protected static final float SPINNY_RING_OUTER_LENGTH = SGJourneyModel.getUsedWidth(39, 3.05f, 3.5f);
    protected static final float SPINNY_RING_OUTER_CENTER = SPINNY_RING_OUTER_LENGTH / 2.0f;
    protected static final float SPINNY_RING_INNER_RADIUS = 2.5f;
    protected static final float SPINNY_RING_INNER_LENGTH = SGJourneyModel.getUsedWidth(39, 2.5f, 3.5f);
    protected static final float SPINNY_RING_INNER_CENTER = SPINNY_RING_INNER_LENGTH / 2.0f;
    protected static final float SPINNY_RING_HEIGHT = 0.54999995f;
    private float rotation = 0.0f;

    public ClassicStargateModel() {
        super((short)39);
    }

    @Override
    public void renderRing(ClassicStargateEntity stargate, ClassicStargateVariant stargateVariant, float partialTick, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        this.renderOuterRing(stack, consumer, source, combinedLight);
        this.renderSpinnyRing(stargate, stargateVariant, stack, consumer, source, combinedLight);
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    protected void renderOuterRing(PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight) {
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        for (int j = 0; j < 36; ++j) {
            stack.m_252781_(Axis.f_252403_.m_252977_(10.0f));
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -STARGATE_RING_OUTER_CENTER, 3.5f, 0.25f, (5.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.125f, -STARGATE_RING_INNER_CENTER, 3.0f, 0.25f, (5.0f - STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.25f, STARGATE_RING_INNER_CENTER, 3.0f, 0.25f, (5.0f + STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.25f, STARGATE_RING_OUTER_CENTER, 3.5f, 0.25f, (5.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.125f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, -1.0f, STARGATE_RING_OUTER_CENTER, 3.5f, -0.25f, (15.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.125f, STARGATE_RING_INNER_CENTER, 3.0f, -0.25f, (15.0f - STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.25f, -STARGATE_RING_INNER_CENTER, 3.0f, -0.25f, (15.0f + STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.25f, -STARGATE_RING_OUTER_CENTER, 3.5f, -0.25f, (15.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.125f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 1.0f, 0.0f, -STARGATE_RING_OUTER_CENTER, 3.5f, -0.25f, (5.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.0f, -STARGATE_RING_OUTER_CENTER, 3.5f, 0.25f, (5.0f - STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.125f, STARGATE_RING_OUTER_CENTER, 3.5f, 0.25f, (5.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.125f, STARGATE_RING_OUTER_CENTER, 3.5f, -0.25f, (5.0f + STARGATE_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.0f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, -1.0f, 0.0f, STARGATE_RING_INNER_CENTER, 3.0f, -0.25f, (15.0f - STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.0f, STARGATE_RING_INNER_CENTER, 3.0f, 0.25f, (15.0f - STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.125f, -STARGATE_RING_INNER_CENTER, 3.0f, 0.25f, (15.0f + STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.125f, -STARGATE_RING_INNER_CENTER, 3.0f, -0.25f, (15.0f + STARGATE_RING_INNER_CENTER * 16.0f) / 64.0f, 0.0f);
        }
    }

    protected void renderSpinnyRing(ClassicStargateEntity stargate, ClassicStargateVariant stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight) {
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        for (int j = 0; j < 39; ++j) {
            stack.m_85836_();
            stack.m_252781_(Axis.f_252403_.m_252977_(-9.230769f * (float)j + this.rotation));
            matrix4 = stack.m_85850_().m_252922_();
            matrix3 = stack.m_85850_().m_252943_();
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -SPINNY_RING_OUTER_CENTER, 3.05f, 0.21875f, (24.5f - SPINNY_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.110937506f, -SPINNY_RING_INNER_CENTER, 2.5f, 0.21875f, (24.5f - SPINNY_RING_INNER_CENTER * 16.0f) / 64.0f, 0.2484375f, SPINNY_RING_INNER_CENTER, 2.5f, 0.21875f, (24.5f + SPINNY_RING_INNER_CENTER * 16.0f) / 64.0f, 0.2484375f, SPINNY_RING_OUTER_CENTER, 3.05f, 0.21875f, (24.5f + SPINNY_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.110937506f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, -1.0f, SPINNY_RING_OUTER_CENTER, 3.05f, -0.21875f, (33.5f - SPINNY_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.110937506f, SPINNY_RING_INNER_CENTER, 2.5f, -0.21875f, (33.5f - SPINNY_RING_INNER_CENTER * 16.0f) / 64.0f, 0.2484375f, -SPINNY_RING_INNER_CENTER, 2.5f, -0.21875f, (33.5f + SPINNY_RING_INNER_CENTER * 16.0f) / 64.0f, 0.2484375f, -SPINNY_RING_OUTER_CENTER, 3.05f, -0.21875f, (33.5f + SPINNY_RING_OUTER_CENTER * 16.0f) / 64.0f, 0.110937506f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, -1.0f, 0.0f, -SPINNY_RING_INNER_CENTER, 2.5f, 0.21875f, (23.5f - SPINNY_RING_INNER_CENTER * 16.0f) / 64.0f, 0.0f, -SPINNY_RING_INNER_CENTER, 2.5f, -0.21875f, (23.5f - SPINNY_RING_INNER_CENTER * 16.0f) / 64.0f, 0.109375f, SPINNY_RING_INNER_CENTER, 2.5f, -0.21875f, (23.5f + SPINNY_RING_INNER_CENTER * 16.0f) / 64.0f, 0.109375f, SPINNY_RING_INNER_CENTER, 2.5f, 0.21875f, (23.5f + SPINNY_RING_INNER_CENTER * 16.0f) / 64.0f, 0.0f);
            stack.m_85849_();
        }
        this.renderSymbols(stargate, stargateVariant, stack, consumer, source, combinedLight, this.rotation);
    }

    protected void renderSymbols(ClassicStargateEntity stargate, ClassicStargateVariant stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, float rotation) {
        Symbols symbols;
        PointOfOrigin pointOfOrigin = this.getPointOfOrigin(stargate, stargateVariant);
        if (pointOfOrigin != null) {
            boolean pointOfOriginEngaged = false;
            if (stargateVariant.symbols().engageEncodedSymbols() && (!stargate.isConnected() || stargate.isDialingOut())) {
                pointOfOriginEngaged = stargate.isConnected();
            } else if (stargate.isConnected()) {
                pointOfOriginEngaged = stargateVariant.symbols().engageSymbolsOnIncoming();
            }
            consumer = source.m_6299_(SGJourneyRenderTypes.stargateRing(this.getPointOfOriginTexture(pointOfOrigin)));
            this.renderSymbol(stargate, stargateVariant, stack, consumer, source, this.symbolsGlow(stargate, stargateVariant, pointOfOriginEngaged) ? 0xF000F0 : combinedLight, 0, 0.5f, 1, rotation, this.getSymbolColor(stargate, stargateVariant, pointOfOriginEngaged));
        }
        if ((symbols = this.getSymbols(stargate, stargateVariant)) == null) {
            return;
        }
        consumer = source.m_6299_(SGJourneyRenderTypes.stargateRing(this.getSymbolTexture(symbols)));
        for (int j = 1; j < this.numberOfSymbols; ++j) {
            boolean symbolEngaged = false;
            if (stargateVariant.symbols().engageEncodedSymbols() && (!stargate.isConnected() || stargate.isDialingOut())) {
                for (int i = 0; i < stargate.getAddress().regularSymbolCount(); ++i) {
                    int addressSymbol = stargate.getAddress().getArray()[i];
                    if (addressSymbol != j) continue;
                    symbolEngaged = true;
                }
            } else if (stargate.isConnected()) {
                symbolEngaged = stargateVariant.symbols().engageSymbolsOnIncoming();
            }
            this.renderSymbol(stargate, stargateVariant, stack, consumer, source, this.symbolsGlow(stargate, stargateVariant, symbolEngaged) ? 0xF000F0 : combinedLight, j, symbols.getTextureOffset(j), symbols.getSize(), rotation, this.getSymbolColor(stargate, stargateVariant, symbolEngaged));
        }
    }

    protected void renderSymbol(ClassicStargateEntity stargate, ClassicStargateVariant stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, int symbolNumber, float symbolOffset, int textureXSize, float rotation, ColorUtil.RGBA symbolColor) {
        if (symbolNumber >= this.numberOfSymbols) {
            return;
        }
        stack.m_85836_();
        stack.m_252781_(Axis.f_252403_.m_252977_((float)symbolNumber * -9.230769f + rotation));
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, symbolColor.red(), symbolColor.green(), symbolColor.blue(), symbolColor.alpha(), -SPINNY_RING_OUTER_CENTER, 3.03125f, 0.21975f, symbolOffset - SPINNY_RING_OUTER_CENTER * 32.0f / 16.0f / (float)textureXSize, 0.0f, -SPINNY_RING_INNER_CENTER, 2.53125f, 0.21975f, symbolOffset - SPINNY_RING_INNER_CENTER * 32.0f / 16.0f / (float)textureXSize, 1.0f, SPINNY_RING_INNER_CENTER, 2.53125f, 0.21975f, symbolOffset + SPINNY_RING_INNER_CENTER * 32.0f / 16.0f / (float)textureXSize, 1.0f, SPINNY_RING_OUTER_CENTER, 3.03125f, 0.21975f, symbolOffset + SPINNY_RING_OUTER_CENTER * 32.0f / 16.0f / (float)textureXSize, 0.0f);
        stack.m_85849_();
    }

    @Override
    protected boolean isPrimaryChevronLowered(ClassicStargateEntity stargate, ClassicStargateVariant stargateVariant) {
        return this.isPrimaryChevronEngaged(stargate, stargateVariant);
    }

    @Override
    protected boolean isChevronLowered(ClassicStargateEntity stargate, ClassicStargateVariant stargateVariant, int chevronNumber) {
        return this.isChevronEngaged(stargate, stargateVariant, chevronNumber);
    }

    @Override
    protected void renderPrimaryChevron(ClassicStargateEntity stargate, ClassicStargateVariant stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, boolean chevronEngaged) {
        int light = chevronEngaged ? 0xF000F0 : combinedLight;
        float subtracted = this.isPrimaryChevronLowered(stargate, stargateVariant) ? 0.3125f : 0.0625f;
        stack.m_85836_();
        stack.m_252880_(0.0f, 3.5f - subtracted, 0.0f);
        this.renderChevronLight(stack, consumer, source, light, chevronEngaged);
        this.renderOuterChevron(stack, consumer, source, light, chevronEngaged);
        stack.m_85849_();
    }

    @Override
    protected void renderChevron(ClassicStargateEntity stargate, ClassicStargateVariant stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, int chevronNumber, boolean chevronEngaged) {
        int chevron = AbstractStargateEntity.getChevron(stargate, chevronNumber);
        int light = chevronEngaged ? 0xF000F0 : combinedLight;
        float subtracted = this.isChevronLowered(stargate, stargateVariant, chevronNumber) ? 0.3125f : 0.0625f;
        stack.m_85836_();
        stack.m_252781_(Axis.f_252403_.m_252977_(-40.0f * (float)chevron));
        stack.m_252880_(0.0f, 3.5f - subtracted, 0.0f);
        this.renderChevronLight(stack, consumer, source, light, chevronEngaged);
        this.renderOuterChevron(stack, consumer, source, light, chevronEngaged);
        stack.m_85849_();
    }

    protected void renderChevronLight(PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, boolean isLocked) {
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -0.21875f, 0.1875f, 0.375f, 0.5f, 0.328125f, -0.0625f, -0.1875f, 0.375f, 0.53125f, 0.40625f, 0.0625f, -0.1875f, 0.375f, 0.5625f, 0.40625f, 0.21875f, 0.1875f, 0.375f, 0.59375f, 0.328125f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 1.0f, 0.0f, -0.21875f, 0.1875f, 0.25f, 0.5f, 0.296875f, -0.21875f, 0.1875f, 0.375f, 0.5f, 0.328125f, 0.21875f, 0.1875f, 0.375f, 0.59375f, 0.328125f, 0.21875f, 0.1875f, 0.25f, 0.59375f, 0.296875f);
        if (!isLocked) {
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, -1.0f, 0.21875f, 0.1875f, 0.25f, 0.59375f, 0.296875f, 0.21875f, 0.0f, 0.25f, 0.59375f, 0.25f, -0.21875f, 0.0f, 0.25f, 0.5f, 0.25f, -0.21875f, 0.1875f, 0.25f, 0.5f, 0.296875f);
        }
    }

    protected void renderOuterChevron(PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, boolean isLocked) {
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 1.0f, 0.0f, -0.0625f, -0.1875f, 0.40625f, 0.203125f, 0.2578125f, 0.0625f, -0.1875f, 0.40625f, 0.203125f, 0.265625f, 0.0625f, -0.1875f, 0.375f, 0.234375f, 0.265625f, -0.0625f, -0.1875f, 0.375f, 0.234375f, 0.2578125f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -0.0625f, -0.1875f, 0.40625f, 0.203125f, 0.265625f, -0.1875f, -0.375f, 0.40625f, 0.1875f, 0.3125f, 0.1875f, -0.375f, 0.40625f, 0.25f, 0.3125f, 0.0625f, -0.1875f, 0.40625f, 0.234375f, 0.265625f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, -1.0f, 0.0f, -0.1875f, -0.375f, 0.40625f, 0.1875f, 0.3125f, -0.1875f, -0.375f, 0.21875f, 0.1875f, 0.359375f, 0.1875f, -0.375f, 0.21875f, 0.25f, 0.359375f, 0.1875f, -0.375f, 0.40625f, 0.25f, 0.3125f);
        this.renderLeftChevronSide(stack, source, consumer, matrix3.rotate((Quaternionfc)Axis.f_252403_.m_252977_(22.5f)), matrix4, combinedLight, isLocked);
        this.renderRightChevronSide(stack, source, consumer, matrix3.rotate((Quaternionfc)Axis.f_252403_.m_252977_(-22.5f)), matrix4, combinedLight, isLocked);
    }

    protected void renderLeftChevronSide(PoseStack stack, MultiBufferSource source, VertexConsumer consumer, Matrix3f matrix3, Matrix4f matrix4, int combinedLight, boolean isLocked) {
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.40625f, 0.046875f, 0.296875f, -0.1875f, -0.375f, 0.40625f, 0.046875f, 0.4375f, -0.0625f, -0.1875f, 0.40625f, 0.09375f, 0.40625f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.40625f, 0.09375f, 0.296875f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, -1.0f, 0.0f, 0.0f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.21875f, 0.0f, 0.296875f, -0.1875f, -0.375f, 0.21875f, 0.0f, 0.4375f, -0.1875f, -0.375f, 0.40625f, 0.046875f, 0.4375f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.40625f, 0.046875f, 0.296875f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 1.0f, 0.0f, 0.0f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.40625f, 0.09375f, 0.296875f, -0.0625f, -0.1875f, 0.40625f, 0.09375f, 0.40625f, -0.0625f, -0.1875f, 0.21875f, 0.140625f, 0.40625f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.21875f, 0.140625f, 0.296875f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 1.0f, 0.0f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.21875f, 0.046875f, 0.25f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.40625f, 0.046875f, 0.296875f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.40625f, 0.09375f, 0.296875f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.21875f, 0.09375f, 0.25f);
        if (!isLocked) {
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, -1.0f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.21875f, 0.140625f, 0.296875f, -0.0625f, -0.1875f, 0.21875f, 0.140625f, 0.40625f, -0.1875f, -0.375f, 0.21875f, 0.1875f, 0.4375f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.21875f, 0.1875f, 0.296875f);
        }
    }

    protected void renderRightChevronSide(PoseStack stack, MultiBufferSource source, VertexConsumer consumer, Matrix3f matrix3, Matrix4f matrix4, int combinedLight, boolean isLocked) {
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION - OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.40625f, 0.296875f, 0.296875f, 0.0625f, -0.1875f, 0.40625f, 0.296875f, 0.40625f, 0.1875f, -0.375f, 0.40625f, 0.34375f, 0.4375f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.40625f, 0.34375f, 0.296875f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 1.0f, 0.0f, 0.0f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.40625f, 0.34375f, 0.296875f, 0.1875f, -0.375f, 0.40625f, 0.34375f, 0.4375f, 0.1875f, -0.375f, 0.21875f, 0.390625f, 0.4375f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.21875f, 0.390625f, 0.296875f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, -1.0f, 0.0f, 0.0f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION - OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.21875f, 0.25f, 0.296875f, 0.0625f, -0.1875f, 0.21875f, 0.25f, 0.40625f, 0.0625f, -0.1875f, 0.40625f, 0.296875f, 0.40625f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION - OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.40625f, 0.296875f, 0.296875f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 1.0f, 0.0f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION - OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.21875f, 0.296875f, 0.25f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION - OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.40625f, 0.296875f, 0.296875f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.40625f, 0.34375f, 0.296875f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.21875f, 0.34375f, 0.25f);
        if (!isLocked) {
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, -1.0f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.21875f, 0.390625f, 0.296875f, 0.1875f, -0.375f, 0.21875f, 0.390625f, 0.4375f, 0.0625f, -0.1875f, 0.21875f, 0.4375f, 0.40625f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION - OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.21875f, 0.4375f, 0.296875f);
        }
    }
}

