/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class CommonTechConfig {
    public static ForgeConfigSpec.BooleanValue fusion_core_infinite_energy;
    public static ForgeConfigSpec.LongValue fusion_core_energy_from_fuel;
    public static ForgeConfigSpec.IntValue fusion_core_fuel_capacity;
    public static ForgeConfigSpec.BooleanValue disable_kara_kesh_requirements;
    public static ForgeConfigSpec.IntValue personal_shield_capacity;
    public static ForgeConfigSpec.IntValue vial_capacity;
    public static ForgeConfigSpec.LongValue energy_from_liquid_naquadah;
    public static ForgeConfigSpec.LongValue energy_from_heavy_liquid_naquadah;
    public static ForgeConfigSpec.LongValue naquadah_power_cell_buffer_capacity;
    public static ForgeConfigSpec.LongValue naquadah_power_cell_max_transfer;
    public static ForgeConfigSpec.LongValue small_naquadah_battery_capacity;
    public static ForgeConfigSpec.LongValue small_naquadah_battery_max_transfer;
    public static ForgeConfigSpec.LongValue large_naquadah_battery_capacity;
    public static ForgeConfigSpec.LongValue large_naquadah_battery_max_transfer;

    public static void init(ForgeConfigSpec.Builder server) {
        fusion_core_infinite_energy = server.comment("If true, Fusion Core will produce an endless amount of energy and won't require any fuel").define("server.fusion_core_infinite_energy", false);
        fusion_core_energy_from_fuel = server.comment("The amount of energy generated by Fusion Core from one unit of fuel").defineInRange("server.fusion_core_energy_from_fuel", 100000L, 1L, Long.MAX_VALUE);
        fusion_core_fuel_capacity = server.comment("The fuel capacity of a Fusion Core").defineInRange("server.fusion_core_fuel_capacity", 65536, 1, Integer.MAX_VALUE);
        disable_kara_kesh_requirements = server.comment("If true Kara Kesh won't require its user to have Naquadah in their bloodstream").define("server.disable_kara_kesh_requirements", false);
        personal_shield_capacity = server.comment("The amount of Heavy Liquid Naquadah a Personal Shield can hold").defineInRange("server.personal_shield_capacity", 300, 1, Integer.MAX_VALUE);
        vial_capacity = server.comment("The amount of Liquid Naquadah or Heavy Liquid Naquadah a Vial can hold").defineInRange("server.vial_capacity", 250, 1, Integer.MAX_VALUE);
        energy_from_liquid_naquadah = server.comment("The amount of energy generated from one unit of Liquid Naquadah").defineInRange("server.energy_from_liquid_naquadah", 10000L, 1L, Long.MAX_VALUE);
        energy_from_heavy_liquid_naquadah = server.comment("The amount of energy generated from one unit of Heavy Liquid Naquadah").defineInRange("server.energy_from_heavy_liquid_naquadah", 50000L, 1L, Long.MAX_VALUE);
        naquadah_power_cell_buffer_capacity = server.comment("The amount of energy the Naquadah Power Cell's Energy Buffer can hold").defineInRange("server.naquadah_power_cell_buffer_capacity", 50000L, 1L, Long.MAX_VALUE);
        naquadah_power_cell_max_transfer = server.comment("The amount of energy the Naquadah Power Cell's Energy Buffer can transfer out at once").defineInRange("server.naquadah_power_cell_max_transfer", 200000L, 1L, Long.MAX_VALUE);
        small_naquadah_battery_capacity = server.comment("The amount of energy an Energy Crystal can hold").defineInRange("server.small_naquadah_battery_capacity", 5000000L, 1L, Long.MAX_VALUE);
        small_naquadah_battery_max_transfer = server.comment("The amount of energy an Advanced Energy Crystal can hold").defineInRange("server.small_naquadah_battery_max_transfer", 10000L, 1L, Long.MAX_VALUE);
        large_naquadah_battery_capacity = server.comment("The amount of energy an Energy Crystal can hold").defineInRange("server.large_naquadah_battery_capacity", 1000000000L, 1L, Long.MAX_VALUE);
        large_naquadah_battery_max_transfer = server.comment("The amount of energy an Advanced Energy Crystal can hold").defineInRange("server.large_naquadah_battery_max_transfer", 100000L, 1L, Long.MAX_VALUE);
    }
}

