/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.povstalec.sgjourney.common.init.TagInit;

public class PlasmaProjectile
extends Projectile {
    private float explosionPower = 0.0f;

    public PlasmaProjectile(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
    }

    public PlasmaProjectile(EntityType<? extends Projectile> type, LivingEntity shooter, Level level, float explosionPower) {
        super(type, level);
        this.explosionPower = explosionPower;
        this.m_6034_(shooter.m_20185_(), shooter.m_20188_() - (double)0.1f, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (!this.f_19853_.m_5776_()) {
            boolean canDestroy = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this.m_37282_());
            this.f_19853_.m_255391_(this.m_37282_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explosionPower, canDestroy, canDestroy ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE);
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        if (!this.f_19853_.m_5776_()) {
            Entity entity = hitResult.m_82443_();
            Entity attacker = this.m_37282_();
            entity.m_6469_(DamageSource.m_252735_((Entity)entity, (Entity)attacker), 14.0f);
            if (attacker instanceof LivingEntity) {
                this.m_19970_((LivingEntity)attacker, entity);
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        BlockPos blockpos;
        Entity entity;
        super.m_8060_(result);
        if (!this.f_19853_.m_5776_() && (!((entity = this.m_37282_()) instanceof Mob) || ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)entity)) && this.f_19853_.m_46859_(blockpos = result.m_82425_().m_121945_(result.m_82434_()))) {
            for (Direction direction : Direction.values()) {
                this.trySetFireToBlock(blockpos, blockpos.m_121945_(direction), direction);
            }
        }
    }

    private boolean trySetFireToBlock(BlockPos blockpos, BlockPos nearbyPos, Direction direction) {
        if (this.f_19853_.m_8055_(nearbyPos).m_204336_(TagInit.Blocks.PLASMA_FLAMMABLE) && !ForgeEventFactory.onBlockPlace((Entity)this.m_37282_(), (BlockSnapshot)BlockSnapshot.create((ResourceKey)this.f_19853_.m_46472_(), (LevelAccessor)this.f_19853_, (BlockPos)blockpos), (Direction)direction)) {
            this.f_19853_.m_46597_(blockpos, BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)blockpos));
            return true;
        }
        return false;
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        float f;
        super.m_8119_();
        HitResult hitresult = ProjectileUtil.m_37294_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        boolean flag = false;
        if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockpos = ((BlockHitResult)hitresult).m_82425_();
            BlockState blockstate = this.f_19853_.m_8055_(blockpos);
            if (blockstate.m_60713_(Blocks.f_50142_)) {
                this.m_20221_(blockpos);
                flag = true;
            } else if (blockstate.m_60713_(Blocks.f_50446_)) {
                BlockEntity blockentity = this.f_19853_.m_7702_(blockpos);
                if (blockentity instanceof TheEndGatewayBlockEntity && TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                    TheEndGatewayBlockEntity.m_155828_((Level)this.f_19853_, (BlockPos)blockpos, (BlockState)blockstate, (Entity)this, (TheEndGatewayBlockEntity)((TheEndGatewayBlockEntity)blockentity));
                }
                flag = true;
            }
        }
        if (hitresult.m_6662_() != HitResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
        this.m_20101_();
        Vec3 vec3 = this.m_20184_();
        double d2 = this.m_20185_() + vec3.f_82479_;
        double d0 = this.m_20186_() + vec3.f_82480_;
        double d1 = this.m_20189_() + vec3.f_82481_;
        this.m_37283_();
        if (this.m_20069_()) {
            for (int i = 0; i < 4; ++i) {
                float f1 = 0.25f;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, d2 - vec3.f_82479_ * 0.25, d0 - vec3.f_82480_ * 0.25, d1 - vec3.f_82481_ * 0.25, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
            f = 0.8f;
        } else {
            f = 0.99f;
        }
        this.m_20256_(vec3.m_82490_((double)f));
        if (!this.m_20068_()) {
            Vec3 vec31 = this.m_20184_();
            this.m_20334_(vec31.f_82479_, vec31.f_82480_ - (double)this.getGravity(), vec31.f_82481_);
        }
        this.m_6034_(d2, d0, d1);
    }

    protected float getGravity() {
        return 0.03f;
    }
}

