/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.povstalec.sgjourney.common.block_entities.CartoucheEntity;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.blockstates.Orientation;

public class CartoucheBlockItem
extends BlockItem {
    public CartoucheBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    protected boolean m_40610_(BlockPlaceContext context, BlockState state) {
        BlockPos blockpos = context.m_8083_();
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        CollisionContext collisioncontext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        Orientation orientation = Orientation.getOrientationFromXRot(context.m_43723_());
        Direction direction = context.m_8125_().m_122424_();
        int maxBuildHeight = level.m_151558_();
        if (orientation != Orientation.REGULAR) {
            --maxBuildHeight;
        }
        if (blockpos.m_123342_() > maxBuildHeight || !level.m_8055_(blockpos.m_121945_(Orientation.getMultiDirection(direction, Direction.UP, orientation))).m_60629_(context)) {
            player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.cartouche.not_enough_space"), true);
            return false;
        }
        return (!this.m_6652_() || state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) && context.m_43725_().m_45752_(state, context.m_8083_(), collisioncontext);
    }

    protected boolean m_7274_(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        return CartoucheBlockItem.updateCustomBlockEntityTag(level, player, pos, stack);
    }

    public static boolean updateCustomBlockEntityTag(Level level, @Nullable Player player, BlockPos pos, ItemStack stack) {
        MinecraftServer minecraftserver = level.m_7654_();
        if (minecraftserver == null) {
            return false;
        }
        CompoundTag compoundtag = CartoucheBlockItem.m_186336_((ItemStack)stack);
        if (compoundtag != null) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity != null) {
                if (!(level.f_46443_ || !blockentity.m_6326_() || player != null && player.m_36337_())) {
                    return false;
                }
                CompoundTag compoundtag1 = blockentity.m_187482_();
                CompoundTag compoundtag2 = compoundtag1.m_6426_();
                compoundtag1.m_128391_(compoundtag);
                if (!compoundtag1.equals((Object)compoundtag2)) {
                    blockentity.m_142466_(compoundtag1);
                    blockentity.m_6596_();
                    return CartoucheBlockItem.setupBlockEntity(level, blockentity, compoundtag);
                }
            }
        } else {
            return CartoucheBlockItem.setupBlockEntity(level, level.m_7702_(pos), new CompoundTag());
        }
        return false;
    }

    private static boolean setupBlockEntity(Level level, BlockEntity baseEntity, CompoundTag info) {
        if (baseEntity instanceof CartoucheEntity) {
            CartoucheEntity cartouche = (CartoucheEntity)baseEntity;
            StructureGenEntity.Step generationStep = info.m_128425_("generation_step", 1) ? StructureGenEntity.Step.fromByte(info.m_128445_("generation_step")) : StructureGenEntity.Step.GENERATED;
            if (generationStep == StructureGenEntity.Step.GENERATED) {
                if (info.m_128425_("Dimension", 8) && !info.m_128441_("Address")) {
                    cartouche.setDimension(ResourceLocation.m_135820_((String)info.m_128461_("Dimension")));
                } else {
                    cartouche.setDimensionFromLevel(level);
                }
                cartouche.generateAddress();
                if (info.m_128425_("Symbols", 8)) {
                    cartouche.setSymbols(ResourceLocation.m_135820_((String)info.m_128461_("Symbols")));
                } else {
                    cartouche.setSymbolsFromLevel(level);
                }
            }
            return true;
        }
        return false;
    }
}

