/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.packets;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import net.povstalec.sgjourney.common.block_entities.tech_interface.AbstractInterfaceEntity;
import net.povstalec.sgjourney.common.blocks.tech_interface.AbstractInterfaceBlock;
import net.povstalec.sgjourney.common.blockstates.InterfaceMode;

public class ServerboundInterfaceUpdatePacket {
    public final BlockPos pos;
    public final long energyTarget;
    public final InterfaceMode mode;

    public ServerboundInterfaceUpdatePacket(BlockPos pos, long energyTarget, InterfaceMode mode) {
        this.pos = pos;
        this.energyTarget = energyTarget;
        this.mode = mode;
    }

    public ServerboundInterfaceUpdatePacket(FriendlyByteBuf buffer) {
        this(buffer.m_130135_(), buffer.readLong(), (InterfaceMode)buffer.m_130066_(InterfaceMode.class));
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeLong(this.energyTarget);
        buffer.m_130068_((Enum)this.mode);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level level = ((NetworkEvent.Context)ctx.get()).getSender().f_19853_;
            BlockEntity blockEntity = level.m_7702_(this.pos);
            if (blockEntity instanceof AbstractInterfaceEntity) {
                AbstractInterfaceEntity interfaceEntity = (AbstractInterfaceEntity)blockEntity;
                interfaceEntity.setEnergyTarget(this.energyTarget);
            }
            BlockState state = level.m_8055_(this.pos);
            Block patt1764$temp = level.m_8055_(this.pos).m_60734_();
            if (patt1764$temp instanceof AbstractInterfaceBlock) {
                AbstractInterfaceBlock interfaceBlock = (AbstractInterfaceBlock)patt1764$temp;
                interfaceBlock.setMode(state, level, this.pos, this.mode);
            }
        });
        return true;
    }
}

