/*
 * Decompiled with CFR 0.152.
 */
package com.sanyaclaus.addon.flowerfield.spells;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

@AutoSpellConfig
public class FlowerFieldSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("flowerfield", "flower_field");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(SchoolRegistry.NATURE_RESOURCE).setMaxLevel(5).setCooldownSeconds(5.0).build();
    private static final List<BlockState> FLOWERS = List.of(Blocks.f_50111_.m_49966_(), Blocks.f_50112_.m_49966_(), Blocks.f_50113_.m_49966_(), Blocks.f_50114_.m_49966_(), Blocks.f_50115_.m_49966_(), Blocks.f_50116_.m_49966_(), Blocks.f_50117_.m_49966_(), Blocks.f_50118_.m_49966_(), Blocks.f_50119_.m_49966_(), Blocks.f_50120_.m_49966_(), Blocks.f_50121_.m_49966_(), Blocks.f_50071_.m_49966_(), Blocks.f_50356_.m_49966_(), Blocks.f_50357_.m_49966_(), Blocks.f_50358_.m_49966_());

    public FlowerFieldSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 4;
        this.spellPowerPerLevel = 2;
        this.castTime = 20;
        this.baseManaCost = 25;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.f_12054_);
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of(SoundEvents.f_12049_);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.createFlowerField(serverLevel, entity, this.getRadius(spellLevel));
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void createFlowerField(ServerLevel level, LivingEntity caster, int radius) {
        BlockPos center = caster.m_20183_();
        int flowersPlaced = 0;
        for (int yOffset = -2; yOffset <= 2; ++yOffset) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos targetPos;
                    if (x * x + z * z > radius * radius || !this.canPlaceFlower((Level)level, targetPos = center.m_7918_(x, yOffset, z))) continue;
                    if (level.f_46441_.m_188501_() < 0.7f) {
                        BlockState flower = this.getRandomFlower(level);
                        level.m_7731_(targetPos, flower, 3);
                        ++flowersPlaced;
                        continue;
                    }
                    if (!this.canPlaceTallGrass((Level)level, targetPos)) continue;
                    level.m_7731_(targetPos, Blocks.f_50359_.m_49966_(), 3);
                }
            }
        }
        level.m_5594_(null, center, SoundEvents.f_11991_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private boolean canPlaceFlower(Level level, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        BlockState belowState = level.m_8055_(below);
        BlockState currentState = level.m_8055_(pos);
        return (belowState.m_60713_(Blocks.f_50440_) || belowState.m_60713_(Blocks.f_50493_) || belowState.m_60713_(Blocks.f_50599_)) && currentState.m_60795_();
    }

    private boolean canPlaceTallGrass(Level level, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        BlockState belowState = level.m_8055_(below);
        BlockState currentState = level.m_8055_(pos);
        return (belowState.m_60713_(Blocks.f_50440_) || belowState.m_60713_(Blocks.f_50493_) || belowState.m_60713_(Blocks.f_50599_)) && currentState.m_60795_();
    }

    private BlockState getRandomFlower(ServerLevel level) {
        return FLOWERS.get(level.f_46441_.m_188503_(FLOWERS.size()));
    }

    private int getRadius(int spellLevel) {
        return 3 + (spellLevel - 1) * 2;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.radius", (Object[])new Object[]{this.getRadius(spellLevel)}));
    }
}

