/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.borninchaosv.block;

import java.util.List;
import net.mcreator.borninchaosv.procedures.GraveDestroyerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TombstoneMikeRoryBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public TombstoneMikeRoryBlock() {
        super(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.TUFF).strength(4.0f, 50.0f).requiresCorrectToolForDrops().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"block.born_in_chaos_v1.tombstone_mike_rory.description_0"));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)TombstoneMikeRoryBlock.box((double)2.0, (double)2.0, (double)4.0, (double)14.0, (double)19.0, (double)10.0), (VoxelShape[])new VoxelShape[]{TombstoneMikeRoryBlock.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0, (double)13.0), TombstoneMikeRoryBlock.box((double)5.5, (double)19.0, (double)6.0, (double)10.5, (double)23.0, (double)11.0), TombstoneMikeRoryBlock.box((double)0.5, (double)19.0, (double)4.0, (double)15.5, (double)20.0, (double)10.0), TombstoneMikeRoryBlock.box((double)12.5, (double)20.0, (double)4.0, (double)15.5, (double)22.0, (double)10.0), TombstoneMikeRoryBlock.box((double)0.5, (double)20.0, (double)4.0, (double)3.5, (double)22.0, (double)10.0), TombstoneMikeRoryBlock.box((double)6.5, (double)18.0, (double)10.0, (double)9.5, (double)19.0, (double)11.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)TombstoneMikeRoryBlock.box((double)2.0, (double)2.0, (double)6.0, (double)14.0, (double)19.0, (double)12.0), (VoxelShape[])new VoxelShape[]{TombstoneMikeRoryBlock.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)2.0, (double)14.0), TombstoneMikeRoryBlock.box((double)5.5, (double)19.0, (double)5.0, (double)10.5, (double)23.0, (double)10.0), TombstoneMikeRoryBlock.box((double)0.5, (double)19.0, (double)6.0, (double)15.5, (double)20.0, (double)12.0), TombstoneMikeRoryBlock.box((double)0.5, (double)20.0, (double)6.0, (double)3.5, (double)22.0, (double)12.0), TombstoneMikeRoryBlock.box((double)12.5, (double)20.0, (double)6.0, (double)15.5, (double)22.0, (double)12.0), TombstoneMikeRoryBlock.box((double)6.5, (double)18.0, (double)5.0, (double)9.5, (double)19.0, (double)6.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)TombstoneMikeRoryBlock.box((double)4.0, (double)2.0, (double)2.0, (double)10.0, (double)19.0, (double)14.0), (VoxelShape[])new VoxelShape[]{TombstoneMikeRoryBlock.box((double)2.0, (double)0.0, (double)0.0, (double)13.0, (double)2.0, (double)16.0), TombstoneMikeRoryBlock.box((double)6.0, (double)19.0, (double)5.5, (double)11.0, (double)23.0, (double)10.5), TombstoneMikeRoryBlock.box((double)4.0, (double)19.0, (double)0.5, (double)10.0, (double)20.0, (double)15.5), TombstoneMikeRoryBlock.box((double)4.0, (double)20.0, (double)0.5, (double)10.0, (double)22.0, (double)3.5), TombstoneMikeRoryBlock.box((double)4.0, (double)20.0, (double)12.5, (double)10.0, (double)22.0, (double)15.5), TombstoneMikeRoryBlock.box((double)10.0, (double)18.0, (double)6.5, (double)11.0, (double)19.0, (double)9.5)});
            case Direction.WEST -> Shapes.or((VoxelShape)TombstoneMikeRoryBlock.box((double)6.0, (double)2.0, (double)2.0, (double)12.0, (double)19.0, (double)14.0), (VoxelShape[])new VoxelShape[]{TombstoneMikeRoryBlock.box((double)3.0, (double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0), TombstoneMikeRoryBlock.box((double)5.0, (double)19.0, (double)5.5, (double)10.0, (double)23.0, (double)10.5), TombstoneMikeRoryBlock.box((double)6.0, (double)19.0, (double)0.5, (double)12.0, (double)20.0, (double)15.5), TombstoneMikeRoryBlock.box((double)6.0, (double)20.0, (double)12.5, (double)12.0, (double)22.0, (double)15.5), TombstoneMikeRoryBlock.box((double)6.0, (double)20.0, (double)0.5, (double)12.0, (double)22.0, (double)3.5), TombstoneMikeRoryBlock.box((double)5.0, (double)18.0, (double)6.5, (double)6.0, (double)19.0, (double)9.5)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean onDestroyedByPlayer(BlockState blockstate, Level world, BlockPos pos, Player entity, boolean willHarvest, FluidState fluid) {
        boolean retval = super.onDestroyedByPlayer(blockstate, world, pos, entity, willHarvest, fluid);
        GraveDestroyerProcedure.execute((Entity)entity);
        return retval;
    }
}

