/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.config.feature;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.z2six.weaponcraft.core.Constants;

public final class BalanceConfig {
    private static volatile BalanceConfig INSTANCE;
    public boolean critEnabled = true;
    public float critMultiplier = 1.5f;
    public int minCells = 4;
    public int maxCells = 200;
    public float weightIron = 2.0f;
    public float weightGold = 1.7f;
    public float weightDiamond = 1.5f;
    public float weightNetherite = 2.5f;
    public float minDamage = 4.0f;
    public float maxDamage = 10.0f;
    public float minSpeed = 0.6f;
    public float maxSpeed = 2.8f;
    public float minReach = 2.5f;
    public float maxReach = 5.0f;
    public int minDur = 120;
    public int maxDur = 4096;
    public float minKbMul = 0.8f;
    public float maxKbMul = 2.0f;
    public float minCrit = 0.0f;
    public float maxCrit = 0.5f;
    public float costMulGlobal = 0.1f;
    public float costMulIron = 0.0f;
    public float costMulGold = 0.0f;
    public float costMulDiamond = 0.0f;
    public float costMulNetherite = 0.01f;
    public float bonusPerCellSpeedGold = 0.01f;
    public float bonusPerCellCritDiamond = 0.005f;
    public float bonusPerCellDamageNetherite = 0.005f;
    public float bonusPerCellKnockbackNetherite = 0.005f;
    public float bonusPerCellDurabilityIron = 0.02f;
    public float bonusCapSpeed = 0.1f;
    public float bonusCapCrit = 0.1f;
    public float bonusCapDamage = 0.1f;
    public float bonusCapKnockback = 0.1f;
    public float bonusCapDurability = 0.1f;
    public float bonusDiminishK = 1.0f;
    public float bonusLinearFrac = 0.3f;
    public float minCellThickness = 0.1f;
    public float defaultCellThicknessL = 0.5f;
    public float defaultCellThicknessM = 1.0f;
    public float defaultCellThicknessR = 0.5f;
    public float maxCellThicknessL = 1.0f;
    public float maxCellThicknessM = 2.0f;
    public float maxCellThicknessR = 1.0f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BalanceConfig get() {
        BalanceConfig inst = INSTANCE;
        if (inst != null) return inst;
        Class<BalanceConfig> clazz = BalanceConfig.class;
        synchronized (BalanceConfig.class) {
            inst = INSTANCE;
            if (inst != null) return inst;
            INSTANCE = inst = BalanceConfig.loadOrCreate();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return inst;
        }
    }

    private BalanceConfig() {
    }

    public float costMultiplierForIndex(int matIdx) {
        switch (matIdx) {
            case 1: {
                return this.costMulIron > 0.0f ? this.costMulIron : this.costMulGlobal;
            }
            case 2: {
                return this.costMulGold > 0.0f ? this.costMulGold : this.costMulGlobal;
            }
            case 3: {
                return this.costMulDiamond > 0.0f ? this.costMulDiamond : this.costMulGlobal;
            }
            case 4: {
                return this.costMulNetherite > 0.01f ? this.costMulNetherite : this.costMulGlobal;
            }
        }
        return this.costMulGlobal;
    }

    private static BalanceConfig loadOrCreate() {
        BalanceConfig cfg;
        block60: {
            File cfgDir = new File("config");
            if (!cfgDir.exists()) {
                cfgDir.mkdirs();
            }
            File file = new File(cfgDir, "weaponcraft-balance.toml");
            cfg = new BalanceConfig();
            if (!file.exists()) {
                try (BufferedWriter w = new BufferedWriter(new FileWriter(file, StandardCharsets.UTF_8));){
                    w.write(BalanceConfig.defaultToml());
                }
                catch (IOException ex) {
                    Constants.LOG.error("[WeaponCraft] Failed writing default balance config: {}", (Object)ex.toString());
                }
                return cfg;
            }
            try (BufferedReader r = new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));){
                BufferedWriter w;
                Map<String, Map<String, String>> toml = SimpleToml.parse(r);
                BalanceConfig.applyToml(cfg, toml);
                if (!toml.containsKey("crit")) {
                    try {
                        w = new BufferedWriter(new FileWriter(file, StandardCharsets.UTF_8, true));
                        try {
                            w.write("\n[crit]\n");
                            w.write("enabled = " + cfg.critEnabled + "\n");
                            w.write(String.format(Locale.ROOT, "multiplier = %.2f\n", Float.valueOf(cfg.critMultiplier)));
                        }
                        finally {
                            w.close();
                        }
                    }
                    catch (IOException ex) {
                        Constants.LOG.warn("[WeaponCraft] Could not append [crit] section: {}", (Object)ex.toString());
                    }
                }
                if (!toml.containsKey("cost")) {
                    try {
                        w = new BufferedWriter(new FileWriter(file, StandardCharsets.UTF_8, true));
                        try {
                            w.write("\n[cost]\n");
                            w.write(String.format(Locale.ROOT, "global = %.3f\n", Float.valueOf(cfg.costMulGlobal)));
                            w.write(String.format(Locale.ROOT, "iron = %.3f\n", Float.valueOf(cfg.costMulIron)));
                            w.write(String.format(Locale.ROOT, "gold = %.3f\n", Float.valueOf(cfg.costMulGold)));
                            w.write(String.format(Locale.ROOT, "diamond = %.3f\n", Float.valueOf(cfg.costMulDiamond)));
                            w.write(String.format(Locale.ROOT, "netherite = %.3f\n", Float.valueOf(cfg.costMulNetherite)));
                        }
                        finally {
                            w.close();
                        }
                    }
                    catch (IOException ex) {
                        Constants.LOG.warn("[WeaponCraft] Could not append [cost] section: {}", (Object)ex.toString());
                    }
                }
                if (!toml.containsKey("bonus")) {
                    try {
                        w = new BufferedWriter(new FileWriter(file, StandardCharsets.UTF_8, true));
                        try {
                            w.write("\n[bonus]\n");
                            w.write(String.format(Locale.ROOT, "per_cell_speed_gold = %.3f\n", Float.valueOf(cfg.bonusPerCellSpeedGold)));
                            w.write(String.format(Locale.ROOT, "per_cell_crit_diamond = %.3f\n", Float.valueOf(cfg.bonusPerCellCritDiamond)));
                            w.write(String.format(Locale.ROOT, "per_cell_damage_netherite = %.3f\n", Float.valueOf(cfg.bonusPerCellDamageNetherite)));
                            w.write(String.format(Locale.ROOT, "per_cell_knockback_netherite = %.3f\n", Float.valueOf(cfg.bonusPerCellKnockbackNetherite)));
                            w.write(String.format(Locale.ROOT, "per_cell_durability_iron = %.3f\n", Float.valueOf(cfg.bonusPerCellDurabilityIron)));
                            w.write(String.format(Locale.ROOT, "cap_speed = %.3f\n", Float.valueOf(cfg.bonusCapSpeed)));
                            w.write(String.format(Locale.ROOT, "cap_crit = %.3f\n", Float.valueOf(cfg.bonusCapCrit)));
                            w.write(String.format(Locale.ROOT, "cap_damage = %.3f\n", Float.valueOf(cfg.bonusCapDamage)));
                            w.write(String.format(Locale.ROOT, "cap_knockback = %.3f\n", Float.valueOf(cfg.bonusCapKnockback)));
                            w.write(String.format(Locale.ROOT, "cap_durability = %.3f\n", Float.valueOf(cfg.bonusCapDurability)));
                            w.write(String.format(Locale.ROOT, "diminish_k = %.3f\n", Float.valueOf(cfg.bonusDiminishK)));
                            w.write(String.format(Locale.ROOT, "linear_frac = %.3f\n", Float.valueOf(cfg.bonusLinearFrac)));
                        }
                        finally {
                            w.close();
                        }
                    }
                    catch (IOException ex) {
                        Constants.LOG.warn("[WeaponCraft] Could not append [bonus] section: {}", (Object)ex.toString());
                    }
                } else {
                    Map<String, String> bonus = toml.get("bonus");
                    if (!bonus.containsKey("linear_frac")) {
                        try (BufferedWriter w2 = new BufferedWriter(new FileWriter(file, StandardCharsets.UTF_8, true));){
                            w2.write(String.format(Locale.ROOT, "\n[bonus]\nlinear_frac = %.3f\n", Float.valueOf(cfg.bonusLinearFrac)));
                        }
                        catch (IOException ex) {
                            Constants.LOG.warn("[WeaponCraft] Could not append bonus.linear_frac: {}", (Object)ex.toString());
                        }
                    }
                }
                if (toml.containsKey("thickness")) break block60;
                try {
                    w = new BufferedWriter(new FileWriter(file, StandardCharsets.UTF_8, true));
                    try {
                        w.write("\n[thickness]\n");
                        w.write(String.format(Locale.ROOT, "min = %.3f\n", Float.valueOf(cfg.minCellThickness)));
                        w.write(String.format(Locale.ROOT, "default_l = %.3f\n", Float.valueOf(cfg.defaultCellThicknessL)));
                        w.write(String.format(Locale.ROOT, "default_m = %.3f\n", Float.valueOf(cfg.defaultCellThicknessM)));
                        w.write(String.format(Locale.ROOT, "default_r = %.3f\n", Float.valueOf(cfg.defaultCellThicknessR)));
                        w.write(String.format(Locale.ROOT, "max_l = %.3f\n", Float.valueOf(cfg.maxCellThicknessL)));
                        w.write(String.format(Locale.ROOT, "max_m = %.3f\n", Float.valueOf(cfg.maxCellThicknessM)));
                        w.write(String.format(Locale.ROOT, "max_r = %.3f\n", Float.valueOf(cfg.maxCellThicknessR)));
                    }
                    finally {
                        w.close();
                    }
                }
                catch (IOException ex) {
                    Constants.LOG.warn("[WeaponCraft] Could not append [thickness] section: {}", (Object)ex.toString());
                }
            }
            catch (Exception ex) {
                Constants.LOG.error("[WeaponCraft] Failed reading balance config, using defaults: {}", (Object)ex.toString());
            }
        }
        return cfg;
    }

    private static void applyToml(BalanceConfig c, Map<String, Map<String, String>> t) {
        Map<String, String> val = t.getOrDefault("validation", Map.of());
        Map<String, String> wt = t.getOrDefault("weights", Map.of());
        Map<String, String> cl = t.getOrDefault("clamps", Map.of());
        Map<String, String> crit = t.getOrDefault("crit", Map.of());
        Map<String, String> cost = t.getOrDefault("cost", Map.of());
        Map<String, String> bonus = t.getOrDefault("bonus", Map.of());
        Map<String, String> thickness = t.getOrDefault("thickness", Map.of());
        c.minCells = BalanceConfig.getI(val, "min_cells", c.minCells);
        c.maxCells = BalanceConfig.getI(val, "max_cells", c.maxCells);
        c.weightIron = BalanceConfig.getF(wt, "iron", c.weightIron);
        c.weightGold = BalanceConfig.getF(wt, "gold", c.weightGold);
        c.weightDiamond = BalanceConfig.getF(wt, "diamond", c.weightDiamond);
        c.weightNetherite = BalanceConfig.getF(wt, "netherite", c.weightNetherite);
        c.minDamage = BalanceConfig.getF(cl, "min_damage", c.minDamage);
        c.maxDamage = BalanceConfig.getF(cl, "max_damage", c.maxDamage);
        c.minSpeed = BalanceConfig.getF(cl, "min_speed", c.minSpeed);
        c.maxSpeed = BalanceConfig.getF(cl, "max_speed", c.maxSpeed);
        c.minReach = BalanceConfig.getF(cl, "min_reach", c.minReach);
        c.maxReach = BalanceConfig.getF(cl, "max_reach", c.maxReach);
        c.minDur = BalanceConfig.getI(cl, "min_durability", c.minDur);
        c.maxDur = BalanceConfig.getI(cl, "max_durability", c.maxDur);
        c.minKbMul = BalanceConfig.getF(cl, "min_knockback_mult", c.minKbMul);
        c.maxKbMul = BalanceConfig.getF(cl, "max_knockback_mult", c.maxKbMul);
        c.minCrit = BalanceConfig.getF(cl, "min_crit", c.minCrit);
        c.maxCrit = BalanceConfig.getF(cl, "max_crit", c.maxCrit);
        c.critEnabled = "true".equalsIgnoreCase(crit.getOrDefault("enabled", String.valueOf(c.critEnabled)));
        c.critMultiplier = BalanceConfig.getF(crit, "multiplier", c.critMultiplier);
        c.costMulGlobal = BalanceConfig.getF(cost, "global", c.costMulGlobal);
        c.costMulIron = BalanceConfig.getF(cost, "iron", c.costMulIron);
        c.costMulGold = BalanceConfig.getF(cost, "gold", c.costMulGold);
        c.costMulDiamond = BalanceConfig.getF(cost, "diamond", c.costMulDiamond);
        c.costMulNetherite = BalanceConfig.getF(cost, "netherite", c.costMulNetherite);
        c.bonusPerCellSpeedGold = BalanceConfig.getF(bonus, "per_cell_speed_gold", c.bonusPerCellSpeedGold);
        c.bonusPerCellCritDiamond = BalanceConfig.getF(bonus, "per_cell_crit_diamond", c.bonusPerCellCritDiamond);
        c.bonusPerCellDamageNetherite = BalanceConfig.getF(bonus, "per_cell_damage_netherite", c.bonusPerCellDamageNetherite);
        c.bonusPerCellKnockbackNetherite = BalanceConfig.getF(bonus, "per_cell_knockback_netherite", c.bonusPerCellKnockbackNetherite);
        c.bonusPerCellDurabilityIron = BalanceConfig.getF(bonus, "per_cell_durability_iron", c.bonusPerCellDurabilityIron);
        c.bonusCapSpeed = BalanceConfig.getF(bonus, "cap_speed", c.bonusCapSpeed);
        c.bonusCapCrit = BalanceConfig.getF(bonus, "cap_crit", c.bonusCapCrit);
        c.bonusCapDamage = BalanceConfig.getF(bonus, "cap_damage", c.bonusCapDamage);
        c.bonusCapKnockback = BalanceConfig.getF(bonus, "cap_knockback", c.bonusCapKnockback);
        c.bonusCapDurability = BalanceConfig.getF(bonus, "cap_durability", c.bonusCapDurability);
        c.bonusDiminishK = BalanceConfig.getF(bonus, "diminish_k", c.bonusDiminishK);
        c.bonusLinearFrac = BalanceConfig.getF(bonus, "linear_frac", c.bonusLinearFrac);
        c.minCellThickness = BalanceConfig.getF(thickness, "min", c.minCellThickness);
        c.defaultCellThicknessL = BalanceConfig.getF(thickness, "default_l", c.defaultCellThicknessL);
        c.defaultCellThicknessM = BalanceConfig.getF(thickness, "default_m", c.defaultCellThicknessM);
        c.defaultCellThicknessR = BalanceConfig.getF(thickness, "default_r", c.defaultCellThicknessR);
        c.maxCellThicknessL = BalanceConfig.getF(thickness, "max_l", c.maxCellThicknessL);
        c.maxCellThicknessM = BalanceConfig.getF(thickness, "max_m", c.maxCellThicknessM);
        c.maxCellThicknessR = BalanceConfig.getF(thickness, "max_r", c.maxCellThicknessR);
    }

    private static float getF(Map<String, String> m, String key, float def) {
        try {
            String s = m.get(key);
            return s == null ? def : Float.parseFloat(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private static int getI(Map<String, String> m, String key, int def) {
        try {
            String s = m.get(key);
            return s == null ? def : Integer.parseInt(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private static String defaultToml() {
        return "# WeaponCraft balance configuration (server-authoritative)\n# Created automatically if missing.\n\n[validation]\nmin_cells = 4\nmax_cells = 200\n\n[weights]\niron      = 2.00\ngold      = 1.80\ndiamond   = 1.50\nnetherite = 2.50\n\n[cost]\n# Global \"weight \u2192 cost\" multiplier. If a per-material value is <= 0, it falls back to this.\nglobal = 0.10\n# Per-material overrides (optional; set <= 0 to use 'global')\niron = 0.00\ngold = 0.00\ndiamond = 0.00\nnetherite = 0.01\n\n[clamps]\n# Damage vs Speed\nmin_damage = 4.0\nmax_damage = 10.0\nmin_speed  = 0.6\nmax_speed  = 2.8\n\n# Reach vs Durability\nmin_reach  = 2.5\nmax_reach  = 4.0\nmin_durability = 1000\nmax_durability = 2000\n\n# Knockback vs Crit Chance\nmin_knockback_mult = 0.8\nmax_knockback_mult = 2.0\nmin_crit = 0.00\nmax_crit = 0.20\n\n[crit]\nenabled = true\nmultiplier = 1.50\n\n[bonus]\n# Per-coarse-cell bonus rates (fractions; 0.01 == +1%)\nper_cell_speed_gold = 0.010\nper_cell_crit_diamond = 0.005\nper_cell_damage_netherite = 0.005\nper_cell_knockback_netherite = 0.005\nper_cell_durability_iron = 0.020\n\n# Caps (fractions; 0.10 == 10%)\ncap_speed = 0.10\ncap_crit = 0.10\ncap_damage = 0.10\ncap_knockback = 0.10\ncap_durability = 0.10\n\n# Diminishing curve steepness for the EXPONENTIAL segment.\n# Larger = steeper falloff. 0 disables diminishing and stays linear until cap.\ndiminish_k = 0.30\n\n# Linear \u2192 exponential knee as a FRACTION of the cap (0..1).\n# Example: 0.30 means the first 30% of the cap is accumulated linearly,\n# then the exponential kicks in.\nlinear_frac = 0.05\n\n[thickness]\n# Minimum and maximum allowed cell thickness per layer.\n# Defaults: M layer is the current hardcoded value (= 1.0), L/R default to half of that (= 0.5),\n# max for each is double of default.\nmin       = 0.10\ndefault_l = 0.50\ndefault_m = 1.00\ndefault_r = 0.50\nmax_l     = 1.00\nmax_m     = 2.00\nmax_r     = 1.00\n";
    }

    private static final class SimpleToml {
        private SimpleToml() {
        }

        static Map<String, Map<String, String>> parse(BufferedReader r) throws Exception {
            String line;
            LinkedHashMap<String, Map<String, String>> out = new LinkedHashMap<String, Map<String, String>>();
            Map current = out.computeIfAbsent("", k -> new LinkedHashMap());
            while ((line = r.readLine()) != null) {
                if ((line = SimpleToml.stripComments(line).trim()).isEmpty()) continue;
                if (line.startsWith("[") && line.endsWith("]")) {
                    String sec = line.substring(1, line.length() - 1).trim();
                    current = out.computeIfAbsent(sec, k -> new LinkedHashMap());
                    continue;
                }
                int eq = line.indexOf(61);
                if (eq <= 0) continue;
                String key = line.substring(0, eq).trim();
                String val = line.substring(eq + 1).trim();
                if (val.startsWith("\"") && val.endsWith("\"") || val.startsWith("'") && val.endsWith("'")) {
                    val = val.substring(1, val.length() - 1);
                }
                current.put(key, val);
            }
            return out;
        }

        private static String stripComments(String s) {
            int i = s.indexOf(35);
            return i >= 0 ? s.substring(0, i) : s;
        }
    }
}

