/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.content.item;

import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import org.z2six.weaponcraft.features.rendering.util.BitmapPayload;

public class BlueprintItem
extends Item {
    public static final String TAG_ROOT = "Blueprint";

    public BlueprintItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        CustomData cd = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (cd != null && cd.contains(TAG_ROOT)) {
            CompoundTag root = cd.copyTag();
            CompoundTag bpTag = root.getCompound(TAG_ROOT);
            BitmapPayload payload = BitmapPayload.fromNBT(bpTag);
            tooltip.add((Component)Component.literal((String)("Grid: " + payload.width + "\u00d7" + payload.height + "  |  detail: " + payload.detailScale)));
            int[] counts = new int[5];
            for (int y = 0; y < payload.fineMaterials.length; ++y) {
                byte[] row = payload.fineMaterials[y];
                for (int x = 0; x < row.length; ++x) {
                    int m = row[x] & 0xFF;
                    if (m < 0 || m >= counts.length) continue;
                    int n = m;
                    counts[n] = counts[n] + 1;
                }
            }
            int total = 0;
            for (int i = 1; i <= 4; ++i) {
                total += counts[i];
            }
            tooltip.add((Component)Component.literal((String)("Pixels: " + total + "  (I:" + counts[1] + " G:" + counts[2] + " D:" + counts[3] + " N:" + counts[4] + ")")));
        } else {
            tooltip.add((Component)Component.literal((String)"Empty blueprint"));
        }
    }

    public static void writePayload(ItemStack stack, BitmapPayload payload) {
        CompoundTag root = new CompoundTag();
        root.put(TAG_ROOT, (Tag)payload.toNBT());
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)root));
    }
}

