/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.blueprint.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.z2six.weaponcraft.features.blueprint.client.preview.BlueprintPreviewRenderer;
import org.z2six.weaponcraft.features.blueprint.client.ui.MaterialTooltip;
import org.z2six.weaponcraft.features.blueprint.client.ui.TexturedButton;
import org.z2six.weaponcraft.features.net.client.ClientConfigMirror;
import org.z2six.weaponcraft.features.net.payload.RequestBlueprintItemPayload;
import org.z2six.weaponcraft.features.net.payload.RequestForgeWeaponPayload;
import org.z2six.weaponcraft.features.rendering.util.BitmapPayload;

public class BlueprintScreen
extends Screen {
    private static final ResourceLocation ICO_IRON = ResourceLocation.fromNamespaceAndPath((String)"weaponcraft", (String)"textures/gui/ico_iron.png");
    private static final ResourceLocation ICO_GOLD = ResourceLocation.fromNamespaceAndPath((String)"weaponcraft", (String)"textures/gui/ico_gold.png");
    private static final ResourceLocation ICO_DIAMOND = ResourceLocation.fromNamespaceAndPath((String)"weaponcraft", (String)"textures/gui/ico_diamond.png");
    private static final ResourceLocation ICO_NETHERITE = ResourceLocation.fromNamespaceAndPath((String)"weaponcraft", (String)"textures/gui/ico_netherite.png");
    private static final ResourceLocation TEX_BLUEPRINT_BG = ResourceLocation.fromNamespaceAndPath((String)"weaponcraft", (String)"textures/gui/blueprint_screen.png");
    private static final ResourceLocation TEX_BTN = ResourceLocation.fromNamespaceAndPath((String)"weaponcraft", (String)"textures/gui/btn.png");
    private static final ResourceLocation TEX_BTN_HOVER = ResourceLocation.fromNamespaceAndPath((String)"weaponcraft", (String)"textures/gui/btn_hover.png");
    private static final ResourceLocation TILE_IRON = ResourceLocation.fromNamespaceAndPath((String)"weaponcraft", (String)"textures/gui/tile_iron.png");
    private static final ResourceLocation TILE_GOLD = ResourceLocation.fromNamespaceAndPath((String)"weaponcraft", (String)"textures/gui/tile_gold.png");
    private static final ResourceLocation TILE_DIAMOND = ResourceLocation.fromNamespaceAndPath((String)"weaponcraft", (String)"textures/gui/tile_diamond.png");
    private static final ResourceLocation TILE_NETHERITE = ResourceLocation.fromNamespaceAndPath((String)"weaponcraft", (String)"textures/gui/tile_netherite.png");
    private static final int TILE_SRC_W = 16;
    private static final int TILE_SRC_H = 16;
    private final int GRID_W;
    private final int GRID_H;
    private static final int INTERNAL_DS = 2;
    private static final float DEFAULT_M_THICKNESS = 1.0f;
    private static final float DEFAULT_LR_THICKNESS = 0.5f;
    private float thicknessL = 0.5f;
    private float thicknessM = 1.0f;
    private float thicknessR = 0.5f;
    private int panelLeft;
    private int panelTop;
    private int panelRight;
    private int panelBottom;
    private int gridLeft;
    private int gridTop;
    private int gridRight;
    private int gridBottom;
    private int cell;
    private AbstractButton mintBtn;
    private AbstractButton forgeBtn;
    private AbstractButton clearBtn;
    private AbstractButton closeBtn;
    private EditBox customNameBox;
    private String customName = "";
    private byte[][] fineL;
    private byte[][] fineM;
    private byte[][] fineR;
    private int activeLayer = 1;
    private int detailScale = 1;
    private boolean painting;
    private boolean erasing;
    private int anchorXFine = -1;
    private int anchorYFine = -1;
    private static final int[] PALETTE_ABGR = new int[]{0, -4143153, -997304, -10882834, -11056302};
    private int selectedMaterial = 1;
    private int palLeft;
    private int palTop;
    private int palSize;
    private int palGap;
    private int helpIconX;
    private int helpIconY;
    private final int helpIconSize = 12;
    private int tabsLeft;
    private int tabsTop;
    private int tabsWidth;
    private int tabsHeight;
    private int tabH;
    private int tabGap;
    private int thickSliderLeft;
    private int thickSliderTop;
    private int thickSliderWidth;
    private int thickSliderHeight;
    private boolean thickDragging = false;
    private static final int THUMB_H = 8;

    private static ResourceLocation iconForMaterial(int matIndex) {
        return switch (matIndex) {
            case 1 -> ICO_IRON;
            case 2 -> ICO_GOLD;
            case 3 -> ICO_DIAMOND;
            case 4 -> ICO_NETHERITE;
            default -> ICO_IRON;
        };
    }

    public BlueprintScreen(int gridW, int gridH) {
        super((Component)Component.literal((String)"Blueprint"));
        this.GRID_W = Math.max(1, gridW);
        this.GRID_H = Math.max(1, gridH);
        this.allocateFine();
        this.thicknessL = BlueprintScreen.clamp(this.thicknessL, BlueprintScreen.getMinThickness(), BlueprintScreen.getMaxForLayer(0));
        this.thicknessM = BlueprintScreen.clamp(this.thicknessM, BlueprintScreen.getMinThickness(), BlueprintScreen.getMaxForLayer(1));
        this.thicknessR = BlueprintScreen.clamp(this.thicknessR, BlueprintScreen.getMinThickness(), BlueprintScreen.getMaxForLayer(2));
    }

    private void allocateFine() {
        int fw = this.GRID_W * 2;
        int fh = this.GRID_H * 2;
        if (this.fineL == null || this.fineL.length != fh || this.fineL[0].length != fw) {
            this.fineL = new byte[fh][fw];
        }
        if (this.fineM == null || this.fineM.length != fh || this.fineM[0].length != fw) {
            this.fineM = new byte[fh][fw];
        }
        if (this.fineR == null || this.fineR.length != fh || this.fineR[0].length != fw) {
            this.fineR = new byte[fh][fw];
        }
    }

    private byte[][] fineFor(int layerIndex) {
        return switch (layerIndex) {
            case 0 -> this.fineL;
            case 1 -> this.fineM;
            case 2 -> this.fineR;
            default -> this.fineM;
        };
    }

    protected void init() {
        this.layout();
        this.addControls();
    }

    public void resize(Minecraft mc, int w, int h) {
        super.resize(mc, w, h);
        this.clearWidgets();
        this.layout();
        this.addControls();
    }

    private void layout() {
        int outerPad = 14;
        int paperW = Math.max(360, (int)((float)this.width * 0.78f));
        int paperH = Math.max(320, (int)((float)this.height * 0.78f));
        if (paperW + outerPad * 2 > this.width) {
            paperW = this.width - outerPad * 2;
        }
        if (paperH + outerPad * 2 > this.height) {
            paperH = this.height - outerPad * 2;
        }
        this.panelLeft = (this.width - paperW) / 2;
        this.panelTop = (this.height - paperH) / 2;
        this.panelRight = this.panelLeft + paperW;
        this.panelBottom = this.panelTop + paperH;
        int titleBarH = 22;
        int buttonBarH = 34;
        int paletteH = 28;
        int innerPad = 10;
        int availW = this.panelRight - this.panelLeft - innerPad * 2;
        int availH = this.panelBottom - this.panelTop - innerPad * 2 - titleBarH - buttonBarH - paletteH;
        int dispW = this.GRID_W * (this.detailScale == 2 ? 2 : 1);
        int dispH = this.GRID_H * (this.detailScale == 2 ? 2 : 1);
        int cellW = Math.max(4, availW / dispW);
        int cellH = Math.max(4, availH / dispH);
        this.cell = Math.min(Math.min(cellW, cellH), 20);
        int gridWpx = this.cell * dispW;
        int gridHpx = this.cell * dispH;
        this.gridLeft = this.panelLeft + (this.panelRight - this.panelLeft - gridWpx) / 2;
        this.gridTop = this.panelTop + titleBarH + innerPad + (availH - gridHpx) / 2 + paletteH / 2;
        this.gridRight = this.gridLeft + gridWpx;
        this.gridBottom = this.gridTop + gridHpx;
        this.palSize = 18;
        this.palGap = 6;
        int totalW = this.palSize * 4 + this.palGap * 3;
        this.palLeft = this.panelLeft + (this.panelRight - this.panelLeft - totalW) / 2;
        this.palTop = this.panelTop + titleBarH + 4;
        this.helpIconX = this.panelLeft + 10;
        this.helpIconY = this.panelBottom - 10 - 18 - 8;
        this.tabsWidth = 32;
        this.tabH = 22;
        this.tabGap = 6;
        this.tabsHeight = this.tabH * 3 + this.tabGap * 2;
        this.tabsLeft = this.gridLeft - this.tabsWidth - 12;
        this.tabsTop = this.gridTop + (this.gridBottom - this.gridTop - this.tabsHeight) / 2;
        this.thickSliderWidth = 10;
        this.thickSliderHeight = this.tabsHeight;
        int sliderGap = 8;
        this.thickSliderLeft = this.tabsLeft - sliderGap - this.thickSliderWidth;
        this.thickSliderTop = this.tabsTop;
    }

    private void addControls() {
        int btnW = 75;
        int btnH = 20;
        int gap = 8;
        int totalW = 324;
        int y = this.panelBottom - 10 - 20;
        int x = (this.panelLeft + this.panelRight - 324) / 2;
        int nameBoxH = 18;
        int nameBoxGap = 4;
        int nameBoxW = Math.max(324, 220);
        int nameBoxX = this.panelLeft + (this.panelRight - this.panelLeft - nameBoxW) / 2;
        int nameBoxY = y - 18 - 4;
        this.customNameBox = new EditBox(this.font, nameBoxX, nameBoxY, nameBoxW, 18, (Component)Component.literal((String)"Custom name"));
        this.customNameBox.setMaxLength(25);
        this.customNameBox.setValue(this.customName);
        this.customNameBox.setResponder(s -> {
            this.customName = s;
        });
        this.addRenderableWidget((GuiEventListener)this.customNameBox);
        this.mintBtn = (AbstractButton)this.addRenderableWidget((GuiEventListener)new TexturedButton(x, y, 75, 20, (Component)Component.literal((String)"Mint"), b -> this.doMint(), TEX_BTN, TEX_BTN_HOVER, 75, 20));
        this.mintBtn.setTooltip(Tooltip.create((Component)Component.literal((String)"Request server to mint blueprint item")));
        this.forgeBtn = (AbstractButton)this.addRenderableWidget((GuiEventListener)new TexturedButton(x += 83, y, 75, 20, (Component)Component.literal((String)"Forge"), b -> this.doForge(), TEX_BTN, TEX_BTN_HOVER, 75, 20));
        this.forgeBtn.setTooltip(Tooltip.create((Component)Component.literal((String)"Forge a Netherite-like weapon from this blueprint (test)")));
        this.clearBtn = (AbstractButton)this.addRenderableWidget((GuiEventListener)new TexturedButton(x += 83, y, 75, 20, (Component)Component.literal((String)"Clear"), b -> this.clearGrid(), TEX_BTN, TEX_BTN_HOVER, 75, 20));
        this.clearBtn.setTooltip(Tooltip.create((Component)Component.literal((String)"Erase all painted pixels (all layers)")));
        this.closeBtn = (AbstractButton)this.addRenderableWidget((GuiEventListener)new TexturedButton(x += 83, y, 75, 20, (Component)Component.literal((String)"Close"), b -> this.onClose(), TEX_BTN, TEX_BTN_HOVER, 75, 20));
    }

    private static ResourceLocation tileForMaterial(int m) {
        return switch (m) {
            case 1 -> TILE_IRON;
            case 2 -> TILE_GOLD;
            case 3 -> TILE_DIAMOND;
            case 4 -> TILE_NETHERITE;
            default -> null;
        };
    }

    private static void blitCellTile(GuiGraphics g, ResourceLocation tex, int x, int y, int w, int h) {
        if (tex == null) {
            return;
        }
        g.blit(tex, x, y, 0.0f, 0.0f, w, h, 16, 16);
    }

    private void doMint() {
        BitmapPayload payload = BitmapPayload.fromFineMaterials3(this.GRID_W, this.GRID_H, 2, this.fineL, this.fineM, this.fineR, this.anchorXFine, this.anchorYFine);
        ClientPacketListener conn = Minecraft.getInstance().getConnection();
        if (conn != null) {
            CompoundTag tag = payload.toNBT();
            tag.putString("CustomName", this.customName == null ? "" : this.customName);
            tag.putFloat("thicknessL", this.thicknessL);
            tag.putFloat("thicknessM", this.thicknessM);
            tag.putFloat("thicknessR", this.thicknessR);
            conn.send((CustomPacketPayload)new RequestBlueprintItemPayload(tag));
        }
    }

    private void doForge() {
        BitmapPayload payload = BitmapPayload.fromFineMaterials3(this.GRID_W, this.GRID_H, 2, this.fineL, this.fineM, this.fineR, this.anchorXFine, this.anchorYFine);
        ClientPacketListener conn = Minecraft.getInstance().getConnection();
        if (conn != null) {
            CompoundTag tag = payload.toNBT();
            tag.putString("CustomName", this.customName == null ? "" : this.customName);
            tag.putFloat("thicknessL", this.thicknessL);
            tag.putFloat("thicknessM", this.thicknessM);
            tag.putFloat("thicknessR", this.thicknessR);
            conn.send((CustomPacketPayload)new RequestForgeWeaponPayload(tag));
        }
    }

    private void clearGrid() {
        for (int y = 0; y < this.fineL.length; ++y) {
            for (int x = 0; x < this.fineL[0].length; ++x) {
                this.fineL[y][x] = 0;
                this.fineM[y][x] = 0;
                this.fineR[y][x] = 0;
            }
        }
        this.anchorYFine = -1;
        this.anchorXFine = -1;
    }

    public boolean mouseClicked(double mx, double my, int button) {
        int sel;
        if (BlueprintPreviewRenderer.INSTANCE.mouseClicked(mx, my, button)) {
            return true;
        }
        if (button == 0 && this.insideThicknessSlider(mx, my)) {
            this.thickDragging = true;
            this.updateThicknessFromMouse(my);
            return true;
        }
        if (this.insideTabs(mx, my) && (sel = this.whichTab(mx, my)) >= 0 && sel <= 2) {
            this.activeLayer = sel;
            return true;
        }
        if (this.insidePalette(mx, my) && (sel = this.whichPalette(mx, my)) >= 1 && sel <= 4) {
            this.selectedMaterial = sel;
            return true;
        }
        if (this.insideGrid(mx, my)) {
            if (button == 0 || button == 1) {
                this.painting = button == 0;
                this.erasing = button == 1;
                this.paintAt(mx, my);
                return true;
            }
            if (button == 2) {
                if (this.activeLayer == 1) {
                    this.setAnchorAt(mx, my);
                }
                return true;
            }
        }
        return super.mouseClicked(mx, my, button);
    }

    public boolean mouseReleased(double mx, double my, int button) {
        if (BlueprintPreviewRenderer.INSTANCE.mouseReleased(mx, my, button)) {
            return true;
        }
        if (button == 0 || button == 1) {
            this.painting = false;
            this.erasing = false;
        }
        if (button == 0) {
            this.thickDragging = false;
        }
        return super.mouseReleased(mx, my, button);
    }

    public boolean mouseDragged(double mx, double my, int button, double dx, double dy) {
        if (BlueprintPreviewRenderer.INSTANCE.mouseDragged(mx, my, button, dx, dy)) {
            return true;
        }
        if (this.thickDragging) {
            this.updateThicknessFromMouse(my);
            return true;
        }
        if ((this.painting || this.erasing) && this.insideGrid(mx, my)) {
            this.paintAt(mx, my);
            return true;
        }
        return super.mouseDragged(mx, my, button, dx, dy);
    }

    public boolean mouseScrolled(double mx, double my, double dx, double dy) {
        if (BlueprintPreviewRenderer.INSTANCE.mouseScrolled(mx, my, dx, dy)) {
            return true;
        }
        if (this.insideGrid(mx, my) && dy != 0.0) {
            int prev = this.detailScale;
            int n = this.detailScale = dy > 0.0 ? 2 : 1;
            if (this.detailScale != prev) {
                this.layout();
                return true;
            }
            return false;
        }
        if (this.insideThicknessSlider(mx, my) && dy != 0.0) {
            float step = 0.01f * (BlueprintScreen.getMaxForLayer(this.activeLayer) - BlueprintScreen.getMinThickness());
            this.setThicknessForActive(this.getThicknessForActive() + (float)dy * step);
            return true;
        }
        return false;
    }

    private boolean insideGrid(double mx, double my) {
        return mx >= (double)this.gridLeft && mx < (double)this.gridRight && my >= (double)this.gridTop && my < (double)this.gridBottom;
    }

    private boolean insideTabs(double mx, double my) {
        return mx >= (double)this.tabsLeft && mx < (double)(this.tabsLeft + this.tabsWidth) && my >= (double)this.tabsTop && my < (double)(this.tabsTop + this.tabsHeight);
    }

    private boolean insideThicknessSlider(double mx, double my) {
        return mx >= (double)this.thickSliderLeft && mx < (double)(this.thickSliderLeft + this.thickSliderWidth) && my >= (double)this.thickSliderTop && my < (double)(this.thickSliderTop + this.thickSliderHeight);
    }

    private int whichTab(double mx, double my) {
        for (int i = 0; i < 3; ++i) {
            int ty = this.tabsTop + i * (this.tabH + this.tabGap);
            if (!(my >= (double)ty) || !(my < (double)(ty + this.tabH)) || !(mx >= (double)this.tabsLeft) || !(mx < (double)(this.tabsLeft + this.tabsWidth))) continue;
            return i;
        }
        return -1;
    }

    private void paintAt(double mx, double my) {
        byte[][] fine = this.fineFor(this.activeLayer);
        if (this.detailScale == 2) {
            int fx = (int)((mx - (double)this.gridLeft) / (double)this.cell);
            int fy = (int)((my - (double)this.gridTop) / (double)this.cell);
            if (fx >= 0 && fy >= 0 && fx < this.GRID_W * 2 && fy < this.GRID_H * 2) {
                fine[fy][fx] = (byte)(this.painting ? this.selectedMaterial : 0);
            }
        } else {
            int cx = (int)((mx - (double)this.gridLeft) / (double)this.cell);
            int cy = (int)((my - (double)this.gridTop) / (double)this.cell);
            if (cx >= 0 && cy >= 0 && cx < this.GRID_W && cy < this.GRID_H) {
                int x0 = cx * 2;
                int y0 = cy * 2;
                byte val = (byte)(this.painting ? this.selectedMaterial : 0);
                for (int dy = 0; dy < 2; ++dy) {
                    for (int dx = 0; dx < 2; ++dx) {
                        fine[y0 + dy][x0 + dx] = val;
                    }
                }
            }
        }
    }

    private void setAnchorAt(double mx, double my) {
        int ayCoarse;
        int axCoarse;
        if (this.detailScale == 2) {
            int fx = (int)((mx - (double)this.gridLeft) / (double)this.cell);
            int fy = (int)((my - (double)this.gridTop) / (double)this.cell);
            if (fx < 0 || fy < 0 || fx >= this.GRID_W * 2 || fy >= this.GRID_H * 2) {
                return;
            }
            axCoarse = fx / 2;
            ayCoarse = fy / 2;
        } else {
            int cx = (int)((mx - (double)this.gridLeft) / (double)this.cell);
            int cy = (int)((my - (double)this.gridTop) / (double)this.cell);
            if (cx < 0 || cy < 0 || cx >= this.GRID_W || cy >= this.GRID_H) {
                return;
            }
            axCoarse = cx;
            ayCoarse = cy;
        }
        int clampedAx = BlueprintScreen.clamp(axCoarse, 2, Math.max(2, this.GRID_W - 2));
        int clampedAy = BlueprintScreen.clamp(ayCoarse, 1, Math.max(1, this.GRID_H - 2));
        this.anchorXFine = clampedAx * 2 + 1;
        this.anchorYFine = clampedAy * 2 + 1;
    }

    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int t;
        int idx;
        this.renderBackground(g, mouseX, mouseY, partialTick);
        this.drawPaperPanel(g);
        this.drawTitleAndFooter(g, mouseX, mouseY);
        this.drawPalette(g);
        this.drawThicknessSlider(g, mouseX, mouseY);
        this.drawTabs(g);
        this.drawGrid(g);
        try {
            BitmapPayload preview = BitmapPayload.fromFineMaterials3(this.GRID_W, this.GRID_H, 2, this.fineL, this.fineM, this.fineR, this.anchorXFine, this.anchorYFine);
            String costLine = this.buildCostLine(preview);
            int costX = this.panelLeft + (this.panelRight - this.panelLeft) / 2;
            int costY = this.gridTop - 18;
            g.drawCenteredString(this.font, costLine, costX, costY, -2625025);
        }
        catch (Throwable preview) {
            // empty catch block
        }
        if (this.insidePalette(mouseX, mouseY) && (idx = this.whichPalette(mouseX, mouseY)) >= 1 && idx <= 4) {
            List<Component> lines = MaterialTooltip.make(idx);
            g.renderComponentTooltip(this.font, lines, mouseX, mouseY);
        }
        if (this.insideTabs(mouseX, mouseY) && (t = this.whichTab(mouseX, mouseY)) >= 0) {
            String name = t == 0 ? "Left" : (t == 1 ? "Middle (Grip only)" : "Right");
            g.renderTooltip(this.font, (Component)Component.literal((String)name), mouseX, mouseY);
        }
        if (this.insideThicknessSlider(mouseX, mouseY)) {
            float v = this.getThicknessForActive();
            float mn = BlueprintScreen.getMinThickness();
            float mx = BlueprintScreen.getMaxForLayer(this.activeLayer);
            ArrayList<MutableComponent> tip = new ArrayList<MutableComponent>();
            tip.add(Component.literal((String)"Thickness"));
            tip.add(Component.literal((String)String.format(Locale.ROOT, "Value: %.2fx", Float.valueOf(v))));
            tip.add(Component.literal((String)String.format(Locale.ROOT, "Range: %.2f\u2013%.2f", Float.valueOf(mn), Float.valueOf(mx))));
            g.renderComponentTooltip(this.font, tip, mouseX, mouseY);
        }
        super.render(g, mouseX, mouseY, partialTick);
    }

    private String buildCostLine(BitmapPayload p) {
        float perFine = p.detailScale <= 1 ? 1.0f : 1.0f / (float)(p.detailScale * p.detailScale);
        int fh = p.height * p.detailScale;
        int fw = p.width * p.detailScale;
        int[] fineCounts = new int[5];
        for (int y = 0; y < fh; ++y) {
            byte[] row = p.fineMaterials[y];
            for (int x = 0; x < fw; ++x) {
                int m = row[x] & 0xFF;
                if (m < 1 || m > 4) continue;
                int n = m;
                fineCounts[n] = fineCounts[n] + 1;
            }
        }
        float[] weights = new float[]{0.0f, ClientConfigMirror.weightIron, ClientConfigMirror.weightGold, ClientConfigMirror.weightDiamond, ClientConfigMirror.weightNetherite};
        int ironCost = BlueprintScreen.roundUp((float)fineCounts[1] * perFine * weights[1] * ClientConfigMirror.getCostMul(1));
        int goldCost = BlueprintScreen.roundUp((float)fineCounts[2] * perFine * weights[2] * ClientConfigMirror.getCostMul(2));
        int diamondCost = BlueprintScreen.roundUp((float)fineCounts[3] * perFine * weights[3] * ClientConfigMirror.getCostMul(3));
        int netheriteCost = BlueprintScreen.roundUp((float)fineCounts[4] * perFine * weights[4] * ClientConfigMirror.getCostMul(4));
        ArrayList<CallSite> parts = new ArrayList<CallSite>(4);
        if (ironCost > 0) {
            parts.add((CallSite)((Object)(ironCost + " Iron Ingot" + (ironCost == 1 ? "" : "s"))));
        }
        if (goldCost > 0) {
            parts.add((CallSite)((Object)(goldCost + " Gold Ingot" + (goldCost == 1 ? "" : "s"))));
        }
        if (diamondCost > 0) {
            parts.add((CallSite)((Object)(diamondCost + " Diamond" + (diamondCost == 1 ? "" : "s"))));
        }
        if (netheriteCost > 0) {
            parts.add((CallSite)((Object)(netheriteCost + " Netherite Ingot" + (netheriteCost == 1 ? "" : "s"))));
        }
        if (parts.isEmpty()) {
            return "Cost: \u2014";
        }
        return "Cost: " + String.join((CharSequence)", ", parts);
    }

    private static int roundUp(float v) {
        if (v <= 0.0f) {
            return 0;
        }
        int i = (int)v;
        return v == (float)i ? i : i + 1;
    }

    private void drawPaperPanel(GuiGraphics g) {
        RenderSystem.enableBlend();
        int texW = 1000;
        int texH = 550;
        g.blit(TEX_BLUEPRINT_BG, this.panelLeft, this.panelTop, 0.0f, 0.0f, 1000, 550, 1000, 550);
    }

    private void drawTitleAndFooter(GuiGraphics g, int mouseX, int mouseY) {
        boolean hover;
        int x = this.helpIconX;
        int y = this.helpIconY;
        int s = 12;
        g.fill(x, y, x + s, y + s, -871682477);
        int outline = -11718;
        g.fill(x, y, x + s, y, outline);
        g.fill(x, y + s - 1, x + s, y + s, outline);
        g.fill(x, y, x + 1, y + s, outline);
        g.fill(x + s - 1, y, x + s, y + s, outline);
        String q = "?";
        int qx = x + (s - this.font.width(q)) / 2;
        Objects.requireNonNull(this.font);
        int qy = y + (s - 9) / 2;
        g.drawString(this.font, q, qx, qy, -1);
        boolean bl = hover = mouseX >= x && mouseX < x + s && mouseY >= y && mouseY < y + s;
        if (hover) {
            List<MutableComponent> tips = List.of(Component.literal((String)"LMB: draw"), Component.literal((String)"RMB: erase"), Component.literal((String)"MMB: set grip (Middle layer only)"), Component.literal((String)"Scroll: zoom"), Component.literal((String)"Tip: click a palette square to pick a material"));
            g.renderComponentTooltip(this.font, tips, mouseX, mouseY);
        }
    }

    private void drawTabs(GuiGraphics g) {
        String[] labels = new String[]{"L", "M", "R"};
        for (int i = 0; i < 3; ++i) {
            int x0 = this.tabsLeft;
            int y0 = this.tabsTop + i * (this.tabH + this.tabGap);
            int x1 = x0 + this.tabsWidth;
            int y1 = y0 + this.tabH;
            int bg = i == this.activeLayer ? -14984039 : -16044461;
            g.fill(x0, y0, x1, y1, 1428302390);
            g.fill(x0 + 2, y0 + 2, x1 - 2, y1 - 2, bg);
            if (i == this.activeLayer) {
                int sel = -11718;
                int t = 2;
                g.fill(x0, y0, x1, y0 + t, sel);
                g.fill(x0, y1 - t, x1, y1, sel);
                g.fill(x0, y0, x0 + t, y1, sel);
                g.fill(x1 - t, y0, x1, y1, sel);
            }
            String lab = labels[i];
            int lw = this.font.width(lab);
            Objects.requireNonNull(this.font);
            int lh = 9;
            int cx = x0 + (this.tabsWidth - lw) / 2;
            int cy = y0 + (this.tabH - lh) / 2;
            g.drawString(this.font, lab, cx, cy, -1);
        }
    }

    private void drawPalette(GuiGraphics g) {
        int iconW = 8;
        int iconH = 8;
        for (int i = 1; i <= 4; ++i) {
            int x = this.palLeft + (i - 1) * (this.palSize + this.palGap);
            int y = this.palTop;
            g.fill(x - 2, y - 2, x + this.palSize + 2, y + this.palSize + 2, 1428302390);
            g.fill(x, y, x + this.palSize, y + this.palSize, -16044461);
            ResourceLocation ico = BlueprintScreen.iconForMaterial(i);
            g.blit(ico, x, y, 0.0f, 0.0f, this.palSize, this.palSize, 8, 8);
            if (i != this.selectedMaterial) continue;
            int sel = -11718;
            int t = 2;
            g.fill(x - 2, y - 2, x + this.palSize + 2, y - 2 + t, sel);
            g.fill(x - 2, y + this.palSize + 2 - t, x + this.palSize + 2, y + this.palSize + 2, sel);
            g.fill(x - 2, y - 2, x - 2 + t, y + this.palSize + 2, sel);
            g.fill(x + this.palSize + 2 - t, y - 2, x + this.palSize + 2, y + this.palSize + 2, sel);
        }
    }

    private boolean insidePalette(double mx, double my) {
        int w = this.palSize * 4 + this.palGap * 3;
        return mx >= (double)(this.palLeft - 2) && mx < (double)(this.palLeft - 2 + w + 4) && my >= (double)(this.palTop - 2) && my < (double)(this.palTop - 2 + this.palSize + 4);
    }

    private int whichPalette(double mx, double my) {
        for (int i = 1; i <= 4; ++i) {
            int x = this.palLeft + (i - 1) * (this.palSize + this.palGap);
            int y = this.palTop;
            if (!(mx >= (double)x) || !(mx < (double)(x + this.palSize)) || !(my >= (double)y) || !(my < (double)(y + this.palSize))) continue;
            return i;
        }
        return -1;
    }

    private void drawGrid(GuiGraphics g) {
        RenderSystem.enableBlend();
        int[] order = new int[]{0, 1, 2};
        if (order[2] != this.activeLayer) {
            for (int i = 0; i < 3; ++i) {
                if (order[i] != this.activeLayer) continue;
                order[i] = order[2];
                order[2] = this.activeLayer;
                break;
            }
        }
        if (this.detailScale == 2) {
            int fw = this.GRID_W * 2;
            int fh = this.GRID_H * 2;
            for (oi = 0; oi < 3; ++oi) {
                layer = order[oi];
                byte[][] fine = this.fineFor(layer);
                boolean isActive = layer == this.activeLayer;
                float alphaMul = isActive ? 1.0f : 0.45f;
                for (int y = 0; y < fh; ++y) {
                    for (int x = 0; x < fw; ++x) {
                        int cx = this.gridLeft + x * this.cell;
                        int cy = this.gridTop + y * this.cell;
                        int m = fine[y][x] & 0xFF;
                        if (m == 0) continue;
                        int ix0 = cx + 1;
                        int iy0 = cy + 1;
                        int iw = Math.max(0, this.cell - 2);
                        int ih = Math.max(0, this.cell - 2);
                        ResourceLocation tex = BlueprintScreen.tileForMaterial(m);
                        if (tex != null && iw > 0 && ih > 0) {
                            g.blit(tex, ix0, iy0, 0.0f, 0.0f, iw, ih, 16, 16);
                        }
                        if (isActive || !(alphaMul < 1.0f) || iw <= 0 || ih <= 0) continue;
                        int veilA = (int)(alphaMul * 255.0f);
                        int veil = veilA << 24;
                        g.fill(ix0, iy0, ix0 + iw, iy0 + ih, veil);
                    }
                }
            }
            line = 1142581923;
            for (x = 0; x <= fw; ++x) {
                int px = this.gridLeft + x * this.cell;
                g.fill(px, this.gridTop, px + 1, this.gridBottom, line);
            }
            for (y = 0; y <= fh; ++y) {
                int py = this.gridTop + y * this.cell;
                g.fill(this.gridLeft, py, this.gridRight, py + 1, line);
            }
        } else {
            int cw = this.GRID_W;
            int ch = this.GRID_H;
            for (oi = 0; oi < 3; ++oi) {
                layer = order[oi];
                boolean isActive = layer == this.activeLayer;
                float alphaMul = isActive ? 1.0f : 0.45f;
                for (int cy = 0; cy < ch; ++cy) {
                    for (int cx = 0; cx < cw; ++cx) {
                        int px = this.gridLeft + cx * this.cell;
                        int py = this.gridTop + cy * this.cell;
                        int m = this.coarseMaterialAt(layer, cx, cy);
                        if (m == 0) continue;
                        int ix0 = px + 1;
                        int iy0 = py + 1;
                        int iw = Math.max(0, this.cell - 2);
                        int ih = Math.max(0, this.cell - 2);
                        ResourceLocation tex = BlueprintScreen.tileForMaterial(m);
                        if (tex != null && iw > 0 && ih > 0) {
                            g.blit(tex, ix0, iy0, 0.0f, 0.0f, iw, ih, 16, 16);
                        }
                        if (isActive || !(alphaMul < 1.0f) || iw <= 0 || ih <= 0) continue;
                        int veilA = (int)(alphaMul * 255.0f);
                        int veil = veilA << 24;
                        g.fill(ix0, iy0, ix0 + iw, iy0 + ih, veil);
                    }
                }
            }
            line = 1142581923;
            for (x = 0; x <= cw; ++x) {
                int px = this.gridLeft + x * this.cell;
                g.fill(px, this.gridTop, px + 1, this.gridBottom, line);
            }
            for (y = 0; y <= ch; ++y) {
                int py = this.gridTop + y * this.cell;
                g.fill(this.gridLeft, py, this.gridRight, py + 1, line);
            }
        }
        if (this.anchorXFine >= 0 && this.anchorYFine >= 0) {
            int axCoarse = this.anchorXFine / 2;
            int ayCoarse = this.anchorYFine / 2;
            int minXc = BlueprintScreen.clamp(axCoarse - 2, 0, this.GRID_W - 1);
            int maxXc = BlueprintScreen.clamp(axCoarse + 1, 0, this.GRID_W - 1);
            int minYc = BlueprintScreen.clamp(ayCoarse - 1, 0, this.GRID_H - 1);
            int maxYc = BlueprintScreen.clamp(ayCoarse + 1, 0, this.GRID_H - 1);
            if (minXc <= maxXc && minYc <= maxYc) {
                int c = -11718;
                int dsDisp = this.detailScale == 2 ? 2 : 1;
                int x0 = this.gridLeft + minXc * dsDisp * this.cell;
                int x1 = this.gridLeft + (maxXc + 1) * dsDisp * this.cell;
                int y0 = this.gridTop + minYc * dsDisp * this.cell;
                int y1 = this.gridTop + (maxYc + 1) * dsDisp * this.cell;
                int t = 2;
                g.fill(x0, y0, x1, y0 + t, c);
                g.fill(x0, y1 - t, x1, y1, c);
                g.fill(x0, y0, x0 + t, y1, c);
                g.fill(x1 - t, y0, x1, y1, c);
            }
        }
    }

    private void drawThicknessSlider(GuiGraphics g, int mouseX, int mouseY) {
        int x0 = this.thickSliderLeft;
        int y0 = this.thickSliderTop;
        int x1 = x0 + this.thickSliderWidth;
        int y1 = y0 + this.thickSliderHeight;
        g.fill(x0 - 2, y0 - 2, x1 + 2, y1 + 2, 1428302390);
        g.fill(x0, y0, x1, y1, -16044461);
        float min = BlueprintScreen.getMinThickness();
        float max = BlueprintScreen.getMaxForLayer(this.activeLayer);
        float v = this.getThicknessForActive();
        float frac = max > min ? (v - min) / (max - min) : 0.0f;
        frac = BlueprintScreen.clamp(frac, 0.0f, 1.0f);
        int filledTop = (int)((float)y1 - frac * (float)(this.thickSliderHeight - 2));
        g.fill(x0 + 1, filledTop, x1 - 1, y1 - 1, -14984039);
        int thumbCenterY = (int)((float)y1 - frac * (float)(this.thickSliderHeight - 1));
        int thY0 = BlueprintScreen.clamp(thumbCenterY - 4, y0 + 1, y1 - 1 - 8);
        int thY1 = thY0 + 8;
        g.fill(x0 + 1, thY0, x1 - 1, thY1, -11718);
        String lab = switch (this.activeLayer) {
            case 0 -> "L";
            case 1 -> "M";
            default -> "R";
        };
        String val = String.format(Locale.ROOT, "%s  %.2fx", lab, Float.valueOf(v));
        int rw = this.font.width(val);
        int rx = x0 + (this.thickSliderWidth - rw) / 2;
        int ry = y0 - 10;
        g.drawString(this.font, val, rx, ry, -1);
        if (this.insideThicknessSlider(mouseX, mouseY) || this.thickDragging) {
            int sel = -11718;
            g.fill(x0, y0, x1, y0 + 1, sel);
            g.fill(x0, y1 - 1, x1, y1, sel);
            g.fill(x0, y0, x0 + 1, y1, sel);
            g.fill(x1 - 1, y0, x1, y1, sel);
        }
    }

    private int coarseMaterialAt(int layer, int cx, int cy) {
        int m;
        byte[][] fine = this.fineFor(layer);
        int x0 = cx * 2;
        int y0 = cy * 2;
        int[] counts = new int[5];
        for (int dy = 0; dy < 2; ++dy) {
            for (int dx = 0; dx < 2; ++dx) {
                m = fine[y0 + dy][x0 + dx] & 0xFF;
                if (m < 0 || m >= counts.length) continue;
                int n = m;
                counts[n] = counts[n] + 1;
            }
        }
        int best = 0;
        int bestCount = 0;
        for (m = 1; m <= 4; ++m) {
            if (counts[m] <= bestCount) continue;
            bestCount = counts[m];
            best = m;
        }
        if (bestCount == 0) {
            return 0;
        }
        return best;
    }

    private float getThicknessForActive() {
        return switch (this.activeLayer) {
            case 0 -> this.thicknessL;
            case 1 -> this.thicknessM;
            case 2 -> this.thicknessR;
            default -> this.thicknessM;
        };
    }

    private void setThicknessForActive(float v) {
        float min = BlueprintScreen.getMinThickness();
        float max = BlueprintScreen.getMaxForLayer(this.activeLayer);
        v = BlueprintScreen.clamp(v, min, max);
        switch (this.activeLayer) {
            case 0: {
                this.thicknessL = v;
                break;
            }
            case 1: {
                this.thicknessM = v;
                break;
            }
            case 2: {
                this.thicknessR = v;
            }
        }
    }

    private void updateThicknessFromMouse(double my) {
        float min = BlueprintScreen.getMinThickness();
        float max = BlueprintScreen.getMaxForLayer(this.activeLayer);
        if (max <= min) {
            this.setThicknessForActive(min);
            return;
        }
        float trackTop = (float)(this.thickSliderTop + 1) + 4.0f;
        float trackBot = (float)(this.thickSliderTop + this.thickSliderHeight - 1) - 4.0f;
        float clampedY = BlueprintScreen.clamp((int)my, (int)trackTop, (int)trackBot);
        float t = 1.0f - (clampedY - trackTop) / Math.max(1.0f, trackBot - trackTop);
        float v = min + t * (max - min);
        v = (float)Math.round(v * 100.0f) / 100.0f;
        this.setThicknessForActive(v);
    }

    private static float clamp(float v, float min, float max) {
        return v < min ? min : (v > max ? max : v);
    }

    private static int clamp(int v, int min, int max) {
        return v < min ? min : (v > max ? max : v);
    }

    private static int applyAlpha(int abgr, float mul) {
        int a = (int)((float)(abgr >>> 24 & 0xFF) * mul);
        return abgr & 0xFFFFFF | (a & 0xFF) << 24;
    }

    private static float getMinThickness() {
        return ClientConfigMirror.minCellThickness;
    }

    private static float getMaxForLayer(int idx) {
        return switch (idx) {
            case 0 -> ClientConfigMirror.maxCellThicknessL;
            case 1 -> ClientConfigMirror.maxCellThicknessM;
            case 2 -> ClientConfigMirror.maxCellThicknessR;
            default -> ClientConfigMirror.maxCellThicknessM;
        };
    }

    public boolean isPauseScreen() {
        return false;
    }
}

