/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.blueprint.client.preview;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import org.z2six.weaponcraft.features.blueprint.client.preview.ConditionalDelegatingHeldItemLayer;

@EventBusSubscriber(modid="weaponcraft", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public final class BlueprintClientRenderHooks {
    private BlueprintClientRenderHooks() {
    }

    @SubscribeEvent
    public static void onAddLayers(EntityRenderersEvent.AddLayers e) {
        for (PlayerSkin.Model skinKey : e.getSkins()) {
            EntityRenderer r = e.getSkin(skinKey);
            if (!(r instanceof PlayerRenderer)) continue;
            PlayerRenderer pr = (PlayerRenderer)r;
            BlueprintClientRenderHooks.replaceHeldItemLayer(pr);
        }
    }

    private static void replaceHeldItemLayer(PlayerRenderer renderer) {
        try {
            Field fLayers = LivingEntityRenderer.class.getDeclaredField("layers");
            fLayers.setAccessible(true);
            List layers = (List)fLayers.get(renderer);
            ItemInHandLayer found = null;
            Iterator it = layers.iterator();
            while (it.hasNext()) {
                ItemInHandLayer lih;
                RenderLayer layer = (RenderLayer)it.next();
                if (!(layer instanceof ItemInHandLayer)) continue;
                found = lih = (ItemInHandLayer)layer;
                it.remove();
                break;
            }
            if (found == null) {
                return;
            }
            ItemInHandLayer delegate = found;
            ConditionalDelegatingHeldItemLayer wrapper = new ConditionalDelegatingHeldItemLayer(renderer, delegate);
            layers.add(wrapper);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

