/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.blueprint.client.preview;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.z2six.weaponcraft.core.Constants;

public final class BlueprintCompanionHead {
    public static volatile boolean IN_COMPANION_RENDER = false;
    public static float SIZE_FRACTION = 0.9f;
    public static int MARGIN_PX = 10;
    public static float BOB_AMPLITUDE_PX = 0.0f;
    public static float BOB_SPEED_HZ = 0.8f;
    public static int MIN_RENDER_SIZE = 64;
    public static int MAX_RENDER_SIZE = 220;
    public static float EXTRA_BODY_YAW_DEG = 12.0f;
    public static float EXTRA_HEAD_YAW_DEG = 18.0f;
    public static float EXTRA_HEAD_PITCH_DEG = -12.0f;
    public static float HEAD_YAW_DEG_ADJ = -5.0f;
    public static float HEAD_PITCH_DEG_ADJ = -15.0f;
    public static boolean SHOW_BACKDROP = true;
    public static int BACKDROP_COLOR = 0x66000000;
    public static int BACKDROP_PAD = 6;
    public static float DRAG_SENS_YAW = 0.6f;
    public static float DRAG_SENS_PITCH = 0.6f;
    public static float DRAG_SENS_ROLL = 0.6f;
    public static int CLICK_THRESHOLD_PX = 3;
    public static float CAM_YAW_DEG = 0.0f;
    public static float CAM_PITCH_DEG = 0.0f;
    public static float CAM_ROLL_DEG = 0.0f;
    public static float SCREEN_OFFSET_X = 0.0f;
    public static float SCREEN_OFFSET_Y = 200.0f;
    public static float BOX_SCALE = 0.6f;
    public static boolean CROP_TO_BOX = true;
    public static int BOX_OFFSET_X = 10;
    public static int BOX_OFFSET_Y = -100;
    public static float BODY_YAW_DEG_ADJ = 0.0f;
    public static boolean ABSOLUTE_FACE = true;
    public static boolean ARM_ENABLED = true;
    public static float ARM_X_DEG = 270.0f;
    public static float ARM_Y_DEG = -50.0f;
    public static float ARM_Z_DEG = -25.0f;
    private static int lastX;
    private static int lastY;
    private static int lastW;
    private static int lastH;
    private static boolean dragging;
    private static int dragStartX;
    private static int dragStartY;
    private static int lastMouseX;
    private static int lastMouseY;
    private static boolean shiftAtStart;
    private static boolean movedBeyondClick;

    private BlueprintCompanionHead() {
    }

    public static boolean hitTest(double mx, double my) {
        return mx >= (double)lastX && mx < (double)(lastX + lastW) && my >= (double)lastY && my < (double)(lastY + lastH);
    }

    public static boolean mousePressed(double mx, double my, int button, boolean shiftDown) {
        if (button != 0) {
            return false;
        }
        if (!BlueprintCompanionHead.hitTest(mx, my)) {
            return false;
        }
        dragging = true;
        dragStartX = lastMouseX = (int)mx;
        dragStartY = lastMouseY = (int)my;
        shiftAtStart = shiftDown;
        movedBeyondClick = false;
        return true;
    }

    public static boolean mouseDragged(double mx, double my, int button, double dx, double dy, boolean shiftDown) {
        if (!dragging || button != 0) {
            return false;
        }
        int ix = (int)mx;
        int iy = (int)my;
        if (!movedBeyondClick) {
            int adx = Math.abs(ix - dragStartX);
            int ady = Math.abs(iy - dragStartY);
            if (adx > CLICK_THRESHOLD_PX || ady > CLICK_THRESHOLD_PX) {
                movedBeyondClick = true;
            }
        }
        if (shiftAtStart || shiftDown) {
            CAM_ROLL_DEG = BlueprintCompanionHead.wrapDeg(CAM_ROLL_DEG + (float)(dx * (double)DRAG_SENS_ROLL));
        } else {
            CAM_YAW_DEG = BlueprintCompanionHead.wrapDeg(CAM_YAW_DEG + (float)(dx * (double)DRAG_SENS_YAW));
            CAM_PITCH_DEG = BlueprintCompanionHead.clamp(CAM_PITCH_DEG - (float)(dy * (double)DRAG_SENS_PITCH), -89.9f, 89.9f);
        }
        lastMouseX = ix;
        lastMouseY = iy;
        Constants.LOG.info("[WeaponCraft] CompanionHead yaw={} pitch={} roll={} | absFace={} headAdj=({}, {}) bodyAdj={} offset=({}, {}) boxScale={} boxOffset=({}, {}) armEnabled={} armDeg=({},{},{})", new Object[]{String.format(Locale.ROOT, "%.1f", Float.valueOf(CAM_YAW_DEG)), String.format(Locale.ROOT, "%.1f", Float.valueOf(CAM_PITCH_DEG)), String.format(Locale.ROOT, "%.1f", Float.valueOf(CAM_ROLL_DEG)), ABSOLUTE_FACE, String.format(Locale.ROOT, "%.1f", Float.valueOf(HEAD_YAW_DEG_ADJ)), String.format(Locale.ROOT, "%.1f", Float.valueOf(HEAD_PITCH_DEG_ADJ)), String.format(Locale.ROOT, "%.1f", Float.valueOf(BODY_YAW_DEG_ADJ)), String.format(Locale.ROOT, "%.1f", Float.valueOf(SCREEN_OFFSET_X)), String.format(Locale.ROOT, "%.1f", Float.valueOf(SCREEN_OFFSET_Y)), String.format(Locale.ROOT, "%.2f", Float.valueOf(BOX_SCALE)), BOX_OFFSET_X, BOX_OFFSET_Y, ARM_ENABLED, String.format(Locale.ROOT, "%.1f", Float.valueOf(ARM_X_DEG)), String.format(Locale.ROOT, "%.1f", Float.valueOf(ARM_Y_DEG)), String.format(Locale.ROOT, "%.1f", Float.valueOf(ARM_Z_DEG))});
        return true;
    }

    public static int mouseReleased(double mx, double my, int button) {
        if (button != 0) {
            return 0;
        }
        if (!dragging) {
            return 0;
        }
        boolean click = !movedBeyondClick;
        dragging = false;
        return click ? 2 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void render(GuiGraphics g, int rectX, int rectY, int rectW, int rectH) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null) {
            return;
        }
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        lastX = rectX;
        lastY = rectY;
        lastW = rectW;
        lastH = rectH;
        float scale = BlueprintCompanionHead.clamp(BOX_SCALE, 0.2f, 2.0f);
        int boxW = Math.round((float)rectW * scale);
        int boxH = Math.round((float)rectH * scale);
        int boxX = rectX + rectW - boxW + BOX_OFFSET_X;
        int boxY = rectY + rectH - boxH + BOX_OFFSET_Y;
        int base = Math.min(boxW, boxH);
        int size = BlueprintCompanionHead.clamp(Math.round((float)base * SIZE_FRACTION), MIN_RENDER_SIZE, MAX_RENDER_SIZE);
        int cx = boxX + boxW - MARGIN_PX - size / 2;
        int cy = boxY + boxH - MARGIN_PX - (int)((float)size * 0.35f);
        cx += (int)SCREEN_OFFSET_X;
        cy += (int)SCREEN_OFFSET_Y;
        if (BOB_AMPLITUDE_PX != 0.0f && BOB_SPEED_HZ > 0.0f) {
            double t = (double)System.nanoTime() / 1.0E9 * ((double)BOB_SPEED_HZ * Math.PI * 2.0);
            cy += (int)Math.round(Math.sin(t) * (double)BOB_AMPLITUDE_PX);
        }
        boolean scissored = false;
        if (CROP_TO_BOX) {
            scissored = true;
            g.enableScissor(boxX, boxY, boxX + boxW, boxY + boxH);
        }
        if (SHOW_BACKDROP) {
            int bx0 = cx - size / 2 - BACKDROP_PAD;
            int by0 = cy - size / 2 - BACKDROP_PAD;
            int bx1 = cx + size / 2 + BACKDROP_PAD;
            int by1 = cy + size / 2 + BACKDROP_PAD;
            RenderSystem.enableBlend();
            g.fill(bx0, by0, bx1, by1, BACKDROP_COLOR);
        }
        float prevBodyRot = player.yBodyRot;
        float prevBodyRotO = player.yBodyRotO;
        float prevHeadRot = player.yHeadRot;
        float prevHeadRotO = player.yHeadRotO;
        float prevYRot = player.getYRot();
        float prevYRotO = player.yRotO;
        float prevXRot = player.getXRot();
        float prevXRotO = player.xRotO;
        try {
            float headPitch;
            float headYaw;
            float bodyYaw;
            if (ABSOLUTE_FACE) {
                bodyYaw = BlueprintCompanionHead.wrapDeg(EXTRA_BODY_YAW_DEG + BODY_YAW_DEG_ADJ);
                headYaw = BlueprintCompanionHead.wrapDeg(EXTRA_HEAD_YAW_DEG + HEAD_YAW_DEG_ADJ);
                headPitch = BlueprintCompanionHead.clamp(EXTRA_HEAD_PITCH_DEG + HEAD_PITCH_DEG_ADJ, -89.9f, 89.9f);
            } else {
                bodyYaw = BlueprintCompanionHead.wrapDeg(prevBodyRot + EXTRA_BODY_YAW_DEG + BODY_YAW_DEG_ADJ);
                headYaw = BlueprintCompanionHead.wrapDeg(prevHeadRot + EXTRA_HEAD_YAW_DEG + HEAD_YAW_DEG_ADJ);
                headPitch = BlueprintCompanionHead.clamp(prevXRot + EXTRA_HEAD_PITCH_DEG + HEAD_PITCH_DEG_ADJ, -89.9f, 89.9f);
            }
            player.yBodyRot = bodyYaw;
            player.yBodyRotO = bodyYaw;
            player.setYRot(bodyYaw);
            player.yRotO = bodyYaw;
            player.yHeadRot = headYaw;
            player.yHeadRotO = headYaw;
            player.setXRot(headPitch);
            player.xRotO = headPitch;
            Quaternionf poseQ = new Quaternionf().rotateZ((float)Math.PI).rotateY((float)Math.PI).rotateZ((float)Math.toRadians(CAM_ROLL_DEG));
            Quaternionf camQ = new Quaternionf().rotateX((float)Math.toRadians(CAM_PITCH_DEG)).rotateY((float)Math.toRadians(CAM_YAW_DEG));
            PoseStack ps = g.pose();
            ps.pushPose();
            ps.translate(0.0f, 0.0f, 900.0f);
            RenderSystem.enableBlend();
            IN_COMPANION_RENDER = true;
            InventoryScreen.renderEntityInInventory((GuiGraphics)g, (float)cx, (float)cy, (float)size, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Quaternionf)poseQ, (Quaternionf)camQ, (LivingEntity)player);
            g.flush();
            ps.popPose();
        }
        catch (Throwable throwable) {
        }
        finally {
            IN_COMPANION_RENDER = false;
            player.yBodyRot = prevBodyRot;
            player.yBodyRotO = prevBodyRotO;
            player.yHeadRot = prevHeadRot;
            player.yHeadRotO = prevHeadRotO;
            player.setYRot(prevYRot);
            player.yRotO = prevYRotO;
            player.setXRot(prevXRot);
            player.xRotO = prevXRotO;
            if (scissored) {
                g.disableScissor();
            }
        }
    }

    private static int clamp(int v, int lo, int hi) {
        return v < lo ? lo : (v > hi ? hi : v);
    }

    private static float clamp(float v, float lo, float hi) {
        return v < lo ? lo : (v > hi ? hi : v);
    }

    private static float wrapDeg(float d) {
        return (d %= 360.0f) < -180.0f ? d + 360.0f : (d > 180.0f ? d - 360.0f : d);
    }

    static {
        dragging = false;
        shiftAtStart = false;
        movedBeyondClick = false;
    }
}

