/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.blueprint.client.preview;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;
import org.z2six.weaponcraft.config.feature.BalanceConfig;
import org.z2six.weaponcraft.core.Constants;
import org.z2six.weaponcraft.features.blueprint.client.BlueprintScreen;
import org.z2six.weaponcraft.features.blueprint.client.preview.BlueprintCompanionHead;
import org.z2six.weaponcraft.features.blueprint.client.preview.BlueprintPreviewRenderer;
import org.z2six.weaponcraft.features.blueprint.stats.BlueprintMetrics;
import org.z2six.weaponcraft.features.blueprint.stats.BlueprintStatCalculator;
import org.z2six.weaponcraft.features.blueprint.stats.NameGenerator;
import org.z2six.weaponcraft.features.blueprint.stats.StatResult;
import org.z2six.weaponcraft.features.blueprint.validation.ConnectedShapeValidator;
import org.z2six.weaponcraft.features.net.client.ClientConfigMirror;
import org.z2six.weaponcraft.features.rendering.util.BitmapPayload;

@EventBusSubscriber(modid="weaponcraft", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public final class BlueprintOverlay {
    private static int PANEL_WIDTH = 250;
    private static int PANEL_HEIGHT = 300;
    private static float FONT_SCALE = 1.0f;
    private static int PREVIEW_MARGIN_TOP = 16;
    private static final ResourceLocation TEX_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"weaponcraft", (String)"textures/gui/blueprint_overlay.png");
    private static Field fGRID_W;
    private static Field fGRID_H;
    private static Field fDetail;
    private static Field fFineL;
    private static Field fFineM;
    private static Field fFineR;
    private static Field fAX;
    private static Field fAY;
    private static Field fCustomName;
    private static Field fThickL;
    private static Field fThickM;
    private static Field fThickR;

    private BlueprintOverlay() {
    }

    @SubscribeEvent
    public static void onScreenRender(ScreenEvent.Render.Post e) {
        if (!(e.getScreen() instanceof BlueprintScreen)) {
            return;
        }
        GuiGraphics g = e.getGuiGraphics();
        try {
            BlueprintSnapshot snap = BlueprintOverlay.snapshotFromScreen((BlueprintScreen)e.getScreen());
            if (snap == null) {
                return;
            }
            BitmapPayload payload = BlueprintOverlay.payloadFromSnapshotWithThickness(snap);
            boolean connected = ConnectedShapeValidator.isConnected(payload);
            BalanceConfig cfg = BalanceConfig.get();
            float modelSize = BlueprintMetrics.modelSizeUnits(payload);
            StatResult srBase = BlueprintStatCalculator.compute(payload, cfg);
            boolean gripSet = snap.anchorXFine >= 0 && snap.anchorYFine >= 0;
            String autoName = NameGenerator.autoName(payload, srBase);
            String customName = snap.customName != null ? snap.customName : "";
            String mergedName = NameGenerator.mergedDisplayName(customName, autoName);
            DisplayBonus bonus = BlueprintOverlay.computeDisplayBonus(payload, snap.thicknessL, snap.thicknessM, snap.thicknessR);
            int panelW = PANEL_WIDTH;
            int panelH = PANEL_HEIGHT;
            int x = e.getScreen().width - panelW - 16;
            int y = 16;
            BlueprintOverlay.drawPanel(g, x, y, panelW, panelH);
            int lineY = y + 8;
            int lineStepSmall = Math.round(12.0f * FONT_SCALE);
            int lineStepMed = Math.round(14.0f * FONT_SCALE);
            BlueprintOverlay.drawScaledString(g, mergedName, x + 8, lineY, 0xFFFFFF, FONT_SCALE);
            String sizeLine = "Model size: " + BlueprintOverlay.fmt(modelSize) + "  [min " + cfg.minCells + " / max " + cfg.maxCells + "]";
            BlueprintOverlay.drawScaledString(g, sizeLine, x + 8, lineY += lineStepMed, modelSize >= (float)cfg.minCells && modelSize <= (float)cfg.maxCells ? 0xCFEFFF : 16760959, FONT_SCALE);
            BlueprintOverlay.drawScaledString(g, "Connected: " + (connected ? "Yes" : "No"), x + 8, lineY += lineStepSmall, connected ? 10878875 : 0xFF7B7B, FONT_SCALE);
            BlueprintOverlay.drawScaledString(g, "Grip set: " + (gripSet ? "Yes" : "No"), x + 8, lineY += lineStepMed, gripSet ? 10878875 : 0xFF7B7B, FONT_SCALE);
            lineY += lineStepMed;
            int COL_GOLD = -997304;
            int COL_DIAMOND = -10882834;
            int COL_NETHERITE = -11056302;
            int COL_IRON = -4143153;
            int COL_TEXT = 15135743;
            int COL_PAIR_HDR = -1641473;
            int COL_BAR_FRAME = -2130706433;
            int COL_BAR_BG = 1076116579;
            int dmgPct = Math.round(srBase.tMass * 100.0f);
            int spdPct = 100 - dmgPct;
            BlueprintOverlay.drawScaledString(g, "Damage \u2194 Speed", x + 8, lineY, -1641473, FONT_SCALE);
            lineY += lineStepSmall;
            String left = String.format(Locale.ROOT, "Damage: %.2f (", Float.valueOf(srBase.damage * (1.0f + bonus.damage)));
            String mid = dmgPct + "%";
            if (bonus.damage <= 0.0f) {
                BlueprintOverlay.drawScaledString(g, left + mid + ")", x + 8, lineY, 15135743, FONT_SCALE);
            } else {
                BlueprintOverlay.drawScaledSegments(g, x + 8, lineY, FONT_SCALE, new Seg(left, 15135743), new Seg(mid, 15135743), new Seg(" + " + Math.round(bonus.damage * 100.0f) + "%", -11056302), new Seg(")", 15135743));
            }
            lineY += lineStepSmall;
            left = String.format(Locale.ROOT, "Speed: %.2f (", Float.valueOf(srBase.speed * (1.0f + bonus.speed)));
            mid = spdPct + "%";
            if (bonus.speed <= 0.0f) {
                BlueprintOverlay.drawScaledString(g, left + mid + ")", x + 8, lineY, 15135743, FONT_SCALE);
            } else {
                BlueprintOverlay.drawScaledSegments(g, x + 8, lineY, FONT_SCALE, new Seg(left, 15135743), new Seg(mid, 15135743), new Seg(" + " + Math.round(bonus.speed * 100.0f) + "%", -997304), new Seg(")", 15135743));
            }
            int barX = x + 8;
            int barW = panelW - 16;
            int barH = 6;
            BlueprintOverlay.drawPairBar(g, barX, (lineY += lineStepSmall) + 2, barW, barH, dmgPct, -11056302, -997304, 1076116579, -2130706433);
            int kbPct = Math.round(srBase.tBulk * 100.0f);
            int critPct = 100 - kbPct;
            BlueprintOverlay.drawScaledString(g, "Knockback \u2194 Crit", x + 8, lineY += barH + 6, -1641473, FONT_SCALE);
            lineY += lineStepSmall;
            String left2 = String.format(Locale.ROOT, "Knockback: %.2f\u00d7 (", Float.valueOf(srBase.knockbackMult * (1.0f + bonus.knockback)));
            String mid2 = kbPct + "%";
            if (bonus.knockback <= 0.0f) {
                BlueprintOverlay.drawScaledString(g, left2 + mid2 + ")", x + 8, lineY, 15135743, FONT_SCALE);
            } else {
                BlueprintOverlay.drawScaledSegments(g, x + 8, lineY, FONT_SCALE, new Seg(left2, 15135743), new Seg(mid2, 15135743), new Seg(" + " + Math.round(bonus.knockback * 100.0f) + "%", -11056302), new Seg(")", 15135743));
            }
            lineY += lineStepSmall;
            float critShown = Math.min(1.0f, srBase.critChance + bonus.crit);
            String left3 = String.format(Locale.ROOT, "Crit: %.0f%% (", Float.valueOf(critShown * 100.0f));
            String mid3 = critPct + "%";
            if (bonus.crit <= 0.0f) {
                BlueprintOverlay.drawScaledString(g, left3 + mid3 + ")", x + 8, lineY, 15135743, FONT_SCALE);
            } else {
                BlueprintOverlay.drawScaledSegments(g, x + 8, lineY, FONT_SCALE, new Seg(left3, 15135743), new Seg(mid3, 15135743), new Seg(" + " + Math.round(bonus.crit * 100.0f) + "%", -10882834), new Seg(")", 15135743));
            }
            int barX2 = x + 8;
            int barW2 = panelW - 16;
            int barH2 = 6;
            BlueprintOverlay.drawPairBar(g, barX2, (lineY += lineStepSmall) + 2, barW2, barH2, kbPct, -11056302, -10882834, 1076116579, -2130706433);
            int rPct = Math.round(srBase.tReach * 100.0f);
            int dPct = 100 - rPct;
            BlueprintOverlay.drawScaledString(g, "Reach \u2194 Durability", x + 8, lineY += barH2 + 6, -1641473, FONT_SCALE);
            BlueprintOverlay.drawScaledString(g, String.format(Locale.ROOT, "Reach: %.2f (%d%%)", Float.valueOf(srBase.reach), rPct), x + 8, lineY += lineStepSmall, 15135743, FONT_SCALE);
            lineY += lineStepSmall;
            int baseDur = srBase.durability;
            int finalDur = Math.max(1, Math.round((float)baseDur * (1.0f + bonus.durability)));
            String left4 = String.format(Locale.ROOT, "Durability: %d (", finalDur);
            String mid4 = dPct + "%";
            if (bonus.durability <= 0.0f) {
                BlueprintOverlay.drawScaledString(g, left4 + mid4 + ")", x + 8, lineY, 15135743, FONT_SCALE);
            } else {
                BlueprintOverlay.drawScaledSegments(g, x + 8, lineY, FONT_SCALE, new Seg(left4, 15135743), new Seg(mid4, 15135743), new Seg(" + " + Math.round(bonus.durability * 100.0f) + "%", -4143153), new Seg(")", 15135743));
            }
            int barX3 = x + 8;
            int barW3 = panelW - 16;
            int barH3 = 6;
            BlueprintOverlay.drawPairBar(g, barX3, (lineY += lineStepSmall) + 2, barW3, barH3, rPct, 15135743, -4143153, 1076116579, -2130706433);
            lineY += barH3 + 6;
            int previewPad = 8;
            int previewX = x + previewPad;
            int previewY = lineY += PREVIEW_MARGIN_TOP;
            int previewW = panelW - previewPad * 2;
            int previewH = Math.max(110, panelH - (previewY - y) - 8);
            BlueprintPreviewRenderer.INSTANCE.render(g, previewX, previewY, previewW, previewH, payload, snap.thicknessL, snap.thicknessM, snap.thicknessR);
            int gapBelow = 12;
            int headRectX = x;
            int headRectY = y + panelH + gapBelow;
            int headRectW = panelW;
            int availableH = e.getScreen().height - headRectY - 12;
            int headRectH = Math.max(0, Math.min(220, availableH));
            if (headRectH >= 32) {
                BlueprintCompanionHead.render(g, headRectX, headRectY, headRectW, headRectH);
            }
        }
        catch (Throwable t) {
            Constants.LOG.debug("[WeaponCraft] BlueprintOverlay failed to render: {}", (Object)t.toString());
        }
    }

    private static void drawPanel(GuiGraphics g, int x, int y, int w, int h) {
        RenderSystem.enableBlend();
        int texW = 250;
        int texH = 400;
        g.blit(TEX_OVERLAY, x, y, 0.0f, 0.0f, 250, 400, 250, 400);
    }

    private static void drawPairBar(GuiGraphics g, int x, int y, int w, int h, int pctA, int colorA, int colorB, int bgColor, int frameColor) {
        g.fill(x, y, x + w, y + h, bgColor);
        int leftW = Math.max(0, Math.min(w, w * pctA / 100));
        if (leftW > 0) {
            g.fill(x, y, x + leftW, y + h, colorA);
        }
        int rightX = x + leftW;
        int rightW = w - leftW;
        if (rightW > 0) {
            g.fill(rightX, y, rightX + rightW, y + h, colorB);
        }
        g.fill(x, y, x + w, y + 1, frameColor);
        g.fill(x, y + h - 1, x + w, y + h, frameColor);
        g.fill(x, y, x + 1, y + h, frameColor);
        g.fill(x + w - 1, y, x + w, y + h, frameColor);
    }

    private static void drawScaledString(GuiGraphics g, String text, int x, int y, int color, float scale) {
        Font font = Minecraft.getInstance().font;
        PoseStack pose = g.pose();
        pose.pushPose();
        pose.translate((float)x, (float)y, 0.0f);
        pose.scale(scale, scale, 1.0f);
        g.drawString(font, text, 0, 0, color, false);
        pose.popPose();
    }

    private static String fmt(float f) {
        return (double)Math.abs(f - (float)Math.round(f)) < 0.001 ? Integer.toString(Math.round(f)) : String.format(Locale.ROOT, "%.1f", Float.valueOf(f));
    }

    private static BlueprintSnapshot snapshotFromScreen(BlueprintScreen s) throws Exception {
        if (fGRID_W == null) {
            fGRID_W = BlueprintOverlay.get(((Object)((Object)s)).getClass(), "GRID_W");
            fGRID_H = BlueprintOverlay.get(((Object)((Object)s)).getClass(), "GRID_H");
            fDetail = BlueprintOverlay.get(((Object)((Object)s)).getClass(), "detailScale");
            fFineL = BlueprintOverlay.get(((Object)((Object)s)).getClass(), "fineL");
            fFineM = BlueprintOverlay.get(((Object)((Object)s)).getClass(), "fineM");
            fFineR = BlueprintOverlay.get(((Object)((Object)s)).getClass(), "fineR");
            fAX = BlueprintOverlay.get(((Object)((Object)s)).getClass(), "anchorXFine");
            fAY = BlueprintOverlay.get(((Object)((Object)s)).getClass(), "anchorYFine");
            fCustomName = BlueprintOverlay.get(((Object)((Object)s)).getClass(), "customName");
            fThickL = BlueprintOverlay.get(((Object)((Object)s)).getClass(), "thicknessL");
            fThickM = BlueprintOverlay.get(((Object)((Object)s)).getClass(), "thicknessM");
            fThickR = BlueprintOverlay.get(((Object)((Object)s)).getClass(), "thicknessR");
        }
        int gridW = (Integer)fGRID_W.get((Object)s);
        int gridH = (Integer)fGRID_H.get((Object)s);
        int viewDs = (Integer)fDetail.get((Object)s);
        byte[][] fineL = (byte[][])fFineL.get((Object)s);
        byte[][] fineM = (byte[][])fFineM.get((Object)s);
        byte[][] fineR = (byte[][])fFineR.get((Object)s);
        int ax = (Integer)fAX.get((Object)s);
        int ay = (Integer)fAY.get((Object)s);
        String custom = (String)fCustomName.get((Object)s);
        float tL = ((Float)fThickL.get((Object)s)).floatValue();
        float tM = ((Float)fThickM.get((Object)s)).floatValue();
        float tR = ((Float)fThickR.get((Object)s)).floatValue();
        if (fineM == null || fineM.length == 0 || fineM[0] == null) {
            return null;
        }
        return new BlueprintSnapshot(gridW, gridH, viewDs, fineL, fineM, fineR, ax, ay, custom, tL, tM, tR);
    }

    private static BitmapPayload payloadFromSnapshotWithThickness(BlueprintSnapshot s) {
        int inferredDsW = s.fineM != null && s.fineM[0] != null && s.gridW > 0 ? Math.max(1, s.fineM[0].length / s.gridW) : Math.max(1, s.viewDetailScale);
        int inferredDsH = s.fineM != null && s.gridH > 0 ? Math.max(1, s.fineM.length / s.gridH) : Math.max(1, s.viewDetailScale);
        int ds = inferredDsW == inferredDsH ? inferredDsW : Math.max(1, s.viewDetailScale);
        int fw = s.gridW * ds;
        int fh = s.gridH * ds;
        CompoundTag bp = new CompoundTag();
        bp.putInt("w", s.gridW);
        bp.putInt("h", s.gridH);
        bp.putInt("detailScale", ds);
        if (s.anchorXFine >= 0) {
            bp.putInt("ax", s.anchorXFine);
        }
        if (s.anchorYFine >= 0) {
            bp.putInt("ay", s.anchorYFine);
        }
        bp.put("materialsL", (Tag)BlueprintOverlay.writeRowsBytes(s.fineL, fw, fh));
        bp.put("materialsM", (Tag)BlueprintOverlay.writeRowsBytes(s.fineM, fw, fh));
        bp.put("materialsR", (Tag)BlueprintOverlay.writeRowsBytes(s.fineR, fw, fh));
        bp.putFloat("thicknessL", s.thicknessL);
        bp.putFloat("thicknessM", s.thicknessM);
        bp.putFloat("thicknessR", s.thicknessR);
        return BitmapPayload.fromNBT(bp);
    }

    private static ListTag writeRowsBytes(byte[][] grid, int fw, int fh) {
        ListTag rows = new ListTag();
        for (int y = 0; y < fh; ++y) {
            CompoundTag row = new CompoundTag();
            byte[] arr = new byte[fw];
            if (grid != null && y < grid.length && grid[y] != null) {
                System.arraycopy(grid[y], 0, arr, 0, Math.min(grid[y].length, fw));
            }
            row.put("r", (Tag)new ByteArrayTag(arr));
            rows.add((Object)row);
        }
        return rows;
    }

    private static Field get(Class<?> c, String name) throws Exception {
        Field f = c.getDeclaredField(name);
        f.setAccessible(true);
        return f;
    }

    private static void drawScaledSegments(GuiGraphics g, int x, int y, float scale, Seg ... parts) {
        Font font = Minecraft.getInstance().font;
        PoseStack pose = g.pose();
        pose.pushPose();
        pose.translate((float)x, (float)y, 0.0f);
        pose.scale(scale, scale, 1.0f);
        int pen = 0;
        for (Seg s : parts) {
            g.drawString(font, s.text, pen, 0, s.color, false);
            pen += font.width(s.text);
        }
        pose.popPose();
    }

    private static DisplayBonus computeDisplayBonus(BitmapPayload p, float tL, float tM, float tR) {
        int[] coarseEff = BlueprintOverlay.countEffectiveCoarseCellsByMaterial(p, tL, tM, tR);
        float k = Math.max(0.0f, ClientConfigMirror.bonusDiminishK);
        float linearFrac = Math.max(0.0f, Math.min(1.0f, ClientConfigMirror.bonusLinearFrac));
        float c0Gold = BlueprintOverlay.kneeCells(linearFrac, ClientConfigMirror.bonusCapSpeed, ClientConfigMirror.bonusPerCellSpeedGold);
        float c0Dia = BlueprintOverlay.kneeCells(linearFrac, ClientConfigMirror.bonusCapCrit, ClientConfigMirror.bonusPerCellCritDiamond);
        float c0NethD = BlueprintOverlay.kneeCells(linearFrac, ClientConfigMirror.bonusCapDamage, ClientConfigMirror.bonusPerCellDamageNetherite);
        float c0NethK = BlueprintOverlay.kneeCells(linearFrac, ClientConfigMirror.bonusCapKnockback, ClientConfigMirror.bonusPerCellKnockbackNetherite);
        float c0Iron = BlueprintOverlay.kneeCells(linearFrac, ClientConfigMirror.bonusCapDurability, ClientConfigMirror.bonusPerCellDurabilityIron);
        float spd = BlueprintOverlay.bonusPiecewise(coarseEff[2], ClientConfigMirror.bonusPerCellSpeedGold, ClientConfigMirror.bonusCapSpeed, k, c0Gold);
        float crt = BlueprintOverlay.bonusPiecewise(coarseEff[3], ClientConfigMirror.bonusPerCellCritDiamond, ClientConfigMirror.bonusCapCrit, k, c0Dia);
        float dmg = BlueprintOverlay.bonusPiecewise(coarseEff[4], ClientConfigMirror.bonusPerCellDamageNetherite, ClientConfigMirror.bonusCapDamage, k, c0NethD);
        float kb = BlueprintOverlay.bonusPiecewise(coarseEff[4], ClientConfigMirror.bonusPerCellKnockbackNetherite, ClientConfigMirror.bonusCapKnockback, k, c0NethK);
        float dur = BlueprintOverlay.bonusPiecewise(coarseEff[1], ClientConfigMirror.bonusPerCellDurabilityIron, ClientConfigMirror.bonusCapDurability, k, c0Iron);
        return new DisplayBonus(dmg, spd, kb, crt, dur);
    }

    private static int[] countEffectiveCoarseCellsByMaterial(BitmapPayload p, float tL, float tM, float tR) {
        float[] eff = new float[5];
        int ds = p.detailScale;
        BiConsumer<byte[][], Float> addLayer = (layer, scale) -> {
            if (layer == null || scale == null || scale.floatValue() <= 0.0f) {
                return;
            }
            for (int cy = 0; cy < p.height; ++cy) {
                for (int cx = 0; cx < p.width; ++cx) {
                    int mat = BlueprintOverlay.majorityMaterialInBlock(layer, cx * ds, cy * ds, ds);
                    if (mat < 1 || mat > 4) continue;
                    int n = mat;
                    eff[n] = eff[n] + scale.floatValue();
                }
            }
        };
        addLayer.accept(p.layerL, Float.valueOf(tL));
        addLayer.accept(p.layerM, Float.valueOf(tM));
        addLayer.accept(p.layerR, Float.valueOf(tR));
        if (p.layerL == null && p.layerM == null && p.layerR == null) {
            for (int cy = 0; cy < p.height; ++cy) {
                for (int cx = 0; cx < p.width; ++cx) {
                    int mat = BlueprintOverlay.majorityMaterialInBlock(p.fineMaterials, cx * ds, cy * ds, ds);
                    if (mat < 1 || mat > 4) continue;
                    int n = mat;
                    eff[n] = eff[n] + tM;
                }
            }
        }
        int[] out = new int[5];
        for (int m = 1; m <= 4; ++m) {
            out[m] = Math.round(eff[m]);
        }
        return out;
    }

    private static int majorityMaterialInBlock(byte[][] fine, int x0, int y0, int ds) {
        int m;
        int[] c = new int[5];
        for (int dy = 0; dy < ds; ++dy) {
            for (int dx = 0; dx < ds; ++dx) {
                m = fine[y0 + dy][x0 + dx] & 0xFF;
                if (m < 1 || m > 4) continue;
                int n = m;
                c[n] = c[n] + 1;
            }
        }
        int best = 0;
        int bestCount = 0;
        for (m = 1; m <= 4; ++m) {
            if (c[m] <= bestCount) continue;
            bestCount = c[m];
            best = m;
        }
        return bestCount == 0 ? 0 : best;
    }

    private static float bonusPiecewise(int cells, float perCell, float cap, float k, float c0Cells) {
        if (cells <= 0 || perCell <= 0.0f || cap <= 0.0f) {
            return 0.0f;
        }
        float c0 = Math.max(0.0f, c0Cells);
        float b0 = perCell * Math.min((float)cells, c0);
        if (b0 >= cap) {
            return cap;
        }
        if ((float)cells <= c0 || k <= 0.0f) {
            return Math.min(b0, cap);
        }
        float remCap = cap - b0;
        if (remCap <= 0.0f) {
            return cap;
        }
        float tail = (float)((double)cap * (1.0 - Math.exp(-((double)k) * (double)perCell * (double)((float)cells - c0) / (double)remCap)));
        float out = b0 + Math.min(tail, remCap);
        return out > cap ? cap : Math.max(out, 0.0f);
    }

    private static float kneeCells(float linearFrac, float cap, float perCell) {
        if (linearFrac <= 0.0f || cap <= 0.0f || perCell <= 0.0f) {
            return 0.0f;
        }
        return linearFrac * cap / perCell;
    }

    private record BlueprintSnapshot(int gridW, int gridH, int viewDetailScale, byte[][] fineL, byte[][] fineM, byte[][] fineR, int anchorXFine, int anchorYFine, String customName, float thicknessL, float thicknessM, float thicknessR) {
    }

    private record DisplayBonus(float damage, float speed, float knockback, float crit, float durability) {
    }

    private static final class Seg {
        final String text;
        final int color;

        Seg(String t, int c) {
            this.text = t;
            this.color = c;
        }
    }
}

