/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.blueprint.client.preview;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.z2six.weaponcraft.content.ModItems;
import org.z2six.weaponcraft.features.rendering.util.BitmapPayload;

public final class BlueprintPreviewRenderer {
    public static final BlueprintPreviewRenderer INSTANCE = new BlueprintPreviewRenderer();
    private static final boolean DEBUG = false;
    private static final float DEFAULT_YAW = 114.5f;
    private static final float DEFAULT_PITCH = 297.19f;
    private static final float DEFAULT_ZOOM = 20.0f;
    private static final float DEFAULT_PAN_X = 46.0f;
    private static final float DEFAULT_PAN_Y = 43.0f;
    private float yawDeg = 114.5f;
    private float pitchDeg = 297.19f;
    private DragMode dragMode = DragMode.NONE;
    private int lastMouseX;
    private int lastMouseY;
    private float panX = 46.0f;
    private float panY = 43.0f;
    private float zoom = 20.0f;
    private static final float MIN_ZOOM = 0.05f;
    private static final float MAX_ZOOM = 1000.0f;
    private ItemStack cachedStack = ItemStack.EMPTY;
    private int cachedHash = 0;
    private int bx;
    private int by;
    private int bw;
    private int bh;

    private BlueprintPreviewRenderer() {
    }

    public void render(GuiGraphics g, int x, int y, int w, int h, BitmapPayload payload) {
        this.render(g, x, y, w, h, payload, 0.5f, 1.0f, 0.5f);
    }

    public void render(GuiGraphics g, int x, int y, int w, int h, BitmapPayload payload, float thicknessL, float thicknessM, float thicknessR) {
        this.bx = x;
        this.by = y;
        this.bw = w;
        this.bh = h;
        this.ensureStackUpToDate(payload, thicknessL, thicknessM, thicknessR);
        if (this.cachedStack.isEmpty()) {
            return;
        }
        g.enableScissor(x, y, x + w, y + h);
        Minecraft mc = Minecraft.getInstance();
        ItemRenderer ir = mc.getItemRenderer();
        MultiBufferSource.BufferSource buf = g.bufferSource();
        PoseStack pose = g.pose();
        pose.pushPose();
        float cx = (float)x + (float)w / 2.0f + this.panX;
        float cy = (float)y + (float)h / 2.0f + this.panY;
        pose.translate(cx, cy, 250.0f);
        float box = Math.min(w, h);
        float base = box * 0.9f / 16.0f;
        float s = base * this.zoom;
        pose.scale(s, -s, s);
        pose.mulPose(Axis.YP.rotationDegrees(this.yawDeg));
        pose.mulPose(Axis.XP.rotationDegrees(this.pitchDeg));
        BakedModel model = ir.getModel(this.cachedStack, null, null, 0);
        RenderSystem.enableBlend();
        ir.render(this.cachedStack, ItemDisplayContext.NONE, false, pose, (MultiBufferSource)buf, 0xF000F0, OverlayTexture.NO_OVERLAY, model);
        g.flush();
        pose.popPose();
        g.disableScissor();
    }

    public boolean mouseClicked(double mx, double my, int button) {
        if (!this.insideBounds(mx, my)) {
            return false;
        }
        if (button == 0) {
            this.dragMode = DragMode.ROTATE;
        } else if (button == 1) {
            this.dragMode = DragMode.PAN;
        } else {
            return false;
        }
        this.lastMouseX = (int)mx;
        this.lastMouseY = (int)my;
        return true;
    }

    public boolean mouseReleased(double mx, double my, int button) {
        if (this.dragMode == DragMode.NONE) {
            return this.insideBounds(mx, my);
        }
        if (button == 0 && this.dragMode == DragMode.ROTATE || button == 1 && this.dragMode == DragMode.PAN) {
            this.dragMode = DragMode.NONE;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mx, double my, int button, double dx, double dy) {
        if (this.dragMode == DragMode.NONE) {
            return false;
        }
        if (this.dragMode == DragMode.ROTATE && button == 0) {
            float sens = 0.5f;
            this.yawDeg = BlueprintPreviewRenderer.wrapDeg(this.yawDeg + (float)(dx * (double)sens));
            this.pitchDeg = BlueprintPreviewRenderer.wrapDeg(this.pitchDeg + (float)(-dy * (double)sens));
            this.lastMouseX = (int)mx;
            this.lastMouseY = (int)my;
            return true;
        }
        if (this.dragMode == DragMode.PAN && button == 1) {
            this.panX += (float)dx;
            this.panY += (float)dy;
            this.lastMouseX = (int)mx;
            this.lastMouseY = (int)my;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mx, double my, double dx, double dy) {
        if (!this.insideBounds(mx, my) || dy == 0.0) {
            return false;
        }
        float factor = dy > 0.0 ? 1.1f : 0.9f;
        this.zoom *= factor;
        if (this.zoom < 0.05f) {
            this.zoom = 0.05f;
        }
        if (this.zoom > 1000.0f) {
            this.zoom = 1000.0f;
        }
        return true;
    }

    private boolean insideBounds(double mx, double my) {
        return mx >= (double)this.bx && mx < (double)(this.bx + this.bw) && my >= (double)this.by && my < (double)(this.by + this.bh);
    }

    private static float wrapDeg(float d) {
        return (d %= 360.0f) < 0.0f ? d + 360.0f : d;
    }

    private void ensureStackUpToDate(BitmapPayload p, float tL, float tM, float tR) {
        int hash = BlueprintPreviewRenderer.hashPayloadStable(p, tL, tM, tR);
        if (this.cachedStack.isEmpty() || hash != this.cachedHash) {
            this.cachedHash = hash;
            this.cachedStack = new ItemStack((ItemLike)ModItems.FORGED_WEAPON.get());
            CompoundTag root = new CompoundTag();
            CompoundTag bp = p.toNBT();
            bp.putFloat("thicknessL", tL);
            bp.putFloat("thicknessM", tM);
            bp.putFloat("thicknessR", tR);
            root.put("WeaponBlueprint", (Tag)bp);
            this.cachedStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)root));
        }
    }

    private static int hashPayloadStable(BitmapPayload p, float tL, float tM, float tR) {
        CompoundTag tag = p.toNBT();
        tag.putFloat("thicknessL", tL);
        tag.putFloat("thicknessM", tM);
        tag.putFloat("thicknessR", tR);
        String s = tag.toString();
        return s.hashCode();
    }

    private static enum DragMode {
        NONE,
        ROTATE,
        PAN;

    }
}

