/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.blueprint.client.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import org.z2six.weaponcraft.features.net.client.ClientConfigMirror;

public final class MaterialTooltip {
    private static final int RGB_IRON = 12634063;
    private static final int RGB_GOLD = 15779912;
    private static final int RGB_DIAMOND = 5894382;
    private static final int RGB_NETHERITE = 5720914;

    private MaterialTooltip() {
    }

    public static List<Component> make(int matIdx) {
        ArrayList<Component> out = new ArrayList<Component>(4);
        String name = MaterialTooltip.materialName(matIdx);
        TextColor titleColor = TextColor.fromRgb((int)MaterialTooltip.colorForTitle(matIdx));
        out.add((Component)Component.literal((String)name).withStyle(Style.EMPTY.withColor(titleColor).withBold(Boolean.valueOf(true))));
        float weight = ClientConfigMirror.getMaterialWeight(matIdx);
        out.add(MaterialTooltip.lineKV("Weight", MaterialTooltip.fmtFloat(weight)));
        float costMul = ClientConfigMirror.getCostMul(matIdx);
        out.add(MaterialTooltip.lineKV("Cost", MaterialTooltip.fmtFloat(costMul) + " x weight"));
        out.add(MaterialTooltip.lineKV("Bonus", MaterialTooltip.bonusText(matIdx)));
        return out;
    }

    private static String materialName(int m) {
        switch (m) {
            case 1: {
                return "Iron";
            }
            case 2: {
                return "Gold";
            }
            case 3: {
                return "Diamond";
            }
            case 4: {
                return "Netherite";
            }
        }
        return "Unknown";
    }

    private static int colorForTitle(int m) {
        switch (m) {
            case 1: {
                return 12634063;
            }
            case 2: {
                return 15779912;
            }
            case 3: {
                return 5894382;
            }
            case 4: {
                return 5720914;
            }
        }
        return 0xFFFFFF;
    }

    private static String bonusText(int m) {
        switch (m) {
            case 1: {
                float per = ClientConfigMirror.bonusPerCellDurabilityIron;
                float cap = ClientConfigMirror.bonusCapDurability;
                return "+%s Durability per cell (cap %s)".formatted(MaterialTooltip.fmtPct(per), MaterialTooltip.fmtPct(cap));
            }
            case 2: {
                float per = ClientConfigMirror.bonusPerCellSpeedGold;
                float cap = ClientConfigMirror.bonusCapSpeed;
                return "+%s Speed per cell (cap %s)".formatted(MaterialTooltip.fmtPct(per), MaterialTooltip.fmtPct(cap));
            }
            case 3: {
                float per = ClientConfigMirror.bonusPerCellCritDiamond;
                float cap = ClientConfigMirror.bonusCapCrit;
                return "+%s Crit Chance per cell (cap %s)".formatted(MaterialTooltip.fmtPct(per), MaterialTooltip.fmtPct(cap));
            }
            case 4: {
                float perKB = ClientConfigMirror.bonusPerCellKnockbackNetherite;
                float perDMG = ClientConfigMirror.bonusPerCellDamageNetherite;
                float cap = Math.min(ClientConfigMirror.bonusCapKnockback, ClientConfigMirror.bonusCapDamage);
                return "+%s Knockback | +%s Damage per cell (cap %s)".formatted(MaterialTooltip.fmtPct(perKB), MaterialTooltip.fmtPct(perDMG), MaterialTooltip.fmtPct(cap));
            }
        }
        return "\u2014";
    }

    private static Component lineKV(String key, String valueRight) {
        return Component.literal((String)(key + ": ")).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)valueRight).withStyle(ChatFormatting.WHITE));
    }

    private static String fmtFloat(float v) {
        return String.format(Locale.ROOT, "%.3f", Float.valueOf(v)).replaceAll("(\\.\\d*[1-9])0+$", "$1").replaceAll("\\.0+$", "");
    }

    private static String fmtPct(float f) {
        return String.format(Locale.ROOT, "%.1f%%", Float.valueOf(f * 100.0f));
    }
}

