/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.blueprint.client.ui;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TexturedButton
extends AbstractButton {
    private final Consumer<TexturedButton> onPress;
    private final ResourceLocation texNormal;
    private final ResourceLocation texHover;
    private final int texW;
    private final int texH;

    public TexturedButton(int x, int y, int width, int height, Component message, Consumer<TexturedButton> onPress, ResourceLocation texNormal, ResourceLocation texHover, int texW, int texH) {
        super(x, y, width, height, message);
        this.onPress = onPress;
        this.texNormal = texNormal;
        this.texHover = texHover;
        this.texW = texW;
        this.texH = texH;
    }

    public void onPress() {
        if (this.onPress != null) {
            this.onPress.accept(this);
        }
    }

    protected void renderWidget(GuiGraphics g, int mouseX, int mouseY, float partialTicks) {
        boolean hoverish = this.isHoveredOrFocused() && this.active && this.visible;
        ResourceLocation tex = hoverish ? this.texHover : this.texNormal;
        g.blit(tex, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.texW, this.texH);
        int color = !this.active ? -5592406 : (hoverish ? -1 : -1052689);
        Font font = Minecraft.getInstance().font;
        Component component = this.getMessage();
        int n = this.getX() + this.width / 2;
        int n2 = this.getY();
        Objects.requireNonNull(font);
        g.drawCenteredString(font, component, n, n2 + (this.height - 9) / 2, color);
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
        this.defaultButtonNarrationText(output);
    }
}

