/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.blueprint.client.ui;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class VerticalSliderWidget
extends AbstractWidget {
    private float min;
    private float max;
    private float value;
    private final Function<Float, Component> valueFormatter;
    private boolean dragging = false;

    public VerticalSliderWidget(int x, int y, int width, int height, float min, float max, float initial, Function<Float, Component> valueFormatter) {
        super(x, y, width, height, (Component)Component.empty());
        this.min = min;
        this.max = max;
        this.value = VerticalSliderWidget.clamp(initial, min, max);
        this.valueFormatter = Objects.requireNonNullElseGet(valueFormatter, () -> v -> Component.literal((String)String.format(Locale.ROOT, "%.2f", v)));
    }

    public float getValue() {
        return this.value;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public void setRange(float min, float max) {
        this.min = min;
        this.max = max;
        this.value = VerticalSliderWidget.clamp(this.value, min, max);
    }

    public void setValue(float v) {
        this.value = VerticalSliderWidget.clamp(v, this.min, this.max);
    }

    protected void renderWidget(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int railX0 = this.getX() + this.width / 2 - 2;
        int railX1 = railX0 + 4;
        int railY0 = this.getY();
        int railY1 = this.getY() + this.height;
        g.fill(railX0 - 4, railY0, railX1 + 4, railY1, 0x55000000);
        g.fill(railX0, railY0, railX1, railY1, -14538186);
        float t = this.max <= this.min ? 0.0f : (this.value - this.min) / (this.max - this.min);
        t = VerticalSliderWidget.clamp01(t);
        int knobH = 10;
        int knobW = this.width;
        int trackH = this.height - knobH;
        int knobY = railY0 + (int)((1.0f - t) * (float)trackH);
        int x0 = this.getX();
        int y0 = knobY;
        int x1 = this.getX() + knobW;
        int y1 = knobY + knobH;
        g.fill(x0, y0, x1, y1, this.isFocused() || this.isHovered() ? -14984039 : -16044461);
        int sel = -11718;
        g.fill(x0, y0, x1, y0 + 1, sel);
        g.fill(x0, y1 - 1, x1, y1, sel);
        g.fill(x0, y0, x0 + 1, y1, sel);
        g.fill(x1 - 1, y0, x1, y1, sel);
        Component label = this.valueFormatter.apply(Float.valueOf(this.value));
        int lw = Minecraft.getInstance().font.width(label.getString());
        Objects.requireNonNull(Minecraft.getInstance().font);
        int lh = 9;
        int cx = x0 + (knobW - lw) / 2;
        int cy = y0 + (knobH - lh) / 2;
        g.drawString(Minecraft.getInstance().font, label, cx, cy, -1);
    }

    public void onClick(double mouseX, double mouseY) {
        this.dragging = true;
        this.updateFromMouse(mouseY);
    }

    public void onRelease(double mouseX, double mouseY) {
        this.dragging = false;
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.dragging) {
            this.updateFromMouse(mouseY);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double dx, double dy) {
        if (!this.isHovered) {
            return false;
        }
        float delta = (float)dy * (this.max - this.min) * 0.02f;
        this.setValue(this.value + delta);
        return true;
    }

    private void updateFromMouse(double mouseY) {
        int knobH = 10;
        int trackH = this.height - knobH;
        int railY0 = this.getY();
        float t = VerticalSliderWidget.clamp01((float)(((double)(railY0 + trackH) - (mouseY - (double)railY0)) / (double)trackH));
        float v = this.min + t * (this.max - this.min);
        this.setValue(v);
    }

    protected void updateWidgetNarration(NarrationElementOutput out) {
        out.add(NarratedElementType.TITLE, this.getMessage());
        out.add(NarratedElementType.TITLE, this.valueFormatter.apply(Float.valueOf(this.value)));
    }

    private static float clamp(float v, float a, float b) {
        return v < a ? a : (v > b ? b : v);
    }

    private static float clamp01(float v) {
        return VerticalSliderWidget.clamp(v, 0.0f, 1.0f);
    }
}

