/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.blueprint.stats;

import org.z2six.weaponcraft.config.feature.BalanceConfig;
import org.z2six.weaponcraft.features.rendering.util.BitmapPayload;

public final class BlueprintMetrics {
    private BlueprintMetrics() {
    }

    public static int countFilledCoarse(BitmapPayload p) {
        int count = 0;
        for (int cy = 0; cy < p.height; ++cy) {
            for (int cx = 0; cx < p.width; ++cx) {
                if (!BlueprintMetrics.anyFineInBlock(p, cx, cy)) continue;
                ++count;
            }
        }
        return count;
    }

    public static int countFilledFine(BitmapPayload p) {
        int ds = p.detailScale;
        int fh = p.height * ds;
        int fw = p.width * ds;
        int filled = 0;
        for (int y = 0; y < fh; ++y) {
            byte[] row = p.fineMaterials[y];
            for (int x = 0; x < fw; ++x) {
                if ((row[x] & 0xFF) == 0) continue;
                ++filled;
            }
        }
        return filled;
    }

    public static float modelSizeUnits(BitmapPayload p) {
        int filledFine = BlueprintMetrics.countFilledFine(p);
        float scale = BlueprintMetrics.perFineWeight(p.detailScale);
        return (float)filledFine * scale;
    }

    public static CoarseBox coarseBoundingBox(BitmapPayload p) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = -1;
        int maxY = -1;
        for (int cy = 0; cy < p.height; ++cy) {
            for (int cx = 0; cx < p.width; ++cx) {
                if (!BlueprintMetrics.anyFineInBlock(p, cx, cy)) continue;
                if (cx < minX) {
                    minX = cx;
                }
                if (cy < minY) {
                    minY = cy;
                }
                if (cx > maxX) {
                    maxX = cx;
                }
                if (cy <= maxY) continue;
                maxY = cy;
            }
        }
        return new CoarseBox(minX, minY, maxX, maxY);
    }

    public static float mass(BitmapPayload p, BalanceConfig c) {
        int ds = p.detailScale;
        int fh = p.height * ds;
        int fw = p.width * ds;
        float fineScale = BlueprintMetrics.perFineWeight(ds);
        if (p.layerL != null || p.layerM != null || p.layerR != null) {
            float total = 0.0f;
            if (p.layerL != null) {
                total += BlueprintMetrics.layerMass(p.layerL, fineScale, c) * BlueprintMetrics.safeNonNeg(p.thicknessL);
            }
            if (p.layerM != null) {
                total += BlueprintMetrics.layerMass(p.layerM, fineScale, c) * BlueprintMetrics.safeNonNeg(p.thicknessM);
            }
            if (p.layerR != null) {
                total += BlueprintMetrics.layerMass(p.layerR, fineScale, c) * BlueprintMetrics.safeNonNeg(p.thicknessR);
            }
            return total;
        }
        float m = 0.0f;
        for (int y = 0; y < fh; ++y) {
            byte[] row = p.fineMaterials[y];
            for (int x = 0; x < fw; ++x) {
                m += BlueprintMetrics.materialWeight(row[x] & 0xFF, c) * fineScale;
            }
        }
        return m;
    }

    public static float density(BitmapPayload p) {
        int filled = BlueprintMetrics.countFilledCoarse(p);
        if (filled == 0) {
            return 0.0f;
        }
        CoarseBox box = BlueprintMetrics.coarseBoundingBox(p);
        int area = Math.max(1, box.area());
        return BlueprintMetrics.clamp01((float)filled / (float)area);
    }

    public static float thicknessWeightedBulk01(BitmapPayload p, BalanceConfig c) {
        int S_REF = 10;
        int H = p.height;
        int W = p.width;
        if (H == 0 || W == 0) {
            return 0.0f;
        }
        int ds = p.detailScale;
        boolean hasLayers = p.layerL != null || p.layerM != null || p.layerR != null;
        float[][] D = new float[H][W];
        if (hasLayers) {
            for (cy = 0; cy < H; ++cy) {
                for (cx = 0; cx < W; ++cx) {
                    float d = 0.0f;
                    if (p.layerL != null && BlueprintMetrics.anyFineInBlock(p.layerL, cx, cy, ds)) {
                        d += Math.max(0.0f, p.thicknessL);
                    }
                    if (p.layerM != null && BlueprintMetrics.anyFineInBlock(p.layerM, cx, cy, ds)) {
                        d += Math.max(0.0f, p.thicknessM);
                    }
                    if (p.layerR != null && BlueprintMetrics.anyFineInBlock(p.layerR, cx, cy, ds)) {
                        d += Math.max(0.0f, p.thicknessR);
                    }
                    D[cy][cx] = d;
                }
            }
        } else {
            for (cy = 0; cy < H; ++cy) {
                for (cx = 0; cx < W; ++cx) {
                    D[cy][cx] = BlueprintMetrics.anyFineInBlock(p, cx, cy) ? 1.0f : 0.0f;
                }
            }
        }
        float[][] ps = new float[H + 1][W + 1];
        for (int y = 0; y < H; ++y) {
            float rowSum = 0.0f;
            for (int x = 0; x < W; ++x) {
                ps[y + 1][x + 1] = ps[y][x + 1] + (rowSum += D[y][x]);
            }
        }
        int Smax = Math.min(10, Math.min(W, H));
        float bestVol = 0.0f;
        for (int s = 1; s <= Smax; ++s) {
            int yEnd = H - s;
            int xEnd = W - s;
            for (int y0 = 0; y0 <= yEnd; ++y0) {
                int y1 = y0 + s;
                for (int x0 = 0; x0 <= xEnd; ++x0) {
                    int x1 = x0 + s;
                    float vol = BlueprintMetrics.rectSum(ps, x0, y0, x1, y1);
                    if (!(vol > bestVol)) continue;
                    bestVol = vol;
                }
            }
        }
        float dRef = hasLayers ? Math.max(0.0f, c.maxCellThicknessL) + Math.max(0.0f, c.maxCellThicknessM) + Math.max(0.0f, c.maxCellThicknessR) : 1.0f;
        float ref = 100.0f * Math.max(1.0E-6f, dRef);
        float t = bestVol / ref;
        return t < 0.0f ? 0.0f : (t > 1.0f ? 1.0f : t);
    }

    private static boolean anyFineInBlock(byte[][] fineLayer, int cx, int cy, int ds) {
        if (fineLayer == null) {
            return false;
        }
        int x0 = cx * ds;
        int y0 = cy * ds;
        for (int dy = 0; dy < ds; ++dy) {
            byte[] row = fineLayer[y0 + dy];
            for (int dx = 0; dx < ds; ++dx) {
                if ((row[x0 + dx] & 0xFF) == 0) continue;
                return true;
            }
        }
        return false;
    }

    private static float rectSum(float[][] ps, int x0, int y0, int x1, int y1) {
        return ps[y1][x1] - ps[y0][x1] - ps[y1][x0] + ps[y0][x0];
    }

    public static float edginess(BitmapPayload p) {
        int ds = p.detailScale;
        int fh = p.height * ds;
        int fw = p.width * ds;
        int filled = 0;
        int exposedEdges = 0;
        for (int y = 0; y < fh; ++y) {
            for (int x = 0; x < fw; ++x) {
                int mat = p.fineMaterials[y][x] & 0xFF;
                if (mat == 0) continue;
                ++filled;
                if (x - 1 < 0 || (p.fineMaterials[y][x - 1] & 0xFF) == 0) {
                    ++exposedEdges;
                }
                if (x + 1 >= fw || (p.fineMaterials[y][x + 1] & 0xFF) == 0) {
                    ++exposedEdges;
                }
                if (y - 1 < 0 || (p.fineMaterials[y - 1][x] & 0xFF) == 0) {
                    ++exposedEdges;
                }
                if (y + 1 < fh && (p.fineMaterials[y + 1][x] & 0xFF) != 0) continue;
                ++exposedEdges;
            }
        }
        if (filled == 0) {
            return 0.0f;
        }
        float perCell = (float)exposedEdges / (float)filled;
        return perCell * 0.5f;
    }

    public static boolean coarseFullyFilled(BitmapPayload p, int cx, int cy) {
        int ds = p.detailScale;
        int x0 = cx * ds;
        int y0 = cy * ds;
        for (int dy = 0; dy < ds; ++dy) {
            for (int dx = 0; dx < ds; ++dx) {
                if ((p.fineMaterials[y0 + dy][x0 + dx] & 0xFF) != 0) continue;
                return false;
            }
        }
        return true;
    }

    public static int largestSolidSquareCoarse(BitmapPayload p) {
        int H = p.height;
        int W = p.width;
        if (H == 0 || W == 0) {
            return 0;
        }
        boolean[][] full = new boolean[H][W];
        boolean any = false;
        for (int y = 0; y < H; ++y) {
            for (int x = 0; x < W; ++x) {
                boolean f;
                full[y][x] = f = BlueprintMetrics.coarseFullyFilled(p, x, y);
                if (!f) continue;
                any = true;
            }
        }
        if (!any) {
            return 0;
        }
        int[][] dp = new int[H][W];
        int best = 0;
        for (int y = 0; y < H; ++y) {
            for (int x = 0; x < W; ++x) {
                if (!full[y][x]) {
                    dp[y][x] = 0;
                } else if (x == 0 || y == 0) {
                    dp[y][x] = 1;
                } else {
                    int s;
                    int a = dp[y - 1][x];
                    int b = dp[y][x - 1];
                    int c = dp[y - 1][x - 1];
                    dp[y][x] = s = Math.min(a, Math.min(b, c)) + 1;
                }
                if (dp[y][x] <= best) continue;
                best = dp[y][x];
            }
        }
        return best;
    }

    public static int horizontalSpanCoarse(BitmapPayload p) {
        int minX = Integer.MAX_VALUE;
        int maxX = -1;
        for (int cy = 0; cy < p.height; ++cy) {
            for (int cx = 0; cx < p.width; ++cx) {
                if (!BlueprintMetrics.anyFineInBlock(p, cx, cy)) continue;
                if (cx < minX) {
                    minX = cx;
                }
                if (cx <= maxX) continue;
                maxX = cx;
            }
        }
        if (maxX < minX) {
            return 0;
        }
        return maxX - minX + 1;
    }

    public static int horizontalReachFromGripCoarse(BitmapPayload p) {
        if (p.anchorXFine < 0 || p.anchorYFine < 0) {
            return 0;
        }
        int ax = p.anchorXFine / Math.max(1, p.detailScale);
        int ay = p.anchorYFine / Math.max(1, p.detailScale);
        int boxMinX = BlueprintMetrics.clamp(ax - 2, 0, p.width - 1);
        int boxMaxX = BlueprintMetrics.clamp(ax + 1, 0, p.width - 1);
        int boxMinY = BlueprintMetrics.clamp(ay - 1, 0, p.height - 1);
        int boxMaxY = BlueprintMetrics.clamp(ay + 1, 0, p.height - 1);
        int leftmost = Integer.MAX_VALUE;
        int rightmost = -1;
        for (int cx = 0; cx < p.width; ++cx) {
            boolean any = false;
            for (int cy = 0; cy < p.height; ++cy) {
                if (!BlueprintMetrics.anyFineInBlock(p, cx, cy)) continue;
                any = true;
                break;
            }
            if (!any) continue;
            if (cx < leftmost) {
                leftmost = cx;
            }
            if (cx <= rightmost) continue;
            rightmost = cx;
        }
        if (rightmost < leftmost) {
            return 0;
        }
        int leftExtent = Math.max(0, boxMinX - leftmost);
        int rightExtent = Math.max(0, rightmost - boxMaxX);
        return Math.max(leftExtent, rightExtent);
    }

    private static float layerMass(byte[][] layer, float fineScale, BalanceConfig c) {
        if (layer == null) {
            return 0.0f;
        }
        float m = 0.0f;
        for (int y = 0; y < layer.length; ++y) {
            byte[] row = layer[y];
            for (int x = 0; x < row.length; ++x) {
                m += BlueprintMetrics.materialWeight(row[x] & 0xFF, c) * fineScale;
            }
        }
        return m;
    }

    private static float materialWeight(int mat, BalanceConfig c) {
        switch (mat) {
            case 1: {
                return c.weightIron;
            }
            case 2: {
                return c.weightGold;
            }
            case 3: {
                return c.weightDiamond;
            }
            case 4: {
                return c.weightNetherite;
            }
        }
        return 0.0f;
    }

    private static float safeNonNeg(float v) {
        return v < 0.0f ? 0.0f : v;
    }

    private static boolean anyFineInBlock(BitmapPayload p, int cx, int cy) {
        int ds = p.detailScale;
        int x0 = cx * ds;
        int y0 = cy * ds;
        for (int dy = 0; dy < ds; ++dy) {
            for (int dx = 0; dx < ds; ++dx) {
                if (p.fineMaterials[y0 + dy][x0 + dx] == 0) continue;
                return true;
            }
        }
        return false;
    }

    private static float perFineWeight(int ds) {
        if (ds <= 1) {
            return 1.0f;
        }
        return 1.0f / (float)(ds * ds);
    }

    private static float clamp01(float f) {
        return f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
    }

    private static int clamp(int v, int lo, int hi) {
        return v < lo ? lo : (v > hi ? hi : v);
    }

    public static final class CoarseBox {
        public final int minX;
        public final int minY;
        public final int maxX;
        public final int maxY;

        public CoarseBox(int minX, int minY, int maxX, int maxY) {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
        }

        public int area() {
            return (this.maxX - this.minX + 1) * (this.maxY - this.minY + 1);
        }

        public boolean valid() {
            return this.maxX >= this.minX && this.maxY >= this.minY;
        }
    }
}

