/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.blueprint.stats;

import java.util.HashMap;
import org.z2six.weaponcraft.config.feature.BalanceConfig;
import org.z2six.weaponcraft.features.blueprint.stats.BlueprintMetrics;
import org.z2six.weaponcraft.features.blueprint.stats.StatResult;
import org.z2six.weaponcraft.features.rendering.util.BitmapPayload;

public final class BlueprintStatCalculator {
    private static final int S_REF = 10;
    private static final int LX_REF = 30;

    private BlueprintStatCalculator() {
    }

    public static StatResult compute(BitmapPayload p, BalanceConfig c) {
        int[] counts = BlueprintStatCalculator.countFineMaterials(p);
        float mass = BlueprintMetrics.mass(p, c);
        float heaviest = Math.max(Math.max(c.weightIron, c.weightGold), Math.max(c.weightDiamond, c.weightNetherite));
        float massMax = Math.max(1.0E-6f, (float)c.maxCells * heaviest);
        float tMass = BlueprintStatCalculator.clamp01(mass / massMax);
        float damage = BlueprintStatCalculator.lerp(c.minDamage, c.maxDamage, tMass);
        float speed = BlueprintStatCalculator.lerp(c.maxSpeed, c.minSpeed, tMass);
        float tBulk = BlueprintMetrics.thicknessWeightedBulk01(p, c);
        float kb = BlueprintStatCalculator.lerp(c.minKbMul, c.maxKbMul, tBulk);
        float crit = BlueprintStatCalculator.lerp(c.maxCrit, c.minCrit, tBulk);
        int Lx = BlueprintMetrics.horizontalReachFromGripCoarse(p);
        int LX_REF = 30;
        float tReach = BlueprintStatCalculator.clamp01((float)Lx / 30.0f);
        float reach = BlueprintStatCalculator.lerp(c.minReach, c.maxReach, tReach);
        int durability = Math.round(BlueprintStatCalculator.lerp(c.maxDur, c.minDur, tReach));
        damage = BlueprintStatCalculator.clamp(damage, c.minDamage, c.maxDamage);
        speed = BlueprintStatCalculator.clamp(speed, c.minSpeed, c.maxSpeed);
        reach = BlueprintStatCalculator.clamp(reach, c.minReach, c.maxReach);
        durability = BlueprintStatCalculator.clampI(durability, c.minDur, c.maxDur);
        kb = BlueprintStatCalculator.clamp(kb, c.minKbMul, c.maxKbMul);
        crit = BlueprintStatCalculator.clamp(crit, c.minCrit, c.maxCrit);
        HashMap<String, Integer> cost = new HashMap<String, Integer>();
        cost.put("iron", counts[1]);
        cost.put("gold", counts[2]);
        cost.put("diamond", counts[3]);
        cost.put("netherite", counts[4]);
        return new StatResult(damage, speed, reach, durability, kb, crit, counts[1], counts[2], counts[3], counts[4], cost, tMass, tBulk, tReach, p.thicknessL != 0.0f ? p.thicknessL : 1.0f, p.thicknessM != 0.0f ? p.thicknessM : 1.0f, p.thicknessR != 0.0f ? p.thicknessR : 1.0f);
    }

    private static int[] countFineMaterials(BitmapPayload p) {
        int ds = p.detailScale;
        int fh = p.height * ds;
        int fw = p.width * ds;
        int[] c = new int[5];
        for (int y = 0; y < fh; ++y) {
            byte[] row = p.fineMaterials[y];
            for (int x = 0; x < fw; ++x) {
                int m = row[x] & 0xFF;
                if (m < 0 || m >= c.length) continue;
                int n = m;
                c[n] = c[n] + 1;
            }
        }
        return c;
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private static float clamp(float v, float lo, float hi) {
        return v < lo ? lo : (v > hi ? hi : v);
    }

    private static int clampI(int v, int lo, int hi) {
        return v < lo ? lo : (v > hi ? hi : v);
    }

    private static float clamp01(float f) {
        return f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
    }
}

